/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.graphql.runtime;

import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.smallrye.graphql.runtime.SmallRyeGraphQLAbstractHandler;
import io.quarkus.smallrye.graphql.runtime.exception.SmallRyeAuthSecurityIdentityAlreadyAssignedException;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticator;
import io.quarkus.vertx.http.runtime.security.QuarkusHttpUser;
import io.smallrye.graphql.websocket.GraphQLWebSocketSession;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.subscription.Cancellable;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import io.vertx.ext.web.RoutingContext;
import jakarta.json.JsonString;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class SmallRyeAuthGraphQLWSHandler {
    private final GraphQLWebSocketSession session;
    private final RoutingContext ctx;
    private final SmallRyeGraphQLAbstractHandler handler;
    private final Optional<String> authorizationClientInitPayloadName;
    private final AtomicReference<Cancellable> authExpiry = new AtomicReference();

    public SmallRyeAuthGraphQLWSHandler(GraphQLWebSocketSession session, RoutingContext ctx, SmallRyeGraphQLAbstractHandler handler, Optional<String> authorizationClientInitPayloadName) {
        this.session = session;
        this.ctx = ctx;
        this.handler = handler;
        this.authorizationClientInitPayloadName = authorizationClientInitPayloadName;
        this.updateIdentityExpiry(ctx);
    }

    void handlePayload(final Map<String, Object> payload, final Runnable successCallback, final Consumer<Throwable> failureHandler) {
        Object object;
        if (this.authorizationClientInitPayloadName.isPresent() && payload != null && (object = payload.get(this.authorizationClientInitPayloadName.get())) instanceof JsonString) {
            JsonString authorizationJson = (JsonString)object;
            final String authorization = authorizationJson.getString();
            final HttpAuthenticator authenticator = (HttpAuthenticator)this.ctx.get(HttpAuthenticator.class.getName());
            QuarkusHttpUser.getSecurityIdentity((RoutingContext)this.ctx, (IdentityProviderManager)authenticator.getIdentityProviderManager()).subscribe().withSubscriber((UniSubscriber)new UniSubscriber<SecurityIdentity>(){

                public void onSubscribe(UniSubscription subscription) {
                }

                public void onItem(SecurityIdentity previousIdentity) {
                    if (!previousIdentity.isAnonymous()) {
                        this.onFailure(new SmallRyeAuthSecurityIdentityAlreadyAssignedException(payload));
                        return;
                    }
                    if (SmallRyeAuthGraphQLWSHandler.this.ctx.user() == null) {
                        QuarkusHttpUser.setIdentity((SecurityIdentity)previousIdentity, (RoutingContext)SmallRyeAuthGraphQLWSHandler.this.ctx);
                    }
                    SmallRyeAuthGraphQLWSHandler.this.ctx.request().headers().add("Authorization", authorization);
                    Uni potentialUser = authenticator.attemptAuthentication(SmallRyeAuthGraphQLWSHandler.this.ctx);
                    potentialUser.subscribe().withSubscriber((UniSubscriber)new UniSubscriber<SecurityIdentity>(){

                        public void onSubscribe(UniSubscription subscription) {
                        }

                        public void onItem(SecurityIdentity identity) {
                            if (!SmallRyeAuthGraphQLWSHandler.this.session.isClosed() && identity != null) {
                                QuarkusHttpUser.setIdentity((SecurityIdentity)identity, (RoutingContext)SmallRyeAuthGraphQLWSHandler.this.ctx);
                                SmallRyeAuthGraphQLWSHandler.this.handler.withIdentity(SmallRyeAuthGraphQLWSHandler.this.ctx);
                                SmallRyeAuthGraphQLWSHandler.this.updateIdentityExpiry(SmallRyeAuthGraphQLWSHandler.this.ctx);
                                successCallback.run();
                            }
                        }

                        public void onFailure(Throwable failure) {
                            BiConsumer handler = (BiConsumer)SmallRyeAuthGraphQLWSHandler.this.ctx.get("io.quarkus.vertx.http.auth-failure-handler");
                            if (handler != null) {
                                handler.accept(SmallRyeAuthGraphQLWSHandler.this.ctx, failure);
                            }
                            failureHandler.accept(failure);
                        }
                    });
                }

                public void onFailure(Throwable failure) {
                    BiConsumer handler = (BiConsumer)SmallRyeAuthGraphQLWSHandler.this.ctx.get("io.quarkus.vertx.http.auth-failure-handler");
                    if (handler != null) {
                        handler.accept(SmallRyeAuthGraphQLWSHandler.this.ctx, failure);
                    }
                    failureHandler.accept(failure);
                }
            });
        } else {
            successCallback.run();
        }
    }

    private void updateIdentityExpiry(RoutingContext ctx) {
        Cancellable replacing = this.authExpiry.getAndSet(SmallRyeAuthGraphQLWSHandler.createAuthExpiryTask(ctx, this.session));
        if (replacing != null) {
            replacing.cancel();
        }
    }

    public void cancelAuthExpiry() {
        Cancellable expire = this.authExpiry.get();
        if (expire != null) {
            expire.cancel();
        }
    }

    public static Cancellable createAuthExpiryTask(RoutingContext ctx, GraphQLWebSocketSession webSocketSession) {
        AtomicLong atomicTaskId = new AtomicLong(-1L);
        Cancellable sub = QuarkusHttpUser.getSecurityIdentity((RoutingContext)ctx, null).subscribe().with(securityIdentity -> {
            long taskId;
            long previousValue;
            Long expire;
            QuarkusHttpUser user = (QuarkusHttpUser)ctx.user();
            if (user != null && (expire = (Long)user.getSecurityIdentity().getAttribute("quarkus.identity.expire-time")) != null && (previousValue = atomicTaskId.getAndSet(taskId = ctx.vertx().setTimer(expire * 1000L - System.currentTimeMillis(), event -> {
                if (!webSocketSession.isClosed()) {
                    webSocketSession.close((short)1008, "Authentication expired");
                }
            }))) == -2L) {
                ctx.vertx().cancelTimer(taskId);
            }
        });
        return () -> {
            sub.cancel();
            long taskId = atomicTaskId.getAndSet(-2L);
            if (taskId >= 0L) {
                ctx.vertx().cancelTimer(taskId);
            }
        };
    }
}

