/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.graphql.runtime.spi;

import graphql.schema.PropertyDataFetcherHelper;
import io.smallrye.graphql.execution.Classes;
import io.smallrye.graphql.spi.ClassloadingService;

public class QuarkusClassloadingService
implements ClassloadingService {
    private static volatile ClassLoader classLoader;

    public String getName() {
        return "Quarkus";
    }

    public Class<?> loadClass(String className) {
        try {
            if (Classes.isPrimitive((String)className)) {
                return Classes.getPrimativeClassType((String)className);
            }
            ClassLoader cl = classLoader == null ? Thread.currentThread().getContextClassLoader() : classLoader;
            return this.loadClass(className, cl);
        }
        catch (ClassNotFoundException pae) {
            throw new RuntimeException("Can not load class [" + className + "]", pae);
        }
    }

    public static void setClassLoader(ClassLoader classLoader) {
        QuarkusClassloadingService.classLoader = classLoader;
        PropertyDataFetcherHelper.clearReflectionCache();
    }
}

