/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.webauthn.deployment;

import com.webauthn4j.data.AuthenticationRequest;
import com.webauthn4j.data.AuthenticatorAssertionResponse;
import com.webauthn4j.data.AuthenticatorAttestationResponse;
import com.webauthn4j.data.PublicKeyCredential;
import com.webauthn4j.data.PublicKeyCredentialCreationOptions;
import com.webauthn4j.data.PublicKeyCredentialParameters;
import com.webauthn4j.data.PublicKeyCredentialRequestOptions;
import com.webauthn4j.data.PublicKeyCredentialRpEntity;
import com.webauthn4j.data.PublicKeyCredentialType;
import com.webauthn4j.data.PublicKeyCredentialUserEntity;
import com.webauthn4j.data.RegistrationRequest;
import com.webauthn4j.data.attestation.AttestationObject;
import com.webauthn4j.data.client.CollectedClientData;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.quarkus.security.webauthn.WebAuthn;
import io.quarkus.security.webauthn.WebAuthnAuthenticationMechanism;
import io.quarkus.security.webauthn.WebAuthnAuthenticatorStorage;
import io.quarkus.security.webauthn.WebAuthnBuildTimeConfig;
import io.quarkus.security.webauthn.WebAuthnRecorder;
import io.quarkus.security.webauthn.WebAuthnSecurity;
import io.quarkus.security.webauthn.WebAuthnTrustedIdentityProvider;
import io.quarkus.vertx.http.deployment.HttpAuthMechanismAnnotationBuildItem;
import io.quarkus.vertx.http.deployment.NonApplicationRootPathBuildItem;
import io.quarkus.vertx.http.deployment.VertxWebRouterBuildItem;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticationMechanism;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.function.BooleanSupplier;
import org.jboss.jandex.DotName;

@BuildSteps(onlyIf={IsEnabled.class})
class QuarkusSecurityWebAuthnProcessor {
    QuarkusSecurityWebAuthnProcessor() {
    }

    @BuildStep
    public IndexDependencyBuildItem addTypesToJandex() {
        return new IndexDependencyBuildItem("com.webauthn4j", "webauthn4j-core");
    }

    @BuildStep
    public void registerJacksonTypes(BuildProducer<ReflectiveHierarchyBuildItem> reflection) {
        reflection.produce((BuildItem)ReflectiveHierarchyBuildItem.builder(AuthenticatorAssertionResponse.class).build());
        reflection.produce((BuildItem)ReflectiveHierarchyBuildItem.builder(AuthenticatorAttestationResponse.class).build());
        reflection.produce((BuildItem)ReflectiveHierarchyBuildItem.builder(AuthenticationRequest.class).build());
        reflection.produce((BuildItem)ReflectiveHierarchyBuildItem.builder(RegistrationRequest.class).build());
        reflection.produce((BuildItem)ReflectiveHierarchyBuildItem.builder(PublicKeyCredentialCreationOptions.class).build());
        reflection.produce((BuildItem)ReflectiveHierarchyBuildItem.builder(PublicKeyCredentialRequestOptions.class).build());
        reflection.produce((BuildItem)ReflectiveHierarchyBuildItem.builder(PublicKeyCredentialRpEntity.class).build());
        reflection.produce((BuildItem)ReflectiveHierarchyBuildItem.builder(PublicKeyCredentialUserEntity.class).build());
        reflection.produce((BuildItem)ReflectiveHierarchyBuildItem.builder(PublicKeyCredentialParameters.class).build());
        reflection.produce((BuildItem)ReflectiveHierarchyBuildItem.builder(PublicKeyCredentialType.class).build());
        reflection.produce((BuildItem)ReflectiveHierarchyBuildItem.builder(PublicKeyCredential.class).build());
        reflection.produce((BuildItem)ReflectiveHierarchyBuildItem.builder(AttestationObject.class).build());
        reflection.produce((BuildItem)ReflectiveHierarchyBuildItem.builder(CollectedClientData.class).build());
    }

    @BuildStep
    public void myBeans(BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        AdditionalBeanBuildItem.Builder builder = AdditionalBeanBuildItem.builder().setUnremovable();
        builder.addBeanClass(WebAuthnSecurity.class).addBeanClass(WebAuthnAuthenticatorStorage.class).addBeanClass(WebAuthnTrustedIdentityProvider.class);
        additionalBeans.produce((BuildItem)builder.build());
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    public void setup(WebAuthnRecorder recorder, VertxWebRouterBuildItem vertxWebRouterBuildItem, BeanContainerBuildItem beanContainerBuildItem, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem) {
        recorder.setupRoutes(beanContainerBuildItem.getValue(), vertxWebRouterBuildItem.getHttpRouter(), nonApplicationRootPathBuildItem.getNonApplicationRootPath());
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    SyntheticBeanBuildItem initWebAuthnAuth(WebAuthnRecorder recorder) {
        return ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(WebAuthnAuthenticationMechanism.class).types(new Class[]{HttpAuthenticationMechanism.class})).setRuntimeInit().scope(Singleton.class)).supplier(recorder.setupWebAuthnAuthenticationMechanism()).done();
    }

    @BuildStep
    List<HttpAuthMechanismAnnotationBuildItem> registerHttpAuthMechanismAnnotation() {
        return List.of(new HttpAuthMechanismAnnotationBuildItem(DotName.createSimple(WebAuthn.class), "webauthn"));
    }

    public static class IsEnabled
    implements BooleanSupplier {
        WebAuthnBuildTimeConfig config;

        @Override
        public boolean getAsBoolean() {
            return this.config.enabled();
        }
    }
}

