/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.test.utils;

import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.credential.Credential;
import io.quarkus.security.identity.AuthenticationRequestContext;
import io.quarkus.security.identity.IdentityProvider;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.UsernamePasswordAuthenticationRequest;
import io.quarkus.security.runtime.QuarkusPrincipal;
import io.quarkus.security.runtime.QuarkusSecurityIdentity;
import io.quarkus.security.test.utils.TestIdentityController;
import io.smallrye.mutiny.Uni;
import jakarta.enterprise.context.ApplicationScoped;
import java.security.Principal;
import java.util.Optional;

@ApplicationScoped
public class TestIdentityProvider
implements IdentityProvider<UsernamePasswordAuthenticationRequest> {
    public Class<UsernamePasswordAuthenticationRequest> getRequestType() {
        return UsernamePasswordAuthenticationRequest.class;
    }

    public Uni<SecurityIdentity> authenticate(UsernamePasswordAuthenticationRequest request, AuthenticationRequestContext context) {
        TestIdentityController.TestIdentity ident = TestIdentityController.identities.get(request.getUsername());
        if (ident == null) {
            return Uni.createFrom().optional(Optional.empty());
        }
        if (!ident.password.equals(new String(request.getPassword().getPassword()))) {
            return Uni.createFrom().failure((Throwable)new AuthenticationFailedException());
        }
        QuarkusSecurityIdentity identity = QuarkusSecurityIdentity.builder().setPrincipal((Principal)new QuarkusPrincipal(ident.username)).addRoles(ident.roles).addCredential((Credential)request.getPassword()).addPermissionCheckers(ident.permissionCheckers).build();
        return Uni.createFrom().item((Object)identity);
    }
}

