/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.deployment;

import io.quarkus.security.spi.SecurityTransformer;
import java.util.List;
import java.util.function.Predicate;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;

final class DenyUnannotatedPredicate
implements Predicate<ClassInfo> {
    private final SecurityTransformer securityTransformer;

    DenyUnannotatedPredicate(SecurityTransformer securityTransformer) {
        this.securityTransformer = securityTransformer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean test(ClassInfo classInfo) {
        List methods = classInfo.methods();
        if (this.securityTransformer.hasSecurityAnnotation((AnnotationTarget)classInfo, new SecurityTransformer.AuthorizationType[0])) return false;
        if (!methods.stream().anyMatch(x$0 -> this.securityTransformer.hasSecurityAnnotation(x$0, new SecurityTransformer.AuthorizationType[0]))) return false;
        return true;
    }
}

