/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.deployment;

import io.quarkus.security.deployment.SecurityProcessor;
import io.quarkus.security.spi.runtime.MethodDescription;
import jakarta.annotation.security.DenyAll;
import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jboss.jandex.AnnotationTransformation;
import org.jboss.jandex.MethodInfo;

final class AdditionalDenyingUnannotatedTransformer
implements Predicate<MethodInfo>,
Consumer<AnnotationTransformation.TransformationContext> {
    private final Set<MethodDescription> methods;

    AdditionalDenyingUnannotatedTransformer(Collection<MethodDescription> methods) {
        this.methods = Set.copyOf(methods);
    }

    @Override
    public void accept(AnnotationTransformation.TransformationContext ctx) {
        ctx.add(DenyAll.class);
    }

    @Override
    public boolean test(MethodInfo methodInfo) {
        MethodDescription methodDescription = SecurityProcessor.createMethodDescription(methodInfo);
        return this.methods.contains(methodDescription);
    }
}

