/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.builder.item.SimpleBuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ExecutorBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.resteasy.common.deployment.ResteasyInjectionReadyBuildItem;
import io.quarkus.resteasy.deployment.NonJaxRsClassBuildItem;
import io.quarkus.resteasy.runtime.AuthenticationCompletionExceptionMapper;
import io.quarkus.resteasy.runtime.AuthenticationFailedExceptionMapper;
import io.quarkus.resteasy.runtime.AuthenticationRedirectExceptionMapper;
import io.quarkus.resteasy.runtime.standalone.ResteasyStandaloneRecorder;
import io.quarkus.resteasy.server.common.deployment.ResteasyDeploymentBuildItem;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.security.AuthenticationCompletionException;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.AuthenticationRedirectException;
import io.quarkus.vertx.core.deployment.CoreVertxBuildItem;
import io.quarkus.vertx.http.deployment.FilterBuildItem;
import io.quarkus.vertx.http.deployment.HttpRootPathBuildItem;
import io.quarkus.vertx.http.deployment.RequireVirtualHttpBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.runtime.VertxHttpBuildTimeConfig;
import io.vertx.core.Handler;
import jakarta.ws.rs.ext.ExceptionMapper;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;

public class ResteasyStandaloneBuildStep {
    private static final int REST_ROUTE_ORDER_OFFSET = 500;
    private static final DotName EXCEPTION_MAPPER = DotName.createSimple((String)ExceptionMapper.class.getName());

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void staticInit(ResteasyStandaloneRecorder recorder, Capabilities capabilities, ResteasyDeploymentBuildItem deployment, ApplicationArchivesBuildItem applicationArchivesBuildItem, ResteasyInjectionReadyBuildItem resteasyInjectionReady, HttpRootPathBuildItem httpRootPathBuildItem, BuildProducer<ResteasyStandaloneBuildItem> standalone) throws Exception {
        if (capabilities.isPresent("io.quarkus.servlet")) {
            return;
        }
        if (deployment != null) {
            recorder.staticInit(deployment.getDeployment(), httpRootPathBuildItem.relativePath(deployment.getRootPath()));
            standalone.produce((BuildItem)new ResteasyStandaloneBuildItem(deployment.getRootPath()));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void boot(ShutdownContextBuildItem shutdown, ResteasyStandaloneRecorder recorder, BuildProducer<FeatureBuildItem> feature, BuildProducer<RouteBuildItem> routes, BuildProducer<FilterBuildItem> filterBuildItemBuildProducer, CoreVertxBuildItem vertx, CombinedIndexBuildItem combinedIndexBuildItem, ResteasyStandaloneBuildItem standalone, Optional<RequireVirtualHttpBuildItem> requireVirtual, Optional<NonJaxRsClassBuildItem> nonJaxRsClassBuildItem, ExecutorBuildItem executorBuildItem, VertxHttpBuildTimeConfig httpBuildTimeConfig) throws Exception {
        boolean noCustomAuthRedirectExMapper;
        boolean noCustomAuthFailureExMapper;
        boolean noCustomAuthCompletionExMapper;
        if (standalone == null) {
            return;
        }
        feature.produce((BuildItem)new FeatureBuildItem(Feature.RESTEASY));
        Map<Object, Object> nonJaxRsClassNameToMethodPaths = Collections.emptyMap();
        if (nonJaxRsClassBuildItem.isPresent()) {
            nonJaxRsClassNameToMethodPaths = nonJaxRsClassBuildItem.get().nonJaxRsPaths;
        }
        Handler handler = recorder.vertxRequestHandler(vertx.getVertx(), (Executor)executorBuildItem.getExecutorProxy(), nonJaxRsClassNameToMethodPaths);
        if (httpBuildTimeConfig.auth().proactive()) {
            noCustomAuthCompletionExMapper = ResteasyStandaloneBuildStep.notFoundCustomExMapper(AuthenticationCompletionException.class.getName(), AuthenticationCompletionExceptionMapper.class.getName(), combinedIndexBuildItem.getIndex());
            noCustomAuthFailureExMapper = ResteasyStandaloneBuildStep.notFoundCustomExMapper(AuthenticationFailedException.class.getName(), AuthenticationFailedExceptionMapper.class.getName(), combinedIndexBuildItem.getIndex());
            noCustomAuthRedirectExMapper = ResteasyStandaloneBuildStep.notFoundCustomExMapper(AuthenticationRedirectException.class.getName(), AuthenticationRedirectExceptionMapper.class.getName(), combinedIndexBuildItem.getIndex());
        } else {
            noCustomAuthCompletionExMapper = false;
            noCustomAuthFailureExMapper = false;
            noCustomAuthRedirectExMapper = false;
        }
        Handler failureHandler = recorder.vertxFailureHandler(vertx.getVertx(), (Executor)executorBuildItem.getExecutorProxy(), noCustomAuthCompletionExMapper, noCustomAuthFailureExMapper, noCustomAuthRedirectExMapper);
        filterBuildItemBuildProducer.produce((BuildItem)FilterBuildItem.ofAuthenticationFailureHandler((Handler)failureHandler));
        routes.produce((BuildItem)RouteBuildItem.builder().orderedRoute(standalone.deploymentRootPath, Integer.valueOf(20500)).handler(handler).build());
        Object matchPath = standalone.deploymentRootPath;
        matchPath = ((String)matchPath).endsWith("/") ? (String)matchPath + "*" : (String)matchPath + "/*";
        routes.produce((BuildItem)RouteBuildItem.builder().orderedRoute((String)matchPath, Integer.valueOf(20500)).handler(handler).build());
        recorder.start((ShutdownContext)shutdown, requireVirtual.isPresent());
    }

    private static boolean notFoundCustomExMapper(String exSignatureStr, String exMapperSignatureStr, IndexView index) {
        block0: for (ClassInfo implementor : index.getAllKnownImplementors(EXCEPTION_MAPPER)) {
            if (exMapperSignatureStr.equals(implementor.name().toString())) continue;
            for (Type interfaceType : implementor.interfaceTypes()) {
                if (!EXCEPTION_MAPPER.equals((Object)interfaceType.name())) continue;
                String mapperExSignature = ((Type)interfaceType.asParameterizedType().arguments().get(0)).name().toString();
                if (!exSignatureStr.equals(mapperExSignature)) continue block0;
                return false;
            }
        }
        return true;
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public FilterBuildItem addDefaultAuthFailureHandler(ResteasyStandaloneRecorder recorder) {
        return new FilterBuildItem(recorder.defaultAuthFailureHandler(), 199);
    }

    public static final class ResteasyStandaloneBuildItem
    extends SimpleBuildItem {
        final String deploymentRootPath;

        public ResteasyStandaloneBuildItem(String deploymentRootPath) {
            this.deploymentRootPath = deploymentRootPath.startsWith("/") ? deploymentRootPath : "/" + deploymentRootPath;
        }
    }
}

