/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.metrics.MetricsCapabilityBuildItem;
import io.quarkus.resteasy.common.spi.ResteasyDotNames;
import io.quarkus.resteasy.runtime.QuarkusRestPathTemplate;
import io.quarkus.resteasy.runtime.QuarkusRestPathTemplateInterceptor;
import io.quarkus.resteasy.server.common.spi.ResteasyJaxrsConfigBuildItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class RestPathAnnotationProcessor {
    static final DotName REST_PATH = DotName.createSimple((String)"jakarta.ws.rs.Path");
    static final DotName REGISTER_REST_CLIENT = DotName.createSimple((String)"org.eclipse.microprofile.rest.client.inject.RegisterRestClient");
    static final DotName TEMPLATE_PATH = DotName.createSimple((String)QuarkusRestPathTemplate.class.getName());
    static final DotName TEMPLATE_PATH_INTERCEPTOR = DotName.createSimple((String)QuarkusRestPathTemplateInterceptor.class.getName());
    public static final Pattern MULTIPLE_SLASH_PATTERN = Pattern.compile("//+");

    @BuildStep
    AdditionalBeanBuildItem registerBeanClasses(Capabilities capabilities, Optional<MetricsCapabilityBuildItem> metricsCapability) {
        if (this.notRequired(capabilities, metricsCapability)) {
            return null;
        }
        return AdditionalBeanBuildItem.builder().addBeanClass(TEMPLATE_PATH.toString()).addBeanClass(TEMPLATE_PATH_INTERCEPTOR.toString()).build();
    }

    @BuildStep
    void findRestPaths(final CombinedIndexBuildItem index, Capabilities capabilities, Optional<MetricsCapabilityBuildItem> metricsCapability, BuildProducer<AnnotationsTransformerBuildItem> transformers, Optional<ResteasyJaxrsConfigBuildItem> restApplicationPathBuildItem) {
        ResteasyJaxrsConfigBuildItem pathItem;
        if (this.notRequired(capabilities, metricsCapability)) {
            return;
        }
        String pathPrefix = null;
        if (restApplicationPathBuildItem.isPresent() && !(pathItem = restApplicationPathBuildItem.get()).getDefaultPath().equals(pathItem.getRootPath())) {
            pathPrefix = this.slashify(pathItem.getDefaultPath());
        }
        final String restPathPrefix = pathPrefix;
        transformers.produce((BuildItem)new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return kind == AnnotationTarget.Kind.METHOD;
            }

            public void transform(AnnotationsTransformer.TransformationContext ctx) {
                AnnotationTarget target = ctx.getTarget();
                MethodInfo methodInfo = target.asMethod();
                ClassInfo classInfo = methodInfo.declaringClass();
                if (!RestPathAnnotationProcessor.isRestEndpointMethod(index, methodInfo)) {
                    return;
                }
                if (classInfo.declaredAnnotation(REGISTER_REST_CLIENT) != null) {
                    return;
                }
                AnnotationInstance annotation = methodInfo.annotation(REST_PATH);
                StringBuilder stringBuilder = annotation != null ? new StringBuilder(RestPathAnnotationProcessor.this.slashify(annotation.value().asString())) : RestPathAnnotationProcessor.searchPathAnnotationOnInterfaces(index, methodInfo).map(annotationInstance -> new StringBuilder(RestPathAnnotationProcessor.this.slashify(annotationInstance.value().asString()))).orElse(new StringBuilder());
                annotation = classInfo.declaredAnnotation(REST_PATH);
                if (annotation != null) {
                    stringBuilder.insert(0, RestPathAnnotationProcessor.this.slashify(annotation.value().asString()));
                } else {
                    RestPathAnnotationProcessor.getAllClassInterfaces(index, List.of(classInfo), new ArrayList<ClassInfo>()).stream().filter(interfaceClassInfo -> interfaceClassInfo.hasDeclaredAnnotation(REST_PATH)).findFirst().map(interfaceClassInfo -> interfaceClassInfo.declaredAnnotation(REST_PATH).value()).ifPresent(annotationValue -> stringBuilder.insert(0, RestPathAnnotationProcessor.this.slashify(annotationValue.asString())));
                }
                if (restPathPrefix != null) {
                    stringBuilder.insert(0, restPathPrefix);
                }
                String templatePath = MULTIPLE_SLASH_PATTERN.matcher("/" + stringBuilder.toString()).replaceAll("/");
                ctx.transform().add(TEMPLATE_PATH, new AnnotationValue[]{AnnotationValue.createStringValue((String)"value", (String)templatePath)}).done();
            }
        }));
    }

    String slashify(String path) {
        if (path == null || path.isEmpty() || "/".equals(path)) {
            return "";
        }
        if ((path = MULTIPLE_SLASH_PATTERN.matcher(path).replaceAll("/")).endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.isEmpty() || path.startsWith("/")) {
            return path;
        }
        return "/" + path;
    }

    static Optional<AnnotationInstance> searchPathAnnotationOnInterfaces(CombinedIndexBuildItem index, MethodInfo methodInfo) {
        Collection<ClassInfo> allClassInterfaces = RestPathAnnotationProcessor.getAllClassInterfaces(index, List.of(methodInfo.declaringClass()), new ArrayList<ClassInfo>());
        return allClassInterfaces.stream().map(interfaceClassInfo -> interfaceClassInfo.method(methodInfo.name(), methodInfo.parameterTypes().toArray(new Type[0]))).filter(Objects::nonNull).findFirst().flatMap(resolvedMethodInfo -> Optional.ofNullable(resolvedMethodInfo.annotation(REST_PATH)));
    }

    static Collection<ClassInfo> getAllClassInterfaces(CombinedIndexBuildItem index, Collection<ClassInfo> classInfos, List<ClassInfo> resultAcc) {
        Objects.requireNonNull(index);
        Objects.requireNonNull(classInfos);
        Objects.requireNonNull(resultAcc);
        if (classInfos.isEmpty()) {
            return resultAcc;
        }
        List<ClassInfo> interfaces = classInfos.stream().flatMap(classInfo -> classInfo.interfaceNames().stream()).map(dotName -> index.getIndex().getClassByName(dotName)).filter(Objects::nonNull).collect(Collectors.toUnmodifiableList());
        resultAcc.addAll(interfaces);
        return RestPathAnnotationProcessor.getAllClassInterfaces(index, interfaces, resultAcc);
    }

    static boolean isRestEndpointMethod(CombinedIndexBuildItem index, MethodInfo methodInfo) {
        if (!methodInfo.hasAnnotation(REST_PATH)) {
            for (AnnotationInstance annotation : methodInfo.annotations()) {
                if (!ResteasyDotNames.JAXRS_METHOD_ANNOTATIONS.contains(annotation.name())) continue;
                return true;
            }
            return RestPathAnnotationProcessor.searchPathAnnotationOnInterfaces(index, methodInfo).isPresent();
        }
        return true;
    }

    private boolean notRequired(Capabilities capabilities, Optional<MetricsCapabilityBuildItem> metricsCapability) {
        return capabilities.isMissing("io.quarkus.resteasy") || capabilities.isMissing("io.quarkus.opentelemetry.tracer") && (!metricsCapability.isPresent() || !metricsCapability.get().metricsSupported("micrometer"));
    }
}

