/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.data.panache.runtime.sort;

import io.quarkus.rest.data.panache.runtime.sort.SortQueryParamValidator;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;

@Provider
@SortQueryParamValidator
public class SortQueryParamFilter
implements ContainerRequestFilter {
    private static final String SORT_REGEX = "-?([a-z]|[A-Z]|_|\\$|[\u0080-\ufffe])([a-z]|[A-Z]|_|\\$|[0-9]|[\u0080-\ufffe])*";

    public void filter(ContainerRequestContext requestContext) {
        MultivaluedMap queryParams = requestContext.getUriInfo().getQueryParameters();
        for (String sort : (List)queryParams.getOrDefault((Object)"sort", Collections.emptyList())) {
            for (String sortPart : sort.split(",")) {
                String trimmed = sortPart.trim();
                if (trimmed.length() <= 0 || trimmed.matches(SORT_REGEX)) continue;
                requestContext.abortWith(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)String.format("Invalid sort parameter '%s'", sort)).build());
            }
        }
    }
}

