/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.data.panache.deployment.methods;

import io.quarkus.arc.processor.DotNames;
import io.quarkus.deployment.Capabilities;
import io.quarkus.gizmo.AnnotatedElement;
import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import io.quarkus.gizmo.Type;
import io.quarkus.panache.common.Page;
import io.quarkus.panache.common.Sort;
import io.quarkus.rest.data.panache.deployment.ResourceMetadata;
import io.quarkus.rest.data.panache.deployment.methods.StandardMethodImplementor;
import io.quarkus.rest.data.panache.deployment.properties.ResourceProperties;
import io.quarkus.rest.data.panache.deployment.utils.PaginationImplementor;
import io.quarkus.rest.data.panache.deployment.utils.QueryImplementor;
import io.quarkus.rest.data.panache.deployment.utils.SignatureMethodCreator;
import io.quarkus.rest.data.panache.deployment.utils.SortImplementor;
import io.quarkus.rest.data.panache.deployment.utils.TypeUtils;
import io.quarkus.rest.data.panache.deployment.utils.UniImplementor;
import io.smallrye.mutiny.Uni;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jboss.jandex.Type;
import org.jboss.resteasy.reactive.RestResponse;

public class ListMethodImplementor
extends StandardMethodImplementor {
    private static final String METHOD_NAME = "list";
    private static final String RESOURCE_METHOD_NAME = "list";
    private static final String EXCEPTION_MESSAGE = "Failed to list the entities";
    private static final String REL = "list";
    private final PaginationImplementor paginationImplementor = new PaginationImplementor();
    private final SortImplementor sortImplementor = new SortImplementor();
    private final QueryImplementor queryImplementor = new QueryImplementor();

    public ListMethodImplementor(Capabilities capabilities) {
        super(capabilities);
    }

    @Override
    protected void implementInternal(ClassCreator classCreator, ResourceMetadata resourceMetadata, ResourceProperties resourceProperties, FieldDescriptor resourceField) {
        if (resourceProperties.isPaged()) {
            this.implementPaged(classCreator, resourceMetadata, resourceProperties, resourceField);
        } else {
            this.implementNotPaged(classCreator, resourceMetadata, resourceProperties, resourceField);
        }
    }

    @Override
    protected String getResourceMethodName() {
        return "list";
    }

    protected String getMethodName() {
        return "list";
    }

    @Override
    protected void addProducesJsonAnnotation(AnnotatedElement element, ResourceProperties properties) {
        super.addProducesAnnotation(element, "application/json");
    }

    protected void returnValueWithLinks(BytecodeCreator creator, ResourceMetadata resourceMetadata, ResourceProperties resourceProperties, ResultHandle value, ResultHandle links) {
        creator.returnValue(this.responseImplementor.ok(creator, value, links));
    }

    protected void returnValue(BytecodeCreator creator, ResourceMetadata resourceMetadata, ResourceProperties resourceProperties, ResultHandle value) {
        creator.returnValue(this.responseImplementor.ok(creator, value));
    }

    private void implementPaged(ClassCreator classCreator, ResourceMetadata resourceMetadata, ResourceProperties resourceProperties, FieldDescriptor resourceField) {
        Collection<SignatureMethodCreator.Parameter> compatibleFieldsForQuery = this.getFieldsToQuery(resourceMetadata);
        ArrayList<SignatureMethodCreator.Parameter> parameters = new ArrayList<SignatureMethodCreator.Parameter>();
        parameters.add(SignatureMethodCreator.param("sort", List.class, (Type)Type.parameterizedType((Type.ClassType)Type.classType(List.class), (Type[])new Type[]{Type.classType(String.class)})));
        parameters.add(SignatureMethodCreator.param("page", Integer.TYPE, (Type)Type.intType()));
        parameters.add(SignatureMethodCreator.param("size", Integer.TYPE, (Type)Type.intType()));
        parameters.add(SignatureMethodCreator.param("uriInfo", UriInfo.class));
        parameters.add(SignatureMethodCreator.param("namedQuery", String.class));
        for (SignatureMethodCreator.Parameter param : compatibleFieldsForQuery) {
            parameters.add(SignatureMethodCreator.param(param.getName().replace(".", "__"), param.getClazz()));
        }
        MethodCreator methodCreator = SignatureMethodCreator.getMethodCreator(this.getMethodName(), classCreator, this.isNotReactivePanache() ? SignatureMethodCreator.responseType(resourceMetadata.getEntityType()) : SignatureMethodCreator.uniType(resourceMetadata.getEntityType()), parameters.toArray(new SignatureMethodCreator.Parameter[0]));
        this.addGetAnnotation((AnnotatedElement)methodCreator);
        this.addPathAnnotation((AnnotatedElement)methodCreator, resourceProperties.getPath("list"));
        this.addProducesJsonAnnotation((AnnotatedElement)methodCreator, resourceProperties);
        this.addLinksAnnotation((AnnotatedElement)methodCreator, resourceProperties, resourceMetadata.getEntityType(), "list");
        this.addMethodAnnotations((AnnotatedElement)methodCreator, resourceProperties.getMethodAnnotations("list"));
        this.addOpenApiResponseAnnotation((AnnotatedElement)methodCreator, RestResponse.Status.OK, resourceMetadata.getEntityType(), true);
        this.addSecurityAnnotations((AnnotatedElement)methodCreator, resourceProperties);
        this.addSortQueryParamValidatorAnnotation((AnnotatedElement)methodCreator);
        this.addQueryParamAnnotation(methodCreator.getParameterAnnotations(0), "sort");
        this.addQueryParamAnnotation(methodCreator.getParameterAnnotations(1), "page");
        this.addDefaultValueAnnotation(methodCreator.getParameterAnnotations(1), Integer.toString(0));
        this.addQueryParamAnnotation(methodCreator.getParameterAnnotations(2), "size");
        this.addDefaultValueAnnotation(methodCreator.getParameterAnnotations(2), Integer.toString(20));
        this.addContextAnnotation(methodCreator.getParameterAnnotations(3));
        this.addQueryParamAnnotation(methodCreator.getParameterAnnotations(4), "namedQuery");
        HashMap<String, ResultHandle> fieldValues = new HashMap<String, ResultHandle>();
        int index = 5;
        for (SignatureMethodCreator.Parameter param : compatibleFieldsForQuery) {
            this.addQueryParamAnnotation(methodCreator.getParameterAnnotations(index), param.getName());
            fieldValues.put(param.getName(), methodCreator.getMethodParam(index));
            ++index;
        }
        ResultHandle resource = methodCreator.readInstanceField(resourceField, methodCreator.getThis());
        ResultHandle sortQuery = methodCreator.getMethodParam(0);
        ResultHandle sort = this.sortImplementor.getSort((BytecodeCreator)methodCreator, sortQuery);
        ResultHandle pageIndex = methodCreator.getMethodParam(1);
        ResultHandle pageSize = methodCreator.getMethodParam(2);
        ResultHandle page = this.paginationImplementor.getPage((BytecodeCreator)methodCreator, pageIndex, pageSize);
        ResultHandle uriInfo = methodCreator.getMethodParam(3);
        ResultHandle namedQuery = methodCreator.getMethodParam(4);
        if (this.isNotReactivePanache()) {
            TryBlock tryBlock = this.implementTryBlock((BytecodeCreator)methodCreator, EXCEPTION_MESSAGE);
            ResultHandle pageCount2 = this.pageCount((BytecodeCreator)tryBlock, resourceMetadata, resource, page, namedQuery, fieldValues, Integer.TYPE);
            ResultHandle links = this.paginationImplementor.getLinks((BytecodeCreator)tryBlock, uriInfo, page, pageCount2, fieldValues, namedQuery);
            ResultHandle entities = this.list((BytecodeCreator)tryBlock, resourceMetadata, resource, page, sort, namedQuery, fieldValues);
            this.returnValueWithLinks((BytecodeCreator)tryBlock, resourceMetadata, resourceProperties, entities, links);
            tryBlock.close();
        } else {
            ResultHandle uniPageCount = this.pageCount((BytecodeCreator)methodCreator, resourceMetadata, resource, page, namedQuery, fieldValues, Uni.class);
            methodCreator.returnValue(UniImplementor.flatMap((BytecodeCreator)methodCreator, uniPageCount, EXCEPTION_MESSAGE, (body, pageCount) -> {
                ResultHandle pageCountAsInt = body.checkCast(pageCount, Integer.class);
                ResultHandle links = this.paginationImplementor.getLinks((BytecodeCreator)body, uriInfo, page, pageCountAsInt, (Map<String, ResultHandle>)fieldValues, namedQuery);
                ResultHandle uniEntities = this.list((BytecodeCreator)body, resourceMetadata, resource, page, sort, namedQuery, (Map<String, ResultHandle>)fieldValues);
                body.returnValue(UniImplementor.map(body, uniEntities, EXCEPTION_MESSAGE, (listBody, list) -> this.returnValueWithLinks((BytecodeCreator)listBody, resourceMetadata, resourceProperties, (ResultHandle)list, links)));
            }));
        }
        methodCreator.close();
    }

    private Collection<SignatureMethodCreator.Parameter> getFieldsToQuery(ResourceMetadata resourceMetadata) {
        return resourceMetadata.getFields().entrySet().stream().filter(e -> this.isFieldTypeCompatibleForQueryParam((org.jboss.jandex.Type)e.getValue())).map(e -> SignatureMethodCreator.param((String)e.getKey(), TypeUtils.primitiveToClass(((org.jboss.jandex.Type)e.getValue()).name().toString()))).collect(Collectors.toList());
    }

    private void implementNotPaged(ClassCreator classCreator, ResourceMetadata resourceMetadata, ResourceProperties resourceProperties, FieldDescriptor resourceFieldDescriptor) {
        Collection<SignatureMethodCreator.Parameter> compatibleFieldsForQuery = this.getFieldsToQuery(resourceMetadata);
        ArrayList<SignatureMethodCreator.Parameter> parameters = new ArrayList<SignatureMethodCreator.Parameter>();
        parameters.add(SignatureMethodCreator.param("sort", List.class, (Type)Type.parameterizedType((Type.ClassType)Type.classType(List.class), (Type[])new Type[]{Type.classType(String.class)})));
        parameters.add(SignatureMethodCreator.param("namedQuery", String.class));
        for (SignatureMethodCreator.Parameter param : compatibleFieldsForQuery) {
            parameters.add(SignatureMethodCreator.param(param.getName().replace(".", "__"), param.getClazz()));
        }
        MethodCreator methodCreator = SignatureMethodCreator.getMethodCreator(this.getMethodName(), classCreator, this.isNotReactivePanache() ? SignatureMethodCreator.responseType(resourceMetadata.getEntityType()) : SignatureMethodCreator.uniType(resourceMetadata.getEntityType()), parameters.toArray(new SignatureMethodCreator.Parameter[0]));
        this.addGetAnnotation((AnnotatedElement)methodCreator);
        this.addPathAnnotation((AnnotatedElement)methodCreator, resourceProperties.getPath("list"));
        this.addProducesJsonAnnotation((AnnotatedElement)methodCreator, resourceProperties);
        this.addLinksAnnotation((AnnotatedElement)methodCreator, resourceProperties, resourceMetadata.getEntityType(), "list");
        this.addMethodAnnotations((AnnotatedElement)methodCreator, resourceProperties.getMethodAnnotations("list"));
        this.addOpenApiResponseAnnotation((AnnotatedElement)methodCreator, RestResponse.Status.OK, resourceMetadata.getEntityType(), true);
        this.addSecurityAnnotations((AnnotatedElement)methodCreator, resourceProperties);
        this.addQueryParamAnnotation(methodCreator.getParameterAnnotations(0), "sort");
        this.addQueryParamAnnotation(methodCreator.getParameterAnnotations(1), "namedQuery");
        HashMap<String, ResultHandle> fieldValues = new HashMap<String, ResultHandle>();
        int index = 2;
        for (SignatureMethodCreator.Parameter param : compatibleFieldsForQuery) {
            this.addQueryParamAnnotation(methodCreator.getParameterAnnotations(index), param.getName());
            fieldValues.put(param.getName(), methodCreator.getMethodParam(index));
            ++index;
        }
        ResultHandle sortQuery = methodCreator.getMethodParam(0);
        ResultHandle namedQuery = methodCreator.getMethodParam(1);
        ResultHandle sort = this.sortImplementor.getSort((BytecodeCreator)methodCreator, sortQuery);
        ResultHandle resource = methodCreator.readInstanceField(resourceFieldDescriptor, methodCreator.getThis());
        if (this.isNotReactivePanache()) {
            TryBlock tryBlock = this.implementTryBlock((BytecodeCreator)methodCreator, EXCEPTION_MESSAGE);
            ResultHandle entities2 = this.list((BytecodeCreator)tryBlock, resourceMetadata, resource, null, sort, namedQuery, fieldValues);
            this.returnValue((BytecodeCreator)tryBlock, resourceMetadata, resourceProperties, entities2);
            tryBlock.close();
        } else {
            ResultHandle uniEntities = this.list((BytecodeCreator)methodCreator, resourceMetadata, resource, methodCreator.loadNull(), sort, namedQuery, fieldValues);
            methodCreator.returnValue(UniImplementor.map((BytecodeCreator)methodCreator, uniEntities, EXCEPTION_MESSAGE, (body, entities) -> this.returnValue((BytecodeCreator)body, resourceMetadata, resourceProperties, (ResultHandle)entities)));
        }
        methodCreator.close();
    }

    private ResultHandle pageCount(BytecodeCreator creator, ResourceMetadata resourceMetadata, ResultHandle resource, ResultHandle page, ResultHandle namedQuery, Map<String, ResultHandle> fieldValues, Object returnType) {
        AssignableResultHandle query = this.queryImplementor.getQuery(creator, namedQuery, fieldValues);
        ResultHandle dataParams = this.queryImplementor.getDataParams(creator, fieldValues);
        return creator.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)resourceMetadata.getResourceClass(), (String)"$$_page_count_list", (Object)returnType, (Object[])new Object[]{Page.class, String.class, Map.class}), resource, new ResultHandle[]{page, query, dataParams});
    }

    public ResultHandle list(BytecodeCreator creator, ResourceMetadata resourceMetadata, ResultHandle resource, ResultHandle page, ResultHandle sort, ResultHandle namedQuery, Map<String, ResultHandle> fieldValues) {
        AssignableResultHandle query = this.queryImplementor.getQuery(creator, namedQuery, fieldValues);
        ResultHandle dataParams = this.queryImplementor.getDataParams(creator, fieldValues);
        return creator.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)resourceMetadata.getResourceClass(), (String)"list", this.isNotReactivePanache() ? List.class : Uni.class, (Object[])new Object[]{Page.class, Sort.class, String.class, Map.class}), resource, new ResultHandle[]{page == null ? creator.loadNull() : page, sort, query, dataParams});
    }

    private boolean isFieldTypeCompatibleForQueryParam(org.jboss.jandex.Type fieldType) {
        return fieldType.name().equals((Object)DotNames.STRING) || fieldType.name().equals((Object)DotNames.BOOLEAN) || fieldType.name().equals((Object)DotNames.CHARACTER) || fieldType.name().equals((Object)DotNames.DOUBLE) || fieldType.name().equals((Object)DotNames.SHORT) || fieldType.name().equals((Object)DotNames.FLOAT) || fieldType.name().equals((Object)DotNames.INTEGER) || fieldType.name().equals((Object)DotNames.LONG) || fieldType.name().equals((Object)DotNames.BYTE) || fieldType.kind() == Type.Kind.PRIMITIVE;
    }
}

