/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.client.reactive.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.ManagedContext;
import io.quarkus.rest.client.reactive.HeaderFiller;
import io.quarkus.rest.client.reactive.ReactiveClientHeadersFactory;
import io.quarkus.rest.client.reactive.runtime.ExtendedHeaderFiller;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.ContextNotActiveException;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.microprofile.rest.client.ext.ClientHeadersFactory;
import org.jboss.resteasy.reactive.client.spi.ResteasyReactiveClientRequestContext;
import org.jboss.resteasy.reactive.client.spi.ResteasyReactiveClientRequestFilter;
import org.jboss.resteasy.reactive.common.jaxrs.ConfigurationImpl;

@Priority(value=-2147483648)
public class MicroProfileRestClientRequestFilter
implements ResteasyReactiveClientRequestFilter {
    private static final MultivaluedMap<String, String> EMPTY_MAP = new MultivaluedHashMap();
    private final ClientHeadersFactory clientHeadersFactory;

    public MicroProfileRestClientRequestFilter(ClientHeadersFactory clientHeadersFactory) {
        this.clientHeadersFactory = clientHeadersFactory;
    }

    public void filter(final ResteasyReactiveClientRequestContext requestContext) {
        HeaderFiller headerFiller = (HeaderFiller)requestContext.getProperty(HeaderFiller.class.getName());
        MultivaluedHashMap headers = new MultivaluedHashMap();
        for (Object headerEntry : requestContext.getHeaders().entrySet()) {
            headers.put((Object)((String)headerEntry.getKey()), MicroProfileRestClientRequestFilter.castToListOfStrings((Collection)headerEntry.getValue()));
        }
        if (headerFiller != null) {
            if (headerFiller instanceof ExtendedHeaderFiller) {
                ((ExtendedHeaderFiller)headerFiller).addHeaders((MultivaluedMap<String, String>)headers, requestContext);
            } else {
                headerFiller.addHeaders((MultivaluedMap<String, String>)headers);
            }
        }
        MultivaluedMap incomingHeaders = this.determineIncomingHeaders();
        for (Map.Entry headerEntry : headers.entrySet()) {
            requestContext.getHeaders().put((Object)((String)headerEntry.getKey()), MicroProfileRestClientRequestFilter.castToListOfObjects((List)headerEntry.getValue()));
        }
        ClientHeadersFactory clientHeadersFactory = this.clientHeadersFactory(requestContext);
        if (clientHeadersFactory != null) {
            if (clientHeadersFactory instanceof ReactiveClientHeadersFactory) {
                ReactiveClientHeadersFactory reactiveClientHeadersFactory = (ReactiveClientHeadersFactory)clientHeadersFactory;
                requestContext.suspend();
                reactiveClientHeadersFactory.getHeaders((MultivaluedMap<String, String>)incomingHeaders, (MultivaluedMap<String, String>)headers).subscribe().with((Consumer)new Consumer<MultivaluedMap<String, String>>(){

                    @Override
                    public void accept(MultivaluedMap<String, String> newHeaders) {
                        for (Map.Entry headerEntry : newHeaders.entrySet()) {
                            requestContext.getHeaders().put((Object)((String)headerEntry.getKey()), MicroProfileRestClientRequestFilter.castToListOfObjects((List)headerEntry.getValue()));
                        }
                        requestContext.resume();
                    }
                }, (Consumer)new Consumer<Throwable>(){

                    @Override
                    public void accept(Throwable t) {
                        requestContext.resume(t);
                    }
                });
            } else {
                incomingHeaders = clientHeadersFactory.update(incomingHeaders, (MultivaluedMap)headers);
                for (Map.Entry headerEntry : incomingHeaders.entrySet()) {
                    requestContext.getHeaders().put((Object)((String)headerEntry.getKey()), MicroProfileRestClientRequestFilter.castToListOfObjects((List)headerEntry.getValue()));
                }
            }
        }
    }

    private MultivaluedMap<String, String> determineIncomingHeaders() {
        ArcContainer container = Arc.container();
        if (container == null) {
            return EMPTY_MAP;
        }
        ManagedContext requestContext = container.requestContext();
        if (!requestContext.isActive()) {
            return EMPTY_MAP;
        }
        InstanceHandle jakartaRestServerHeaders = container.instance(HttpHeaders.class, new Annotation[0]);
        if (!jakartaRestServerHeaders.isAvailable()) {
            return EMPTY_MAP;
        }
        try {
            return ((HttpHeaders)jakartaRestServerHeaders.get()).getRequestHeaders();
        }
        catch (ContextNotActiveException | IllegalStateException ignored) {
            return EMPTY_MAP;
        }
    }

    private ClientHeadersFactory clientHeadersFactory(ResteasyReactiveClientRequestContext requestContext) {
        ConfigurationImpl configuration;
        ClientHeadersFactory localHeadersFactory;
        Configuration configuration2 = requestContext.getConfiguration();
        if (configuration2 instanceof ConfigurationImpl && (localHeadersFactory = (ClientHeadersFactory)(configuration = (ConfigurationImpl)configuration2).getFromContext(ClientHeadersFactory.class)) != null) {
            return localHeadersFactory;
        }
        return this.clientHeadersFactory;
    }

    private static List<String> castToListOfStrings(Collection<Object> values) {
        ArrayList<String> result = new ArrayList<String>();
        for (Object value : values) {
            if (value instanceof String) {
                result.add((String)value);
                continue;
            }
            if (value instanceof Collection) {
                result.addAll(MicroProfileRestClientRequestFilter.castToListOfStrings((Collection)value));
                continue;
            }
            result.add(String.valueOf(value));
        }
        return result;
    }

    private static List<Object> castToListOfObjects(List<String> values) {
        return values;
    }
}

