/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.datasource;

import io.quarkus.redis.datasource.ReactiveRedisCommands;
import io.quarkus.redis.datasource.ReactiveRedisDataSource;
import io.quarkus.redis.datasource.graph.GraphQueryResponseItem;
import io.quarkus.redis.datasource.graph.ReactiveGraphCommands;
import io.quarkus.redis.runtime.datasource.AbstractGraphCommands;
import io.quarkus.redis.runtime.datasource.ReactiveRedisDataSourceImpl;
import io.quarkus.redis.runtime.datasource.RedisCommandExecutor;
import io.smallrye.mutiny.Uni;
import io.vertx.mutiny.redis.client.Response;
import io.vertx.redis.client.ResponseType;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ReactiveGraphCommandsImpl<K>
extends AbstractGraphCommands<K>
implements ReactiveGraphCommands<K>,
ReactiveRedisCommands {
    private final ReactiveRedisDataSource reactive;
    protected final Class<K> typeOfKey;

    public ReactiveGraphCommandsImpl(ReactiveRedisDataSourceImpl redis, Class<K> k) {
        super((RedisCommandExecutor)redis, k);
        this.typeOfKey = k;
        this.reactive = redis;
    }

    @Override
    public ReactiveRedisDataSource getDataSource() {
        return this.reactive;
    }

    @Override
    public Uni<Void> graphDelete(K key) {
        return super._graphDelete(key).replaceWithVoid();
    }

    @Override
    public Uni<String> graphExplain(K key, String query) {
        return super._graphExplain(key, query).map(Response::toString);
    }

    @Override
    public Uni<List<K>> graphList() {
        return super._graphList().map(r -> this.marshaller.decodeAsList((Response)r, this.typeOfKey));
    }

    @Override
    public Uni<List<Map<String, GraphQueryResponseItem>>> graphQuery(K key, String query) {
        return super._graphQuery(key, query).map(ReactiveGraphCommandsImpl::decodeQueryResponse);
    }

    @Override
    public Uni<List<Map<String, GraphQueryResponseItem>>> graphQuery(K key, String query, Duration timeout) {
        return super._graphQuery(key, query, timeout).map(ReactiveGraphCommandsImpl::decodeQueryResponse);
    }

    static List<Map<String, GraphQueryResponseItem>> decodeQueryResponse(Response r) {
        if (r.type() == ResponseType.MULTI) {
            if (r.size() <= 1) {
                return Collections.emptyList();
            }
            Response keys = r.get(0);
            Response values = r.get(1);
            ArrayList<Map<String, GraphQueryResponseItem>> results = new ArrayList<Map<String, GraphQueryResponseItem>>();
            for (Response match : values) {
                LinkedHashMap<String, GraphQueryResponseItem> result = new LinkedHashMap<String, GraphQueryResponseItem>();
                for (int i = 0; i < keys.size(); ++i) {
                    Response val = match.get(i);
                    String key = keys.get(i).toString();
                    result.put(key, ReactiveGraphCommandsImpl.decodeItem(key, val));
                }
                results.add(result);
            }
            return results;
        }
        return Collections.emptyList();
    }

    private static boolean isNode(Response multi) {
        if (multi == null || multi.type() != ResponseType.MULTI) {
            return false;
        }
        boolean idFound = false;
        boolean labelsFound = false;
        for (Response response : multi) {
            if ("id".equalsIgnoreCase(response.get(0).toString())) {
                idFound = true;
                continue;
            }
            if (!"labels".equalsIgnoreCase(response.get(0).toString())) continue;
            labelsFound = true;
        }
        return idFound && labelsFound;
    }

    private static boolean isRelation(Response multi) {
        if (multi == null || multi.type() != ResponseType.MULTI) {
            return false;
        }
        boolean idFound = false;
        boolean typeFound = false;
        for (Response response : multi) {
            if ("id".equalsIgnoreCase(response.get(0).toString())) {
                idFound = true;
                continue;
            }
            if (!"type".equalsIgnoreCase(response.get(0).toString())) continue;
            typeFound = true;
        }
        return idFound && typeFound;
    }

    private static GraphQueryResponseItem decodeItem(String key, Response val) {
        if (ReactiveGraphCommandsImpl.isNode(val)) {
            return ReactiveGraphCommandsImpl.decodeNode(key, val);
        }
        if (ReactiveGraphCommandsImpl.isRelation(val)) {
            return ReactiveGraphCommandsImpl.decodeRelation(key, val);
        }
        return ReactiveGraphCommandsImpl.decodeScalar(key, val);
    }

    private static GraphQueryResponseItem.NodeItem decodeNode(String key, Response val) {
        return new NodeImpl(key, val);
    }

    private static GraphQueryResponseItem.RelationItem decodeRelation(String key, Response val) {
        return new RelationImpl(key, val);
    }

    private static GraphQueryResponseItem.ScalarItem decodeScalar(String key, Response val) {
        return new ScalarImpl(key, val);
    }

    private static class NodeImpl
    implements GraphQueryResponseItem.NodeItem {
        private final String key;
        private final Map<String, Response> map;
        private final List<GraphQueryResponseItem.ScalarItem> items;

        public NodeImpl(String key, Response val) {
            this.key = key;
            this.map = new HashMap<String, Response>();
            for (Response response : val) {
                this.map.put(response.get(0).toString(), response.get(1));
            }
            Response response = this.map.get("properties");
            this.items = new ArrayList<GraphQueryResponseItem.ScalarItem>();
            for (Response nested : response) {
                this.items.add(ReactiveGraphCommandsImpl.decodeScalar(nested.get(0).toString(), nested.get(1)));
            }
        }

        public String toString() {
            return "Node{key='" + this.key + "', items=" + String.valueOf(this.items) + "}";
        }

        @Override
        public String name() {
            return this.key;
        }

        @Override
        public long id() {
            return this.map.get("id").toLong();
        }

        @Override
        public List<String> labels() {
            ArrayList<String> res = new ArrayList<String>();
            for (Response labels : this.map.get("labels")) {
                res.add(labels.toString());
            }
            return res;
        }

        @Override
        public List<GraphQueryResponseItem.ScalarItem> properties() {
            return this.items;
        }

        @Override
        public GraphQueryResponseItem.ScalarItem get(String property) {
            for (GraphQueryResponseItem.ScalarItem item : this.items) {
                if (!item.name().equals(property)) continue;
                return item;
            }
            return null;
        }
    }

    private static class RelationImpl
    implements GraphQueryResponseItem.RelationItem {
        private final String key;
        private final Map<String, Response> map;
        private final List<GraphQueryResponseItem.ScalarItem> items;

        public RelationImpl(String key, Response val) {
            this.key = key;
            this.map = new HashMap<String, Response>();
            for (Response response : val) {
                this.map.put(response.get(0).toString(), response.get(1));
            }
            Response response = this.map.get("properties");
            this.items = new ArrayList<GraphQueryResponseItem.ScalarItem>();
            for (Response nested : response) {
                this.items.add(ReactiveGraphCommandsImpl.decodeScalar(nested.get(0).toString(), nested.get(1)));
            }
        }

        public String toString() {
            return "Relation{key='" + this.key + "', items=" + String.valueOf(this.items) + "}";
        }

        @Override
        public String name() {
            return this.key;
        }

        @Override
        public long id() {
            return this.map.get("id").toLong();
        }

        @Override
        public String type() {
            return this.map.get("type").toString();
        }

        @Override
        public long source() {
            return this.map.get("src_node").toLong();
        }

        @Override
        public long destination() {
            return this.map.get("dest_node").toLong();
        }

        @Override
        public List<GraphQueryResponseItem.ScalarItem> properties() {
            return this.items;
        }

        @Override
        public GraphQueryResponseItem.ScalarItem get(String property) {
            for (GraphQueryResponseItem.ScalarItem item : this.items) {
                if (!item.name().equals(property)) continue;
                return item;
            }
            return null;
        }
    }

    private static class ScalarImpl
    implements GraphQueryResponseItem.ScalarItem {
        private final String key;
        private final Response val;

        public ScalarImpl(String key, Response val) {
            this.key = key;
            this.val = val;
        }

        public String toString() {
            return "Scalar{key='" + this.key + "', val=" + String.valueOf(this.val) + "}";
        }

        @Override
        public String name() {
            return this.key;
        }

        @Override
        public boolean asBoolean() {
            return this.val.toBoolean();
        }

        @Override
        public int asInteger() {
            return this.val.toInteger();
        }

        @Override
        public double asDouble() {
            return this.val.toDouble();
        }

        @Override
        public boolean isNull() {
            return this.val == null;
        }

        @Override
        public String asString() {
            return this.val.toString();
        }
    }
}

