/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.client;

import io.quarkus.redis.runtime.client.ObservableRedisMetrics;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.redis.client.Redis;
import io.vertx.redis.client.RedisConnection;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.Response;
import java.util.List;

public class ObservableRedis
implements Redis {
    private final Redis redis;
    private final String name;
    private final ObservableRedisMetrics reporter;

    public ObservableRedis(Redis redis, String name, ObservableRedisMetrics reporter) {
        this.redis = redis;
        this.name = name;
        this.reporter = reporter == null ? ObservableRedisMetrics.NOOP : reporter;
    }

    public String name() {
        return this.name;
    }

    private void report(long time, boolean succeeded) {
        this.reporter.report(this.name, time, succeeded);
    }

    public Redis connect(Handler<AsyncResult<RedisConnection>> handler) {
        this.redis.connect(ar -> {
            if (ar.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            } else {
                handler.handle((Object)Future.succeededFuture((Object)new ObservableRedisConnection((RedisConnection)ar.result())));
            }
        });
        return this;
    }

    public Redis send(Request command, Handler<AsyncResult<@Nullable Response>> onSend) {
        long begin = System.nanoTime();
        this.redis.send(command, ar -> {
            this.report(System.nanoTime() - begin, ar.succeeded());
            onSend.handle(ar);
        });
        return this;
    }

    public Redis batch(List<Request> commands, Handler<AsyncResult<List<@Nullable Response>>> onSend) {
        long begin = System.nanoTime();
        this.redis.batch(commands, ar -> {
            this.report(System.nanoTime() - begin, ar.succeeded());
            onSend.handle(ar);
        });
        return this;
    }

    public Future<RedisConnection> connect() {
        return this.redis.connect().map(x$0 -> new ObservableRedisConnection((RedisConnection)x$0));
    }

    public void close() {
        this.redis.close();
    }

    public Future<Response> send(Request command) {
        long begin = System.nanoTime();
        return this.redis.send(command).onComplete(x -> this.report(System.nanoTime() - begin, x.succeeded()));
    }

    public Future<List<Response>> batch(List<Request> commands) {
        long begin = System.nanoTime();
        return this.redis.batch(commands).onComplete(x -> this.report(System.nanoTime() - begin, x.succeeded()));
    }

    private class ObservableRedisConnection
    implements RedisConnection {
        private final RedisConnection delegate;

        private ObservableRedisConnection(RedisConnection delegate) {
            this.delegate = delegate;
        }

        public RedisConnection exceptionHandler(Handler<Throwable> handler) {
            this.delegate.exceptionHandler(handler);
            return this;
        }

        public RedisConnection handler(@Nullable Handler<Response> handler) {
            this.delegate.handler(handler);
            return this;
        }

        public RedisConnection pause() {
            this.delegate.pause();
            return this;
        }

        public RedisConnection resume() {
            this.delegate.resume();
            return this;
        }

        public RedisConnection fetch(long amount) {
            this.delegate.fetch(amount);
            return this;
        }

        public RedisConnection endHandler(@Nullable Handler<Void> endHandler) {
            this.delegate.endHandler(endHandler);
            return this;
        }

        public Future<Response> send(Request command) {
            long begin = System.nanoTime();
            return this.delegate.send(command).onComplete(ar -> {
                long end = System.nanoTime();
                ObservableRedis.this.report(end - begin, ar.succeeded());
            });
        }

        public Future<List<Response>> batch(List<Request> commands) {
            long begin = System.nanoTime();
            return this.delegate.batch(commands).onComplete(ar -> {
                long end = System.nanoTime();
                ObservableRedis.this.report(end - begin, ar.succeeded());
            });
        }

        public Future<Void> close() {
            return this.delegate.close();
        }

        public boolean pendingQueueFull() {
            return this.delegate.pendingQueueFull();
        }
    }
}

