/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.datasource.graph;

import java.util.List;

public interface GraphQueryResponseItem {
    public Kind kind();

    public String name();

    default public ScalarItem asScalarItem() {
        if (this instanceof ScalarItem) {
            return (ScalarItem)this;
        }
        throw new ClassCastException("Cannot cast " + String.valueOf(this) + " of kind " + String.valueOf((Object)this.kind()) + " to a " + ScalarItem.class.getName());
    }

    default public NodeItem asNodeItem() {
        if (this instanceof NodeItem) {
            return (NodeItem)this;
        }
        throw new ClassCastException("Cannot cast " + String.valueOf(this) + " of kind " + String.valueOf((Object)this.kind()) + " to a " + NodeItem.class.getName());
    }

    default public RelationItem asRelationItem() {
        if (this instanceof RelationItem) {
            return (RelationItem)this;
        }
        throw new ClassCastException("Cannot cast " + String.valueOf(this) + " of kind " + String.valueOf((Object)this.kind()) + " to a " + RelationItem.class.getName());
    }

    public static interface ScalarItem
    extends GraphQueryResponseItem {
        public boolean asBoolean();

        public int asInteger();

        public double asDouble();

        public boolean isNull();

        public String asString();

        @Override
        default public Kind kind() {
            return Kind.SCALAR;
        }
    }

    public static enum Kind {
        SCALAR,
        NODE,
        RELATION;

    }

    public static interface NodeItem
    extends GraphQueryResponseItem {
        public long id();

        public List<String> labels();

        public List<ScalarItem> properties();

        public ScalarItem get(String var1);

        @Override
        default public Kind kind() {
            return Kind.NODE;
        }
    }

    public static interface RelationItem
    extends GraphQueryResponseItem {
        public long id();

        public String type();

        public long source();

        public long destination();

        public List<ScalarItem> properties();

        public ScalarItem get(String var1);

        @Override
        default public Kind kind() {
            return Kind.RELATION;
        }
    }
}

