/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.datasource.search;

import io.quarkus.redis.datasource.RedisCommandExtraArguments;
import io.quarkus.redis.runtime.datasource.Validation;
import io.smallrye.mutiny.helpers.ParameterValidation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SpellCheckArgs
implements RedisCommandExtraArguments {
    private int distance;
    private final List<String> includes = new ArrayList<String>();
    private final List<String> excludes = new ArrayList<String>();
    private int dialect = -1;

    public SpellCheckArgs distance(int distance) {
        if (distance < 1 || distance > 4) {
            throw new IllegalArgumentException("`distance` must be in [1,4]");
        }
        this.distance = distance;
        return this;
    }

    public SpellCheckArgs includes(String ... dict) {
        ParameterValidation.doesNotContainNull((Object[])Validation.notNullOrEmpty(dict, "dict"), (String)"dict");
        Collections.addAll(this.includes, dict);
        return this;
    }

    public SpellCheckArgs excludes(String ... dict) {
        ParameterValidation.doesNotContainNull((Object[])Validation.notNullOrEmpty(dict, "dict"), (String)"dict");
        Collections.addAll(this.excludes, dict);
        return this;
    }

    public SpellCheckArgs dialect(int dialect) {
        this.dialect = dialect;
        return this;
    }

    @Override
    public List<Object> toArgs() {
        ArrayList<Object> list = new ArrayList<Object>();
        if (this.distance != 0) {
            list.add("DISTANCE");
            list.add(Integer.toString(this.distance));
        }
        if (!this.includes.isEmpty() && !this.excludes.isEmpty()) {
            throw new IllegalArgumentException("Cannot specify both `includes` and `excludes` terms");
        }
        if (!this.includes.isEmpty()) {
            list.add("TERMS");
            list.add("INCLUDE");
            list.addAll(this.includes);
        } else if (!this.excludes.isEmpty()) {
            list.add("TERMS");
            list.add("EXCLUDE");
            list.addAll(this.excludes);
        }
        if (this.dialect != -1) {
            list.add("DIALECT");
            list.add(Integer.toString(this.dialect));
        }
        return list;
    }
}

