/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.datasource.search;

import io.vertx.core.json.JsonObject;
import io.vertx.mutiny.redis.client.Response;
import java.util.Collections;
import java.util.Map;

public class Document {
    private final String id;
    private final double score;
    private final Map<String, Property> properties;
    private final Response payload;

    public Document(String id, double score, Response payload, Map<String, Property> properties) {
        this.id = id;
        this.score = score == 0.0 ? 1.0 : score;
        this.payload = payload;
        this.properties = properties == null ? Collections.emptyMap() : Collections.unmodifiableMap(properties);
    }

    public String key() {
        return this.id;
    }

    public double score() {
        return this.score;
    }

    public Map<String, Property> properties() {
        return this.properties;
    }

    public Property property(String name) {
        return this.properties.get(name);
    }

    public Response payload() {
        return this.payload;
    }

    public static class Property {
        private final Response response;
        private final String name;

        public Property(String name, Response response) {
            this.response = response;
            this.name = name;
        }

        public double asDouble() {
            return this.response.toDouble();
        }

        public int asInteger() {
            return this.response.toInteger();
        }

        public long asLong() {
            return this.response.toLong();
        }

        public Response unwrap() {
            return this.response;
        }

        public String asString() {
            return this.response.toString();
        }

        public byte[] asBytes() {
            return this.response.toBytes();
        }

        public boolean asBoolean() {
            return this.response.toBoolean();
        }

        public String name() {
            return this.name;
        }

        public JsonObject asJsonObject() {
            return this.response.toBuffer().toJsonObject();
        }
    }
}

