/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.datasource;

import io.quarkus.redis.datasource.RedisDataSource;
import io.quarkus.redis.datasource.timeseries.AddArgs;
import io.quarkus.redis.datasource.timeseries.Aggregation;
import io.quarkus.redis.datasource.timeseries.AlterArgs;
import io.quarkus.redis.datasource.timeseries.CreateArgs;
import io.quarkus.redis.datasource.timeseries.Filter;
import io.quarkus.redis.datasource.timeseries.IncrementArgs;
import io.quarkus.redis.datasource.timeseries.MGetArgs;
import io.quarkus.redis.datasource.timeseries.MRangeArgs;
import io.quarkus.redis.datasource.timeseries.RangeArgs;
import io.quarkus.redis.datasource.timeseries.ReactiveTimeSeriesCommands;
import io.quarkus.redis.datasource.timeseries.Sample;
import io.quarkus.redis.datasource.timeseries.SampleGroup;
import io.quarkus.redis.datasource.timeseries.SeriesSample;
import io.quarkus.redis.datasource.timeseries.TimeSeriesCommands;
import io.quarkus.redis.datasource.timeseries.TimeSeriesRange;
import io.quarkus.redis.runtime.datasource.AbstractRedisCommandGroup;
import java.time.Duration;
import java.util.List;
import java.util.Map;

public class BlockingTimeSeriesCommandsImpl<K>
extends AbstractRedisCommandGroup
implements TimeSeriesCommands<K> {
    private final ReactiveTimeSeriesCommands<K> reactive;

    public BlockingTimeSeriesCommandsImpl(RedisDataSource ds, ReactiveTimeSeriesCommands<K> reactive, Duration timeout) {
        super(ds, timeout);
        this.reactive = reactive;
    }

    @Override
    public void tsCreate(K key, CreateArgs args) {
        this.reactive.tsCreate(key, args).await().atMost(this.timeout);
    }

    @Override
    public void tsCreate(K key) {
        this.reactive.tsCreate(key).await().atMost(this.timeout);
    }

    @Override
    public void tsAdd(K key, long timestamp, double value, AddArgs args) {
        this.reactive.tsAdd(key, timestamp, value, args).await().atMost(this.timeout);
    }

    @Override
    public void tsAdd(K key, double value, AddArgs args) {
        this.reactive.tsAdd(key, value, args).await().atMost(this.timeout);
    }

    @Override
    public void tsAdd(K key, long timestamp, double value) {
        this.reactive.tsAdd(key, timestamp, value).await().atMost(this.timeout);
    }

    @Override
    public void tsAdd(K key, double value) {
        this.reactive.tsAdd(key, value).await().atMost(this.timeout);
    }

    @Override
    public void tsAlter(K key, AlterArgs args) {
        this.reactive.tsAlter(key, args).await().atMost(this.timeout);
    }

    @Override
    public void tsCreateRule(K key, K destKey, Aggregation aggregation, Duration bucketDuration) {
        this.reactive.tsCreateRule(key, destKey, aggregation, bucketDuration).await().atMost(this.timeout);
    }

    @Override
    public void tsCreateRule(K key, K destKey, Aggregation aggregation, Duration bucketDuration, long alignTimestamp) {
        this.reactive.tsCreateRule(key, destKey, aggregation, bucketDuration, alignTimestamp).await().atMost(this.timeout);
    }

    @Override
    public void tsDecrBy(K key, double value) {
        this.reactive.tsDecrBy(key, value).await().atMost(this.timeout);
    }

    @Override
    public void tsDecrBy(K key, double value, IncrementArgs args) {
        this.reactive.tsDecrBy(key, value, args).await().atMost(this.timeout);
    }

    @Override
    public void tsDel(K key, long fromTimestamp, long toTimestamp) {
        this.reactive.tsDel(key, fromTimestamp, toTimestamp).await().atMost(this.timeout);
    }

    @Override
    public void tsDeleteRule(K key, K destKey) {
        this.reactive.tsDeleteRule(key, destKey).await().atMost(this.timeout);
    }

    @Override
    public Sample tsGet(K key) {
        return (Sample)this.reactive.tsGet(key).await().atMost(this.timeout);
    }

    @Override
    public Sample tsGet(K key, boolean latest) {
        return (Sample)this.reactive.tsGet(key, latest).await().atMost(this.timeout);
    }

    @Override
    public void tsIncrBy(K key, double value) {
        this.reactive.tsIncrBy(key, value).await().atMost(this.timeout);
    }

    @Override
    public void tsIncrBy(K key, double value, IncrementArgs args) {
        this.reactive.tsIncrBy(key, value, args).await().atMost(this.timeout);
    }

    @Override
    public void tsMAdd(SeriesSample<K> ... samples) {
        this.reactive.tsMAdd(samples).await().atMost(this.timeout);
    }

    @Override
    public Map<String, SampleGroup> tsMGet(MGetArgs args, Filter ... filters) {
        return (Map)this.reactive.tsMGet(args, filters).await().atMost(this.timeout);
    }

    @Override
    public Map<String, SampleGroup> tsMGet(Filter ... filters) {
        return (Map)this.reactive.tsMGet(filters).await().atMost(this.timeout);
    }

    @Override
    public Map<String, SampleGroup> tsMRange(TimeSeriesRange range, Filter ... filters) {
        return (Map)this.reactive.tsMRange(range, filters).await().atMost(this.timeout);
    }

    @Override
    public Map<String, SampleGroup> tsMRange(TimeSeriesRange range, MRangeArgs args, Filter ... filters) {
        return (Map)this.reactive.tsMRange(range, args, filters).await().atMost(this.timeout);
    }

    @Override
    public Map<String, SampleGroup> tsMRevRange(TimeSeriesRange range, Filter ... filters) {
        return (Map)this.reactive.tsMRevRange(range, filters).await().atMost(this.timeout);
    }

    @Override
    public Map<String, SampleGroup> tsMRevRange(TimeSeriesRange range, MRangeArgs args, Filter ... filters) {
        return (Map)this.reactive.tsMRevRange(range, args, filters).await().atMost(this.timeout);
    }

    @Override
    public List<K> tsQueryIndex(Filter ... filters) {
        return (List)this.reactive.tsQueryIndex(filters).await().atMost(this.timeout);
    }

    @Override
    public List<Sample> tsRange(K key, TimeSeriesRange range) {
        return (List)this.reactive.tsRange(key, range).await().atMost(this.timeout);
    }

    @Override
    public List<Sample> tsRange(K key, TimeSeriesRange range, RangeArgs args) {
        return (List)this.reactive.tsRange(key, range, args).await().atMost(this.timeout);
    }

    @Override
    public List<Sample> tsRevRange(K key, TimeSeriesRange range) {
        return (List)this.reactive.tsRevRange(key, range).await().atMost(this.timeout);
    }

    @Override
    public List<Sample> tsRevRange(K key, TimeSeriesRange range, RangeArgs args) {
        return (List)this.reactive.tsRevRange(key, range, args).await().atMost(this.timeout);
    }
}

