/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.datasource;

import io.quarkus.redis.runtime.datasource.AbstractRedisCommands;
import io.quarkus.redis.runtime.datasource.Marshaller;
import io.quarkus.redis.runtime.datasource.RedisCommand;
import io.quarkus.redis.runtime.datasource.RedisCommandExecutor;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.vertx.mutiny.redis.client.Command;
import io.vertx.mutiny.redis.client.Response;
import java.lang.reflect.Type;
import java.util.Map;

public class AbstractTopKCommands<K, V>
extends AbstractRedisCommands {
    AbstractTopKCommands(RedisCommandExecutor redis, Type k, Type v) {
        super(redis, new Marshaller(k, v));
    }

    Uni<Response> _topkAdd(K key, V item) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(item, (String)"item");
        RedisCommand cmd = RedisCommand.of(Command.TOPK_ADD).put(this.marshaller.encode(key)).put(this.marshaller.encode(item));
        return this.execute(cmd);
    }

    Uni<Response> _topkAdd(K key, V ... items) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.doesNotContainNull((Object[])items, (String)"items");
        if (items.length == 0) {
            return Uni.createFrom().failure((Throwable)new IllegalArgumentException("`items` must not be empty"));
        }
        RedisCommand cmd = RedisCommand.of(Command.TOPK_ADD).put(this.marshaller.encode(key)).putAll(this.marshaller.encode(items));
        return this.execute(cmd);
    }

    Uni<Response> _topkIncrBy(K key, V item, int increment) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(item, (String)"item");
        ParameterValidation.positive((int)increment, (String)"increment");
        RedisCommand cmd = RedisCommand.of(Command.TOPK_INCRBY).put(this.marshaller.encode(key)).put(this.marshaller.encode(item)).put(increment);
        return this.execute(cmd);
    }

    Uni<Response> _topkIncrBy(K key, Map<V, Integer> couples) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(couples, (String)"couples");
        ParameterValidation.isNotEmpty(couples.keySet(), (String)"couples");
        RedisCommand cmd = RedisCommand.of(Command.TOPK_INCRBY).put(this.marshaller.encode(key));
        for (Map.Entry<V, Integer> entry : couples.entrySet()) {
            cmd.put(this.marshaller.encode(entry.getKey()));
            cmd.put(entry.getValue());
        }
        return this.execute(cmd);
    }

    Uni<Response> _topkList(K key) {
        ParameterValidation.nonNull(key, (String)"key");
        RedisCommand cmd = RedisCommand.of(Command.TOPK_LIST).put(this.marshaller.encode(key));
        return this.execute(cmd);
    }

    Uni<Response> _topkListWithCount(K key) {
        ParameterValidation.nonNull(key, (String)"key");
        RedisCommand cmd = RedisCommand.of(Command.TOPK_LIST).put(this.marshaller.encode(key)).put("WITHCOUNT");
        return this.execute(cmd);
    }

    Uni<Response> _topkQuery(K key, V item) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(item, (String)"item");
        RedisCommand cmd = RedisCommand.of(Command.TOPK_QUERY).put(this.marshaller.encode(key)).put(this.marshaller.encode(item));
        return this.execute(cmd);
    }

    Uni<Response> _topkQuery(K key, V ... items) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.doesNotContainNull((Object[])items, (String)"items");
        if (items.length == 0) {
            return Uni.createFrom().failure((Throwable)new IllegalArgumentException("`items` must not be empty"));
        }
        RedisCommand cmd = RedisCommand.of(Command.TOPK_QUERY).put(this.marshaller.encode(key)).putAll(this.marshaller.encode(items));
        return this.execute(cmd);
    }

    Uni<Response> _topkReserve(K key, int topk) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.positive((int)topk, (String)"topk");
        RedisCommand cmd = RedisCommand.of(Command.TOPK_RESERVE).put(this.marshaller.encode(key)).put(topk);
        return this.execute(cmd);
    }

    Uni<Response> _topkReserve(K key, int topk, int width, int depth, double decay) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.positive((int)topk, (String)"topk");
        RedisCommand cmd = RedisCommand.of(Command.TOPK_RESERVE).put(this.marshaller.encode(key)).put(topk).put(width).put(depth).put(decay);
        return this.execute(cmd);
    }
}

