/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.datasource;

import io.quarkus.redis.runtime.datasource.Marshaller;
import io.quarkus.redis.runtime.datasource.ReactiveSortable;
import io.quarkus.redis.runtime.datasource.RedisCommand;
import io.quarkus.redis.runtime.datasource.RedisCommandExecutor;
import io.quarkus.redis.runtime.datasource.Validation;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.vertx.mutiny.redis.client.Command;
import io.vertx.mutiny.redis.client.Response;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;

class AbstractSetCommands<K, V>
extends ReactiveSortable<K, V> {
    protected final Type typeOfValue;

    AbstractSetCommands(RedisCommandExecutor redis, Type k, Type v) {
        super(redis, new Marshaller(k, v), v);
        this.typeOfValue = v;
    }

    Uni<Response> _sadd(K key, V ... members) {
        ParameterValidation.nonNull(key, (String)"key");
        Validation.notNullOrEmpty(members, "members");
        RedisCommand cmd = RedisCommand.of(Command.SADD);
        cmd.put(this.marshaller.encode(key));
        cmd.putAll(this.marshaller.encode(members));
        return this.execute(cmd);
    }

    Uni<Response> _scard(K key) {
        ParameterValidation.nonNull(key, (String)"key");
        return this.execute(RedisCommand.of(Command.SCARD).put(this.marshaller.encode(key)));
    }

    Uni<Response> _sdiff(K ... keys) {
        Validation.notNullOrEmpty(keys, "keys");
        ParameterValidation.doesNotContainNull((Object[])keys, (String)"keys");
        if (keys.length <= 1) {
            return Uni.createFrom().failure((Throwable)new IllegalArgumentException("`keys` must contain at least 2 keys"));
        }
        return this.execute(RedisCommand.of(Command.SDIFF).put(this.marshaller.encode(keys)));
    }

    Set<V> decodeAsSetOfValues(Response r) {
        return this.marshaller.decodeAsSet(r, this.typeOfValue);
    }

    Uni<Response> _sdiffstore(K destination, K ... keys) {
        ParameterValidation.nonNull(destination, (String)"destination");
        Validation.notNullOrEmpty(keys, "keys");
        ParameterValidation.doesNotContainNull((Object[])keys, (String)"keys");
        if (keys.length <= 1) {
            return Uni.createFrom().failure((Throwable)new IllegalArgumentException("`keys` must contain at least 2 keys"));
        }
        RedisCommand cmd = RedisCommand.of(Command.SDIFFSTORE).put(this.marshaller.encode(destination)).putAll(this.marshaller.encode(keys));
        return this.execute(cmd);
    }

    Uni<Response> _sinter(K ... keys) {
        Validation.notNullOrEmpty(keys, "keys");
        ParameterValidation.doesNotContainNull((Object[])keys, (String)"keys");
        if (keys.length <= 1) {
            return Uni.createFrom().failure((Throwable)new IllegalArgumentException("`keys` must contain at least 2 keys"));
        }
        return this.execute(RedisCommand.of(Command.SINTER).put(this.marshaller.encode(keys)));
    }

    Uni<Response> _sintercard(K ... keys) {
        Validation.notNullOrEmpty(keys, "keys");
        ParameterValidation.doesNotContainNull((Object[])keys, (String)"keys");
        if (keys.length <= 1) {
            return Uni.createFrom().failure((Throwable)new IllegalArgumentException("`keys` must contain at least 2 keys"));
        }
        RedisCommand cmd = RedisCommand.of(Command.SINTERCARD).put(keys.length).putAll(this.marshaller.encode(keys));
        return this.execute(cmd);
    }

    Uni<Response> _sintercard(int limit, K ... keys) {
        Validation.notNullOrEmpty(keys, "keys");
        ParameterValidation.doesNotContainNull((Object[])keys, (String)"keys");
        ParameterValidation.positive((int)limit, (String)"limit");
        if (keys.length <= 1) {
            return Uni.createFrom().failure((Throwable)new IllegalArgumentException("`keys` must contain at least 2 keys"));
        }
        RedisCommand cmd = RedisCommand.of(Command.SINTERCARD).put(keys.length).putAll(this.marshaller.encode(keys)).put("LIMIT").put(limit);
        return this.execute(cmd);
    }

    Uni<Response> _sinterstore(K destination, K ... keys) {
        ParameterValidation.nonNull(destination, (String)"destination");
        Validation.notNullOrEmpty(keys, "keys");
        if (keys.length <= 1) {
            return Uni.createFrom().failure((Throwable)new IllegalArgumentException("`keys` must contain at least 2 keys"));
        }
        RedisCommand cmd = RedisCommand.of(Command.SINTERSTORE).put(this.marshaller.encode(destination)).putAll(this.marshaller.encode(keys));
        return this.execute(cmd);
    }

    Uni<Response> _sismember(K key, V member) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(member, (String)"member");
        return this.execute(RedisCommand.of(Command.SISMEMBER).put(this.marshaller.encode(key)).put(this.marshaller.encode(member)));
    }

    Uni<Response> _smembers(K key) {
        ParameterValidation.nonNull(key, (String)"key");
        return this.execute(RedisCommand.of(Command.SMEMBERS).put(this.marshaller.encode(key)));
    }

    Uni<Response> _smismember(K key, V ... members) {
        ParameterValidation.nonNull(key, (String)"key");
        Validation.notNullOrEmpty(members, "members");
        RedisCommand cmd = RedisCommand.of(Command.SMISMEMBER);
        cmd.put(this.marshaller.encode(key));
        cmd.putAll(this.marshaller.encode(members));
        return this.execute(cmd);
    }

    List<Boolean> decodeAsListOfBooleans(Response r) {
        return this.marshaller.decodeAsList(r, Response::toBoolean);
    }

    Uni<Response> _smove(K source, K destination, V member) {
        ParameterValidation.nonNull(source, (String)"source");
        ParameterValidation.nonNull(destination, (String)"destination");
        ParameterValidation.nonNull(member, (String)"member");
        return this.execute(RedisCommand.of(Command.SMOVE).put(this.marshaller.encode(source)).put(this.marshaller.encode(destination)).put(this.marshaller.encode(member)));
    }

    Uni<Response> _spop(K key) {
        ParameterValidation.nonNull(key, (String)"key");
        return this.execute(RedisCommand.of(Command.SPOP).put(this.marshaller.encode(key)));
    }

    V decodeV(Response r) {
        return (V)this.marshaller.decode(this.typeOfValue, r);
    }

    Uni<Response> _spop(K key, int count) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.positive((int)count, (String)"count");
        return this.execute(RedisCommand.of(Command.SPOP).put(this.marshaller.encode(key)).put(count));
    }

    Uni<Response> _srandmember(K key) {
        ParameterValidation.nonNull(key, (String)"key");
        return this.execute(RedisCommand.of(Command.SRANDMEMBER).put(this.marshaller.encode(key)));
    }

    Uni<Response> _srandmember(K key, int count) {
        ParameterValidation.nonNull(key, (String)"key");
        return this.execute(RedisCommand.of(Command.SRANDMEMBER).put(this.marshaller.encode(key)).put(count));
    }

    List<V> decodeListOfValues(Response r) {
        return this.marshaller.decodeAsList(r, this.typeOfValue);
    }

    Uni<Response> _srem(K key, V ... members) {
        ParameterValidation.nonNull(key, (String)"key");
        Validation.notNullOrEmpty(members, "members");
        ParameterValidation.doesNotContainNull((Object[])members, (String)"members");
        RedisCommand cmd = RedisCommand.of(Command.SREM);
        cmd.put(this.marshaller.encode(key));
        cmd.putAll(this.marshaller.encode(members));
        return this.execute(cmd);
    }

    Uni<Response> _sunion(K ... keys) {
        Validation.notNullOrEmpty(keys, "keys");
        ParameterValidation.doesNotContainNull((Object[])keys, (String)"keys");
        if (keys.length <= 1) {
            return Uni.createFrom().failure((Throwable)new IllegalArgumentException("`keys` must contain at least 2 keys"));
        }
        return this.execute(RedisCommand.of(Command.SUNION).put(this.marshaller.encode(keys)));
    }

    Uni<Response> _sunionstore(K destination, K ... keys) {
        ParameterValidation.nonNull(destination, (String)"destination");
        Validation.notNullOrEmpty(keys, "keys");
        ParameterValidation.doesNotContainNull((Object[])keys, (String)"keys");
        if (keys.length <= 1) {
            return Uni.createFrom().failure((Throwable)new IllegalArgumentException("`keys` must contain at least 2 keys"));
        }
        RedisCommand cmd = RedisCommand.of(Command.SUNIONSTORE).put(this.marshaller.encode(destination)).putAll(this.marshaller.encode(keys));
        return this.execute(cmd);
    }
}

