/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.datasource;

import io.quarkus.redis.datasource.codecs.Codec;
import io.quarkus.redis.datasource.codecs.Codecs;
import io.quarkus.redis.datasource.geo.GeoAddArgs;
import io.quarkus.redis.datasource.geo.GeoItem;
import io.quarkus.redis.datasource.geo.GeoPosition;
import io.quarkus.redis.datasource.geo.GeoRadiusArgs;
import io.quarkus.redis.datasource.geo.GeoRadiusStoreArgs;
import io.quarkus.redis.datasource.geo.GeoSearchArgs;
import io.quarkus.redis.datasource.geo.GeoSearchStoreArgs;
import io.quarkus.redis.datasource.geo.GeoUnit;
import io.quarkus.redis.datasource.geo.GeoValue;
import io.quarkus.redis.runtime.datasource.AbstractRedisCommands;
import io.quarkus.redis.runtime.datasource.Marshaller;
import io.quarkus.redis.runtime.datasource.RedisCommand;
import io.quarkus.redis.runtime.datasource.RedisCommandExecutor;
import io.quarkus.redis.runtime.datasource.Validation;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.vertx.mutiny.redis.client.Command;
import io.vertx.mutiny.redis.client.Response;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.Set;
import java.util.regex.Pattern;

class AbstractGeoCommands<K, V>
extends AbstractRedisCommands {
    protected final Type typeOfValue;
    protected final Codec keyCodec;
    protected final Codec valueCodec;
    private static final Pattern NOISE_REMOVER_PATTERN = Pattern.compile("[^a-zA-Z0-9\\.]");

    AbstractGeoCommands(RedisCommandExecutor redis, Type k, Type v) {
        super(redis, new Marshaller(k, v));
        this.typeOfValue = v;
        this.keyCodec = Codecs.getDefaultCodecFor(k);
        this.valueCodec = Codecs.getDefaultCodecFor(v);
    }

    Uni<Response> _geoadd(K key, double longitude, double latitude, V member, GeoAddArgs args) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(member, (String)"member");
        ParameterValidation.nonNull((Object)args, (String)"args");
        Validation.validateLongitude(longitude);
        Validation.validateLatitude(latitude);
        RedisCommand cmd = RedisCommand.of(Command.GEOADD).put(this.marshaller.encode(key)).putAll(args.toArgs()).put(longitude).put(latitude).put(this.marshaller.encode(member));
        return this.execute(cmd);
    }

    Uni<Response> _geoadd(K key, GeoItem<V> ... items) {
        ParameterValidation.nonNull(key, (String)"key");
        Validation.notNullOrEmpty(items, "items");
        ParameterValidation.doesNotContainNull((Object[])items, (String)"items");
        RedisCommand cmd = RedisCommand.of(Command.GEOADD).put(this.marshaller.encode(key));
        for (GeoItem<V> item : items) {
            cmd.put(Double.toString(item.longitude())).put(Double.toString(item.latitude())).put(this.marshaller.encode(item.member()));
        }
        return this.execute(cmd);
    }

    Uni<Response> _geoadd(K key, GeoAddArgs args, GeoItem<V> ... items) {
        ParameterValidation.nonNull(key, (String)"key");
        Validation.notNullOrEmpty(items, "items");
        ParameterValidation.doesNotContainNull((Object[])items, (String)"items");
        ParameterValidation.nonNull((Object)args, (String)"args");
        RedisCommand cmd = RedisCommand.of(Command.GEOADD).put(this.marshaller.encode(key)).put(args);
        for (GeoItem<V> item : items) {
            cmd.put(Double.toString(item.longitude()));
            cmd.put(Double.toString(item.latitude()));
            cmd.put(this.marshaller.encode(item.member()));
        }
        return this.execute(cmd);
    }

    Uni<Response> _geodist(K key, V from, V to, GeoUnit unit) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(from, (String)"from");
        ParameterValidation.nonNull(to, (String)"to");
        ParameterValidation.nonNull((Object)((Object)unit), (String)"unit");
        return this.execute(RedisCommand.of(Command.GEODIST).put(this.marshaller.encode(key)).put(this.marshaller.encode(from)).put(this.marshaller.encode(to)).put(unit.toString()));
    }

    Uni<Response> _geohash(K key, V ... members) {
        ParameterValidation.nonNull(key, (String)"key");
        Validation.notNullOrEmpty(members, "members");
        ParameterValidation.doesNotContainNull((Object[])members, (String)"members");
        RedisCommand cmd = RedisCommand.of(Command.GEOHASH);
        cmd.put(this.marshaller.encode(key));
        for (V member : members) {
            cmd.put(this.marshaller.encode(member));
        }
        return this.execute(cmd);
    }

    Uni<Response> _geopos(K key, V ... members) {
        ParameterValidation.nonNull(key, (String)"key");
        Validation.notNullOrEmpty(members, "members");
        ParameterValidation.doesNotContainNull((Object[])members, (String)"members");
        RedisCommand cmd = RedisCommand.of(Command.GEOPOS).put(this.marshaller.encode(key));
        for (V member : members) {
            cmd.put(this.marshaller.encode(member));
        }
        return this.execute(cmd);
    }

    Uni<Response> _georadius(K key, double longitude, double latitude, double radius, GeoUnit unit) {
        ParameterValidation.nonNull(key, (String)"key");
        Validation.positive(radius, "radius");
        Validation.validateLongitude(longitude);
        Validation.validateLatitude(latitude);
        ParameterValidation.nonNull((Object)((Object)unit), (String)"unit");
        return this.execute(RedisCommand.of(Command.GEORADIUS).put(this.marshaller.encode(key)).put(longitude).put(latitude).put(radius).put(unit.toString()));
    }

    Uni<Response> _georadius(K key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusArgs geoArgs) {
        ParameterValidation.nonNull(key, (String)"key");
        Validation.validateLongitude(longitude);
        Validation.validateLatitude(latitude);
        Validation.positive(radius, "radius");
        ParameterValidation.nonNull((Object)((Object)unit), (String)"unit");
        ParameterValidation.nonNull((Object)geoArgs, (String)"geoArgs");
        return this.execute(RedisCommand.of(Command.GEORADIUS).put(this.marshaller.encode(key)).put(longitude).put(latitude).put(radius).put(unit.toString()).putArgs(geoArgs));
    }

    Uni<Response> _georadius(K key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusStoreArgs<K> geoArgs) {
        ParameterValidation.nonNull(key, (String)"key");
        Validation.validateLongitude(longitude);
        Validation.validateLatitude(latitude);
        Validation.positive(radius, "radius");
        ParameterValidation.nonNull((Object)((Object)unit), (String)"unit");
        ParameterValidation.nonNull(geoArgs, (String)"geoArgs");
        return this.execute(RedisCommand.of(Command.GEORADIUS).put(this.marshaller.encode(key)).put(longitude).put(latitude).put(radius).put(unit.toString()).putArgs(geoArgs, this.keyCodec));
    }

    Uni<Response> _georadiusbymember(K key, V member, double distance, GeoUnit unit, GeoRadiusArgs geoArgs) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(member, (String)"member");
        Validation.positive(distance, "distance");
        ParameterValidation.nonNull((Object)((Object)unit), (String)"unit");
        ParameterValidation.nonNull((Object)geoArgs, (String)"geoArgs");
        return this.execute(RedisCommand.of(Command.GEORADIUSBYMEMBER).put(this.marshaller.encode(key)).put(this.marshaller.encode(member)).put(distance).put(unit.toString()).putArgs(geoArgs));
    }

    Uni<Response> _georadiusbymember(K key, V member, double distance, GeoUnit unit) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(member, (String)"member");
        Validation.positive(distance, "distance");
        ParameterValidation.nonNull((Object)((Object)unit), (String)"unit");
        return this.execute(RedisCommand.of(Command.GEORADIUSBYMEMBER).put(this.marshaller.encode(key)).put(this.marshaller.encode(member)).put(distance).put(unit.toString()));
    }

    Uni<Response> _georadiusbymember(K key, V member, double distance, GeoUnit unit, GeoRadiusStoreArgs<K> geoArgs) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(member, (String)"member");
        Validation.positive(distance, "distance");
        ParameterValidation.nonNull((Object)((Object)unit), (String)"unit");
        ParameterValidation.nonNull(geoArgs, (String)"geoArgs");
        return this.execute(RedisCommand.of(Command.GEORADIUSBYMEMBER).put(this.marshaller.encode(key)).put(this.marshaller.encode(member)).put(distance).put(unit.toString()).putArgs(geoArgs, this.keyCodec));
    }

    Uni<Response> _geosearch(K key, GeoSearchArgs<V> geoArgs) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(geoArgs, (String)"geoArgs");
        return this.execute(RedisCommand.of(Command.GEOSEARCH).put(this.marshaller.encode(key)).putArgs(geoArgs, this.valueCodec));
    }

    Uni<Response> _geosearchstore(K destination, K key, GeoSearchStoreArgs<V> args, boolean storeDist) {
        ParameterValidation.nonNull(destination, (String)"destination");
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(args, (String)"args");
        return this.execute(RedisCommand.of(Command.GEOSEARCHSTORE).put(this.marshaller.encode(destination)).put(this.marshaller.encode(key)).putArgs(args, this.valueCodec).putFlag(storeDist, "STOREDIST"));
    }

    List<String> decodeHashList(Response r) {
        return this.marshaller.decodeAsList(r, Response::toString);
    }

    Set<V> decodeRadiusSet(Response response) {
        return this.marshaller.decodeAsSet(response, this.typeOfValue);
    }

    Double decodeDistance(Response r) {
        if (r == null) {
            return null;
        }
        return AbstractGeoCommands.parseDouble(r);
    }

    List<GeoPosition> decodeGeoPositions(Response response) {
        return this.marshaller.decodeAsList(response, nested -> {
            if (nested == null) {
                return null;
            }
            return GeoPosition.of(AbstractGeoCommands.parseDouble(nested.get(0)), AbstractGeoCommands.parseDouble(nested.get(1)));
        });
    }

    List<GeoValue<V>> decodeAsListOfGeoValues(Response r, boolean withDistance, boolean withCoordinates, boolean withHash) {
        ArrayList<GeoValue<V>> list = new ArrayList<GeoValue<V>>();
        for (Response response : r) {
            double latitude;
            long hash;
            if (!(withCoordinates || withHash || withDistance)) {
                list.add(new GeoValue(this.marshaller.decode(this.typeOfValue, response), OptionalDouble.empty(), OptionalLong.empty(), OptionalDouble.empty(), OptionalDouble.empty()));
                continue;
            }
            Object member = this.marshaller.decode(this.typeOfValue, response.get(0));
            if (withCoordinates && withDistance && withHash) {
                double dist = AbstractGeoCommands.parseDouble(response.get(1));
                hash = response.get(2).toLong();
                double longitude = AbstractGeoCommands.parseDouble(response.get(3).get(0));
                double latitude2 = AbstractGeoCommands.parseDouble(response.get(3).get(1));
                list.add(new GeoValue(member, OptionalDouble.of(dist), OptionalLong.of(hash), OptionalDouble.of(longitude), OptionalDouble.of(latitude2)));
                continue;
            }
            if (withCoordinates && withDistance) {
                double dist = AbstractGeoCommands.parseDouble(response.get(1));
                double longitude = AbstractGeoCommands.parseDouble(response.get(2).get(0));
                latitude = AbstractGeoCommands.parseDouble(response.get(2).get(1));
                list.add(new GeoValue(member, OptionalDouble.of(dist), OptionalLong.empty(), OptionalDouble.of(longitude), OptionalDouble.of(latitude)));
                continue;
            }
            if (withCoordinates && withHash) {
                long hash2 = response.get(1).toLong();
                double longitude = AbstractGeoCommands.parseDouble(response.get(2).get(0));
                latitude = AbstractGeoCommands.parseDouble(response.get(2).get(1));
                list.add(new GeoValue(member, OptionalDouble.empty(), OptionalLong.of(hash2), OptionalDouble.of(longitude), OptionalDouble.of(latitude)));
                continue;
            }
            if (withCoordinates) {
                double longitude = AbstractGeoCommands.parseDouble(response.get(1).get(0));
                double latitude3 = AbstractGeoCommands.parseDouble(response.get(1).get(1));
                list.add(new GeoValue(member, OptionalDouble.empty(), OptionalLong.empty(), OptionalDouble.of(longitude), OptionalDouble.of(latitude3)));
                continue;
            }
            if (withDistance && !withHash) {
                double dist = AbstractGeoCommands.parseDouble(response.get(1));
                list.add(new GeoValue(member, OptionalDouble.of(dist), OptionalLong.empty(), OptionalDouble.empty(), OptionalDouble.empty()));
                continue;
            }
            if (!withDistance) {
                long hash3 = response.get(1).toLong();
                list.add(new GeoValue(member, OptionalDouble.empty(), OptionalLong.of(hash3), OptionalDouble.empty(), OptionalDouble.empty()));
                continue;
            }
            double dist = AbstractGeoCommands.parseDouble(response.get(1));
            hash = response.get(2).toLong();
            list.add(new GeoValue(member, OptionalDouble.of(dist), OptionalLong.of(hash), OptionalDouble.empty(), OptionalDouble.empty()));
        }
        return list;
    }

    private static double parseDouble(Response response) {
        double dist;
        try {
            dist = response.toDouble();
        }
        catch (NumberFormatException e) {
            String s = NOISE_REMOVER_PATTERN.matcher(response.toString()).replaceAll("");
            dist = Double.parseDouble(s);
        }
        return dist;
    }
}

