/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.client;

import io.quarkus.redis.client.RedisClient;
import io.quarkus.redis.client.reactive.ReactiveRedisClient;
import io.quarkus.redis.datasource.ReactiveRedisDataSource;
import io.quarkus.redis.datasource.RedisDataSource;
import io.quarkus.redis.datasource.codecs.Codec;
import io.quarkus.redis.datasource.codecs.Codecs;
import io.quarkus.redis.runtime.client.ObservableRedis;
import io.quarkus.redis.runtime.client.ObservableRedisMetrics;
import io.quarkus.redis.runtime.client.ReactiveRedisClientImpl;
import io.quarkus.redis.runtime.client.RedisClientImpl;
import io.quarkus.redis.runtime.client.RedisDataLoader;
import io.quarkus.redis.runtime.client.VertxRedisClientFactory;
import io.quarkus.redis.runtime.client.config.RedisClientConfig;
import io.quarkus.redis.runtime.client.config.RedisConfig;
import io.quarkus.redis.runtime.datasource.BlockingRedisDataSourceImpl;
import io.quarkus.redis.runtime.datasource.ReactiveRedisDataSourceImpl;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.tls.TlsConfigurationRegistry;
import io.vertx.core.Vertx;
import io.vertx.mutiny.redis.client.Command;
import io.vertx.mutiny.redis.client.Redis;
import io.vertx.mutiny.redis.client.RedisAPI;
import io.vertx.mutiny.redis.client.Request;
import io.vertx.mutiny.redis.client.Response;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

@Recorder
public class RedisClientRecorder {
    private final RuntimeValue<RedisConfig> config;
    private static final Map<String, RedisClientAndApi> clients = new HashMap<String, RedisClientAndApi>();
    private static final Map<String, ReactiveRedisDataSourceImpl> dataSources = new HashMap<String, ReactiveRedisDataSourceImpl>();
    private io.vertx.mutiny.core.Vertx vertx;
    private ObservableRedisMetrics metrics;

    public RedisClientRecorder(RuntimeValue<RedisConfig> rc) {
        this.config = rc;
    }

    public void initialize(RuntimeValue<Vertx> vertx, Set<String> names, Supplier<TlsConfigurationRegistry> registry) {
        Instance instance = CDI.current().select(ObservableRedisMetrics.class, new Annotation[0]);
        this.metrics = instance.isResolvable() ? (ObservableRedisMetrics)instance.get() : null;
        this.vertx = io.vertx.mutiny.core.Vertx.newInstance((Vertx)((Vertx)vertx.getValue()));
        TlsConfigurationRegistry tlsRegistry = registry.get();
        RedisClientRecorder._registerCodecs();
        this._initialize((Vertx)vertx.getValue(), names, tlsRegistry);
    }

    private static void _registerCodecs() {
        Instance codecs = CDI.current().select(Codec.class, new Annotation[0]);
        Codecs.register(codecs.stream());
    }

    public void _initialize(Vertx vertx, Set<String> names, TlsConfigurationRegistry tlsRegistry) {
        for (final String name : names) {
            Optional<RedisClientConfig> maybe = RedisClientRecorder.getConfigForName((RedisConfig)this.config.getValue(), name);
            if (!RedisConfig.isDefaultClient(name)) {
                RedisClientConfig actualConfig = maybe.orElseThrow(new Supplier<ConfigurationException>(){

                    @Override
                    public ConfigurationException get() {
                        return new ConfigurationException("The application contains a @RedisClientName(\"" + name + "\"), but the application configuration does not configure this redis client configuration with that name. You must at least configure `quarkus.redis." + name + ".hosts`.");
                    }
                });
                clients.computeIfAbsent(name, x -> new RedisClientAndApi(name, VertxRedisClientFactory.create(name, vertx, actualConfig, tlsRegistry), this.metrics));
                continue;
            }
            if (!"<default>".equalsIgnoreCase(name) || !maybe.isPresent()) continue;
            clients.computeIfAbsent(name, x -> new RedisClientAndApi(name, VertxRedisClientFactory.create("<default>", vertx, (RedisClientConfig)maybe.get(), tlsRegistry), this.metrics));
        }
    }

    static Optional<RedisClientConfig> getConfigForName(RedisConfig cfg, String name) {
        if (RedisConfig.isDefaultClient(name)) {
            return Optional.ofNullable(cfg.defaultRedisClient());
        }
        for (Map.Entry<String, RedisClientConfig> entry : cfg.namedRedisClients().entrySet()) {
            if (!entry.getKey().equalsIgnoreCase(name)) continue;
            return Optional.of(entry.getValue());
        }
        return Optional.empty();
    }

    public Supplier<Redis> getRedisClient(final String name) {
        return new Supplier<Redis>(){

            @Override
            public Redis get() {
                return RedisClientRecorder.clients.get((Object)name).redis;
            }
        };
    }

    public Supplier<io.vertx.redis.client.Redis> getBareRedisClient(final String name) {
        return new Supplier<io.vertx.redis.client.Redis>(){

            @Override
            public io.vertx.redis.client.Redis get() {
                return RedisClientRecorder.clients.get((Object)name).observable;
            }
        };
    }

    public Supplier<RedisAPI> getRedisAPI(final String name) {
        return new Supplier<RedisAPI>(){

            @Override
            public RedisAPI get() {
                return RedisClientRecorder.clients.get((Object)name).api;
            }
        };
    }

    public Supplier<io.vertx.redis.client.RedisAPI> getBareRedisAPI(final String name) {
        return new Supplier<io.vertx.redis.client.RedisAPI>(){

            @Override
            public io.vertx.redis.client.RedisAPI get() {
                return RedisClientRecorder.clients.get((Object)name).api.getDelegate();
            }
        };
    }

    public Supplier<ReactiveRedisDataSource> getReactiveDataSource(final String name) {
        return new Supplier<ReactiveRedisDataSource>(){

            @Override
            public ReactiveRedisDataSource get() {
                return dataSources.computeIfAbsent(name, k -> {
                    RedisClientAndApi redisClientAndApi = clients.get(name);
                    Redis redis = redisClientAndApi.redis;
                    RedisAPI api = redisClientAndApi.api;
                    return new ReactiveRedisDataSourceImpl(RedisClientRecorder.this.vertx, redis, api);
                });
            }
        };
    }

    public Supplier<RedisDataSource> getBlockingDataSource(final String name) {
        return new Supplier<RedisDataSource>(){

            @Override
            public RedisDataSource get() {
                Duration timeout = RedisClientRecorder.this.getTimeoutForClient(name);
                return new BlockingRedisDataSourceImpl((ReactiveRedisDataSourceImpl)RedisClientRecorder.this.getReactiveDataSource(name).get(), timeout);
            }
        };
    }

    public Supplier<RedisClient> getLegacyRedisClient(final String name) {
        return new Supplier<RedisClient>(){

            @Override
            public RedisClient get() {
                Duration timeout = RedisClientRecorder.this.getTimeoutForClient(name);
                return new RedisClientImpl(RedisClientRecorder.this.getRedisClient(name).get(), RedisClientRecorder.this.getRedisAPI(name).get(), timeout);
            }
        };
    }

    private Duration getTimeoutForClient(String name) {
        Duration timeout = RedisConfig.isDefaultClient(name) ? ((RedisConfig)this.config.getValue()).defaultRedisClient().timeout() : ((RedisConfig)this.config.getValue()).namedRedisClients().get(name).timeout();
        return timeout;
    }

    public Supplier<ReactiveRedisClient> getLegacyReactiveRedisClient(final String name) {
        return new Supplier<ReactiveRedisClient>(){

            @Override
            public ReactiveRedisClient get() {
                return new ReactiveRedisClientImpl(RedisClientRecorder.this.getRedisClient(name).get(), RedisClientRecorder.this.getRedisAPI(name).get());
            }
        };
    }

    public void cleanup(ShutdownContext context) {
        context.addShutdownTask(new Runnable(){

            @Override
            public void run() {
                for (RedisClientAndApi value : clients.values()) {
                    value.redis.close();
                }
                clients.clear();
                dataSources.clear();
            }
        });
    }

    public void preload(String name, List<String> loadScriptPaths, boolean redisFlushBeforeLoad, boolean redisLoadOnlyIfEmpty) {
        Response list;
        RedisClientAndApi tuple = clients.get(name);
        if (tuple == null) {
            throw new IllegalArgumentException("Unable import data into Redis - cannot find the Redis client " + name + ", available clients are: " + String.valueOf(clients.keySet()));
        }
        if (redisFlushBeforeLoad) {
            tuple.redis.send(Request.cmd((Command)Command.FLUSHALL)).await().indefinitely();
        } else if (redisLoadOnlyIfEmpty && (list = (Response)tuple.redis.send(Request.cmd((Command)Command.KEYS).arg("*")).await().indefinitely()).size() != 0) {
            RedisDataLoader.LOGGER.debugf("Skipping the Redis data loading because the database is not empty: %d keys found", list.size());
            return;
        }
        for (String path : loadScriptPaths) {
            RedisDataLoader.load(this.vertx, tuple.redis, path);
        }
    }

    private static class RedisClientAndApi {
        private final Redis redis;
        private final RedisAPI api;
        private final ObservableRedis observable;

        private RedisClientAndApi(String name, io.vertx.redis.client.Redis redis, ObservableRedisMetrics metrics) {
            this.observable = new ObservableRedis(redis, name, metrics);
            this.redis = Redis.newInstance((io.vertx.redis.client.Redis)this.observable);
            this.api = RedisAPI.api((Redis)this.redis);
        }
    }
}

