/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.datasource.sortedset;

public class Range<V> {
    private final V min;
    private final V max;
    private final boolean inclusiveMin;
    private final boolean inclusiveMax;
    public static final Range<?> UNBOUNDED = new Range<Object>(null, null);

    public static <V> Range<V> unbounded() {
        return UNBOUNDED;
    }

    public Range(V min, V max) {
        this.min = min;
        this.max = max;
        this.inclusiveMin = true;
        this.inclusiveMax = true;
    }

    public Range(V min, boolean inclusiveMin, V max, boolean inclusiveMax) {
        this.min = min;
        this.max = max;
        this.inclusiveMin = inclusiveMin;
        this.inclusiveMax = inclusiveMax;
    }

    public boolean isUnbounded() {
        return this == UNBOUNDED;
    }

    public String getLowerBound() {
        if (this.isUnbounded() || this.min == null || this.min.equals("-")) {
            return "-";
        }
        if (!this.inclusiveMin) {
            return "(" + String.valueOf(this.min);
        }
        return "[" + String.valueOf(this.min);
    }

    public String getUpperBound() {
        if (this.isUnbounded() || this.max == null || this.max.equals("+")) {
            return "+";
        }
        if (!this.inclusiveMax) {
            return "(" + String.valueOf(this.max);
        }
        return "[" + String.valueOf(this.max);
    }
}

