/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.datasource;

import io.quarkus.redis.datasource.RedisDataSource;
import io.quarkus.redis.datasource.string.StringCommands;
import io.quarkus.redis.datasource.value.GetExArgs;
import io.quarkus.redis.datasource.value.ReactiveValueCommands;
import io.quarkus.redis.datasource.value.SetArgs;
import io.quarkus.redis.datasource.value.ValueCommands;
import io.quarkus.redis.runtime.datasource.AbstractRedisCommandGroup;
import java.time.Duration;
import java.util.Map;

public class BlockingStringCommandsImpl<K, V>
extends AbstractRedisCommandGroup
implements StringCommands<K, V>,
ValueCommands<K, V> {
    private final ReactiveValueCommands<K, V> reactive;

    public BlockingStringCommandsImpl(RedisDataSource ds, ReactiveValueCommands<K, V> reactive, Duration timeout) {
        super(ds, timeout);
        this.reactive = reactive;
    }

    @Override
    public long append(K key, V value) {
        return (Long)this.reactive.append(key, value).await().atMost(this.timeout);
    }

    @Override
    public long decr(K key) {
        return (Long)this.reactive.decr(key).await().atMost(this.timeout);
    }

    @Override
    public long decrby(K key, long amount) {
        return (Long)this.reactive.decrby(key, amount).await().atMost(this.timeout);
    }

    @Override
    public V get(K key) {
        return (V)this.reactive.get(key).await().atMost(this.timeout);
    }

    @Override
    public V getdel(K key) {
        return (V)this.reactive.getdel(key).await().atMost(this.timeout);
    }

    @Override
    public V getex(K key, io.quarkus.redis.datasource.string.GetExArgs args) {
        return (V)this.reactive.getex(key, args).await().atMost(this.timeout);
    }

    @Override
    public V getex(K key, GetExArgs args) {
        return (V)this.reactive.getex(key, args).await().atMost(this.timeout);
    }

    @Override
    public String getrange(K key, long start, long end) {
        return (String)this.reactive.getrange(key, start, end).await().atMost(this.timeout);
    }

    @Override
    public V getset(K key, V value) {
        return (V)this.reactive.getset(key, value).await().atMost(this.timeout);
    }

    @Override
    public long incr(K key) {
        return (Long)this.reactive.incr(key).await().atMost(this.timeout);
    }

    @Override
    public long incrby(K key, long amount) {
        return (Long)this.reactive.incrby(key, amount).await().atMost(this.timeout);
    }

    @Override
    public double incrbyfloat(K key, double amount) {
        return (Double)this.reactive.incrbyfloat(key, amount).await().atMost(this.timeout);
    }

    @Override
    public String lcs(K key1, K key2) {
        return (String)this.reactive.lcs(key1, key2).await().atMost(this.timeout);
    }

    @Override
    public long lcsLength(K key1, K key2) {
        return (Long)this.reactive.lcsLength(key1, key2).await().atMost(this.timeout);
    }

    @Override
    public Map<K, V> mget(K ... keys) {
        return (Map)this.reactive.mget(keys).await().atMost(this.timeout);
    }

    @Override
    public void mset(Map<K, V> map) {
        this.reactive.mset(map).await().atMost(this.timeout);
    }

    @Override
    public boolean msetnx(Map<K, V> map) {
        return (Boolean)this.reactive.msetnx(map).await().atMost(this.timeout);
    }

    @Override
    public void set(K key, V value) {
        this.reactive.set(key, value).await().atMost(this.timeout);
    }

    @Override
    public void set(K key, V value, io.quarkus.redis.datasource.string.SetArgs setArgs) {
        this.reactive.set(key, value, setArgs).await().atMost(this.timeout);
    }

    @Override
    public void set(K key, V value, SetArgs setArgs) {
        this.reactive.set(key, value, setArgs).await().atMost(this.timeout);
    }

    @Override
    public V setGet(K key, V value) {
        return (V)this.reactive.setGet(key, value).await().atMost(this.timeout);
    }

    @Override
    public V setGet(K key, V value, io.quarkus.redis.datasource.string.SetArgs setArgs) {
        return (V)this.reactive.setGet(key, value, setArgs).await().atMost(this.timeout);
    }

    @Override
    public V setGet(K key, V value, SetArgs setArgs) {
        return (V)this.reactive.setGet(key, value, setArgs).await().atMost(this.timeout);
    }

    @Override
    public void setex(K key, long seconds, V value) {
        this.reactive.setex(key, seconds, value).await().atMost(this.timeout);
    }

    @Override
    public void psetex(K key, long milliseconds, V value) {
        this.reactive.psetex(key, milliseconds, value).await().atMost(this.timeout);
    }

    @Override
    public boolean setnx(K key, V value) {
        return (Boolean)this.reactive.setnx(key, value).await().atMost(this.timeout);
    }

    @Override
    public long setrange(K key, long offset, V value) {
        return (Long)this.reactive.setrange(key, offset, value).await().atMost(this.timeout);
    }

    @Override
    public long strlen(K key) {
        return (Long)this.reactive.strlen(key).await().atMost(this.timeout);
    }
}

