/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.datasource.timeseries;

import io.smallrye.mutiny.helpers.ParameterValidation;
import java.util.Objects;

public class Sample {
    public final long timestamp;
    public final double value;

    public Sample(long timestamp, double value) {
        this.timestamp = ParameterValidation.positiveOrZero((long)timestamp, (String)"timestamp");
        this.value = value;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public double value() {
        return this.value;
    }

    public String toString() {
        return "Sample{timestamp=" + this.timestamp + ", value=" + this.value + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Sample sample = (Sample)o;
        return this.timestamp == sample.timestamp && Double.compare(sample.value, this.value) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.timestamp, this.value);
    }
}

