/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.deployment.client;

import io.quarkus.deployment.Feature;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.builditem.CuratedApplicationShutdownBuildItem;
import io.quarkus.deployment.builditem.DevServicesComposeProjectBuildItem;
import io.quarkus.deployment.builditem.DevServicesResultBuildItem;
import io.quarkus.deployment.builditem.DevServicesSharedNetworkBuildItem;
import io.quarkus.deployment.builditem.DockerStatusBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.console.ConsoleInstalledBuildItem;
import io.quarkus.deployment.console.StartupLogCompressor;
import io.quarkus.deployment.dev.devservices.DevServicesConfig;
import io.quarkus.deployment.logging.LoggingSetupBuildItem;
import io.quarkus.devservices.common.ComposeLocator;
import io.quarkus.devservices.common.ConfigureUtil;
import io.quarkus.devservices.common.ContainerLocator;
import io.quarkus.redis.deployment.client.DevServicesConfig;
import io.quarkus.redis.deployment.client.RedisBuildTimeConfig;
import io.quarkus.redis.runtime.client.config.RedisConfig;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ConfigUtils;
import java.io.Closeable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.utility.DockerImageName;

@BuildSteps(onlyIfNot={IsNormal.class}, onlyIf={DevServicesConfig.Enabled.class})
public class DevServicesRedisProcessor {
    private static final Logger log = Logger.getLogger(DevServicesRedisProcessor.class);
    private static final String REDIS_IMAGE = "docker.io/redis:7";
    private static final int REDIS_EXPOSED_PORT = 6379;
    private static final String REDIS_SCHEME = "redis://";
    private static final String DEV_SERVICE_LABEL = "quarkus-dev-service-redis";
    private static final ContainerLocator redisContainerLocator = ContainerLocator.locateContainerWithLabels((int)6379, (String[])new String[]{"quarkus-dev-service-redis"});
    private static final String QUARKUS = "quarkus.";
    private static final String DOT = ".";
    private static volatile List<DevServicesResultBuildItem.RunningDevService> devServices;
    private static volatile Map<String, RedisBuildTimeConfig.DevServiceConfiguration> capturedDevServicesConfiguration;
    private static volatile boolean first;

    @BuildStep
    public List<DevServicesResultBuildItem> startRedisContainers(LaunchModeBuildItem launchMode, DockerStatusBuildItem dockerStatusBuildItem, DevServicesComposeProjectBuildItem composeProjectBuildItem, List<DevServicesSharedNetworkBuildItem> devServicesSharedNetworkBuildItem, RedisBuildTimeConfig config, Optional<ConsoleInstalledBuildItem> consoleInstalledBuildItem, CuratedApplicationShutdownBuildItem closeBuildItem, LoggingSetupBuildItem loggingSetupBuildItem, io.quarkus.deployment.dev.devservices.DevServicesConfig devServicesConfig) {
        HashMap<String, RedisBuildTimeConfig.DevServiceConfiguration> currentDevServicesConfiguration = new HashMap<String, RedisBuildTimeConfig.DevServiceConfiguration>(config.additionalDevServices());
        currentDevServicesConfiguration.put("<default>", config.defaultDevService());
        if (devServices != null) {
            boolean restartRequired;
            boolean bl = restartRequired = !currentDevServicesConfiguration.equals(capturedDevServicesConfiguration);
            if (!restartRequired) {
                return devServices.stream().map(DevServicesResultBuildItem.RunningDevService::toBuildItem).collect(Collectors.toList());
            }
            for (Closeable closeable : devServices) {
                try {
                    closeable.close();
                }
                catch (Throwable throwable) {
                    log.error((Object)"Failed to stop redis container", throwable);
                }
            }
            devServices = null;
            capturedDevServicesConfiguration = null;
        }
        capturedDevServicesConfiguration = currentDevServicesConfiguration;
        ArrayList<DevServicesResultBuildItem.RunningDevService> newDevServices = new ArrayList<DevServicesResultBuildItem.RunningDevService>();
        StartupLogCompressor compressor = new StartupLogCompressor((launchMode.isTest() ? "(test) " : "") + "Redis Dev Services Starting:", consoleInstalledBuildItem, loggingSetupBuildItem);
        try {
            for (Map.Entry entry : currentDevServicesConfiguration.entrySet()) {
                String connectionName = (String)entry.getKey();
                boolean useSharedNetwork = DevServicesSharedNetworkBuildItem.isSharedNetworkRequired((io.quarkus.deployment.dev.devservices.DevServicesConfig)devServicesConfig, devServicesSharedNetworkBuildItem);
                DevServicesResultBuildItem.RunningDevService devService = this.startContainer(dockerStatusBuildItem, composeProjectBuildItem, connectionName, ((RedisBuildTimeConfig.DevServiceConfiguration)entry.getValue()).devservices(), launchMode.getLaunchMode(), useSharedNetwork, devServicesConfig.timeout());
                if (devService == null) continue;
                newDevServices.add(devService);
                String configKey = this.getConfigPrefix(connectionName) + "hosts";
                log.infof("The %s redis server is ready to accept connections on %s", (Object)connectionName, devService.getConfig().get(configKey));
            }
            if (newDevServices.isEmpty()) {
                compressor.closeAndDumpCaptured();
            } else {
                compressor.close();
            }
        }
        catch (Throwable throwable) {
            compressor.closeAndDumpCaptured();
            throw new RuntimeException(throwable);
        }
        devServices = newDevServices;
        if (first) {
            first = false;
            Runnable runnable = () -> {
                if (devServices != null) {
                    for (Closeable closeable : devServices) {
                        try {
                            closeable.close();
                        }
                        catch (Throwable t) {
                            log.error((Object)"Failed to stop database", t);
                        }
                    }
                }
                first = true;
                devServices = null;
                capturedDevServicesConfiguration = null;
            };
            closeBuildItem.addCloseTask(runnable, true);
        }
        return devServices.stream().map(DevServicesResultBuildItem.RunningDevService::toBuildItem).collect(Collectors.toList());
    }

    private DevServicesResultBuildItem.RunningDevService startContainer(DockerStatusBuildItem dockerStatusBuildItem, DevServicesComposeProjectBuildItem composeProjectBuildItem, String name, DevServicesConfig devServicesConfig, LaunchMode launchMode, boolean useSharedNetwork, Optional<Duration> timeout) {
        boolean needToStart;
        if (!devServicesConfig.enabled()) {
            log.debug((Object)("Not starting devservices for " + (RedisConfig.isDefaultClient((String)name) ? "default redis client" : name) + " as it has been disabled in the config"));
            return null;
        }
        String configPrefix = this.getConfigPrefix(name);
        boolean bl = needToStart = !ConfigUtils.isPropertyNonEmpty((String)(configPrefix + "hosts"));
        if (!needToStart) {
            log.debug((Object)("Not starting devservices for " + (RedisConfig.isDefaultClient((String)name) ? "default redis client" : name) + " as hosts have been provided"));
            return null;
        }
        if (!dockerStatusBuildItem.isContainerRuntimeAvailable()) {
            log.warn((Object)("Please configure quarkus.redis.hosts for " + (RedisConfig.isDefaultClient((String)name) ? "default redis client" : name) + " or get a working docker instance"));
            return null;
        }
        DockerImageName dockerImageName = DockerImageName.parse((String)devServicesConfig.imageName().orElse(REDIS_IMAGE)).asCompatibleSubstituteFor(REDIS_IMAGE);
        Supplier<DevServicesResultBuildItem.RunningDevService> defaultRedisServerSupplier = () -> {
            QuarkusPortRedisContainer redisContainer = new QuarkusPortRedisContainer(dockerImageName, devServicesConfig.port(), launchMode == LaunchMode.DEVELOPMENT ? devServicesConfig.serviceName() : null, composeProjectBuildItem.getDefaultNetworkId(), useSharedNetwork);
            timeout.ifPresent(arg_0 -> ((QuarkusPortRedisContainer)redisContainer).withStartupTimeout(arg_0));
            redisContainer.withEnv(devServicesConfig.containerEnv());
            redisContainer.start();
            String redisHost = REDIS_SCHEME + redisContainer.getHost() + ":" + redisContainer.getPort();
            return new DevServicesResultBuildItem.RunningDevService(Feature.REDIS_CLIENT.getName(), redisContainer.getContainerId(), () -> ((QuarkusPortRedisContainer)redisContainer).close(), configPrefix + "hosts", redisHost);
        };
        return redisContainerLocator.locateContainer(devServicesConfig.serviceName(), devServicesConfig.shared(), launchMode).or(() -> ComposeLocator.locateContainer((DevServicesComposeProjectBuildItem)composeProjectBuildItem, List.of(devServicesConfig.imageName().orElse("redis")), (int)6379, (LaunchMode)launchMode, (boolean)useSharedNetwork)).map(containerAddress -> {
            String redisUrl = REDIS_SCHEME + containerAddress.getUrl();
            return new DevServicesResultBuildItem.RunningDevService(Feature.REDIS_CLIENT.getName(), containerAddress.getId(), null, configPrefix + "hosts", redisUrl);
        }).orElseGet(defaultRedisServerSupplier);
    }

    private String getConfigPrefix(String name) {
        Object configPrefix = "quarkus.redis.";
        if (!RedisConfig.isDefaultClient((String)name)) {
            configPrefix = (String)configPrefix + name + DOT;
        }
        return configPrefix;
    }

    static {
        first = true;
    }

    private static class QuarkusPortRedisContainer
    extends GenericContainer<QuarkusPortRedisContainer> {
        private final OptionalInt fixedExposedPort;
        private final boolean useSharedNetwork;
        private final String hostName;

        public QuarkusPortRedisContainer(DockerImageName dockerImageName, OptionalInt fixedExposedPort, String serviceName, String defaultNetworkId, boolean useSharedNetwork) {
            super(dockerImageName);
            this.fixedExposedPort = fixedExposedPort;
            this.useSharedNetwork = useSharedNetwork;
            if (serviceName != null) {
                this.withLabel(DevServicesRedisProcessor.DEV_SERVICE_LABEL, serviceName);
                this.withLabel("io.quarkus.devservice", serviceName);
            }
            this.hostName = ConfigureUtil.configureNetwork((GenericContainer)this, (String)defaultNetworkId, (boolean)useSharedNetwork, (String)"redis");
        }

        protected void configure() {
            super.configure();
            if (this.useSharedNetwork) {
                return;
            }
            if (this.fixedExposedPort.isPresent()) {
                this.addFixedExposedPort(this.fixedExposedPort.getAsInt(), 6379);
            } else {
                this.addExposedPort(6379);
            }
        }

        public int getPort() {
            if (this.useSharedNetwork) {
                return 6379;
            }
            if (this.fixedExposedPort.isPresent()) {
                return this.fixedExposedPort.getAsInt();
            }
            return super.getFirstMappedPort();
        }

        public String getHost() {
            return this.useSharedNetwork ? this.hostName : super.getHost();
        }
    }
}

