/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.reactive.pg.client.runtime;

import io.quarkus.reactive.datasource.runtime.ThreadLocalPool;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.PgPool;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.PreparedQuery;
import io.vertx.sqlclient.Query;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.Transaction;

public class ThreadLocalPgPool
extends ThreadLocalPool<PgPool>
implements PgPool {
    private final PgConnectOptions pgConnectOptions;

    public ThreadLocalPgPool(Vertx vertx, PgConnectOptions pgConnectOptions, PoolOptions poolOptions) {
        super(vertx, poolOptions);
        this.pgConnectOptions = pgConnectOptions;
    }

    protected PgPool createThreadLocalPool() {
        return new PgPoolWrapper(PgPool.pool((Vertx)this.vertx, (PgConnectOptions)this.pgConnectOptions, (PoolOptions)this.poolOptions));
    }

    private class PgPoolWrapper
    implements PgPool {
        private final PgPool delegate;
        private boolean open = true;

        private PgPoolWrapper(PgPool delegate) {
            this.delegate = delegate;
        }

        public void getConnection(Handler<AsyncResult<SqlConnection>> handler) {
            this.delegate.getConnection(handler);
        }

        public Query<RowSet<Row>> query(String s) {
            return this.delegate.query(s);
        }

        public PreparedQuery<RowSet<Row>> preparedQuery(String s) {
            return this.delegate.preparedQuery(s);
        }

        public void begin(Handler<AsyncResult<Transaction>> handler) {
            this.delegate.begin(handler);
        }

        public void close() {
            if (this.open) {
                this.delegate.close();
                ThreadLocalPgPool.this.removeSelfFromTracking((Pool)this);
            }
        }
    }
}

