/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.reactive.pg.client.runtime;

import io.quarkus.credentials.CredentialsProvider;
import io.quarkus.credentials.runtime.CredentialsProviderFinder;
import io.quarkus.datasource.runtime.DataSourceRuntimeConfig;
import io.quarkus.datasource.runtime.DataSourcesRuntimeConfig;
import io.quarkus.reactive.datasource.runtime.DataSourceReactiveRuntimeConfig;
import io.quarkus.reactive.datasource.runtime.DataSourcesReactiveRuntimeConfig;
import io.quarkus.reactive.pg.client.runtime.DataSourceReactivePostgreSQLConfig;
import io.quarkus.reactive.pg.client.runtime.DataSourcesReactivePostgreSQLConfig;
import io.quarkus.reactive.pg.client.runtime.ThreadLocalPgPool;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.vertx.core.runtime.SSLConfigHelper;
import io.quarkus.vertx.core.runtime.config.JksConfiguration;
import io.quarkus.vertx.core.runtime.config.PemKeyCertConfiguration;
import io.quarkus.vertx.core.runtime.config.PemTrustCertConfiguration;
import io.quarkus.vertx.core.runtime.config.PfxConfiguration;
import io.vertx.core.Vertx;
import io.vertx.core.net.TCPSSLOptions;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.PgPool;
import io.vertx.sqlclient.PoolOptions;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jboss.logging.Logger;

@Recorder
public class PgPoolRecorder {
    private static final Logger log = Logger.getLogger(PgPoolRecorder.class);

    public RuntimeValue<PgPool> configurePgPool(RuntimeValue<Vertx> vertx, String dataSourceName, DataSourcesRuntimeConfig dataSourcesRuntimeConfig, DataSourcesReactiveRuntimeConfig dataSourcesReactiveRuntimeConfig, DataSourcesReactivePostgreSQLConfig dataSourcesReactivePostgreSQLConfig, ShutdownContext shutdown) {
        PgPool pgPool = this.initialize((Vertx)vertx.getValue(), dataSourcesRuntimeConfig.getDataSourceRuntimeConfig(dataSourceName), dataSourcesReactiveRuntimeConfig.getDataSourceReactiveRuntimeConfig(dataSourceName), dataSourcesReactivePostgreSQLConfig.getDataSourceReactiveRuntimeConfig(dataSourceName));
        shutdown.addShutdownTask(() -> ((PgPool)pgPool).close());
        return new RuntimeValue((Object)pgPool);
    }

    public RuntimeValue<io.vertx.mutiny.pgclient.PgPool> mutinyPgPool(RuntimeValue<PgPool> pgPool) {
        return new RuntimeValue((Object)io.vertx.mutiny.pgclient.PgPool.newInstance((PgPool)((PgPool)pgPool.getValue())));
    }

    private PgPool initialize(Vertx vertx, DataSourceRuntimeConfig dataSourceRuntimeConfig, DataSourceReactiveRuntimeConfig dataSourceReactiveRuntimeConfig, DataSourceReactivePostgreSQLConfig dataSourceReactivePostgreSQLConfig) {
        PoolOptions poolOptions = this.toPoolOptions(dataSourceRuntimeConfig, dataSourceReactiveRuntimeConfig, dataSourceReactivePostgreSQLConfig);
        PgConnectOptions pgConnectOptions = this.toPgConnectOptions(dataSourceRuntimeConfig, dataSourceReactiveRuntimeConfig, dataSourceReactivePostgreSQLConfig);
        if (dataSourceReactiveRuntimeConfig.threadLocal.isPresent()) {
            log.warn((Object)"Configuration element 'thread-local' on Reactive datasource connections is deprecated and will be ignored. The started pool will always be based on a per-thread separate pool now.");
        }
        return new ThreadLocalPgPool(vertx, pgConnectOptions, poolOptions);
    }

    private PoolOptions toPoolOptions(DataSourceRuntimeConfig dataSourceRuntimeConfig, DataSourceReactiveRuntimeConfig dataSourceReactiveRuntimeConfig, DataSourceReactivePostgreSQLConfig dataSourceReactivePostgreSQLConfig) {
        PoolOptions poolOptions = new PoolOptions();
        if (dataSourceReactiveRuntimeConfig.maxSize.isPresent()) {
            poolOptions.setMaxSize(dataSourceReactiveRuntimeConfig.maxSize.getAsInt());
        }
        return poolOptions;
    }

    private PgConnectOptions toPgConnectOptions(DataSourceRuntimeConfig dataSourceRuntimeConfig, DataSourceReactiveRuntimeConfig dataSourceReactiveRuntimeConfig, DataSourceReactivePostgreSQLConfig dataSourceReactivePostgreSQLConfig) {
        PgConnectOptions pgConnectOptions;
        if (dataSourceReactiveRuntimeConfig.url.isPresent()) {
            String url = (String)dataSourceReactiveRuntimeConfig.url.get();
            if (url.matches("^vertx-reactive:postgre(?:s|sql)://.*$")) {
                url = url.substring("vertx-reactive:".length());
            }
            pgConnectOptions = PgConnectOptions.fromUri((String)url);
        } else {
            pgConnectOptions = new PgConnectOptions();
        }
        if (dataSourceRuntimeConfig.username.isPresent()) {
            pgConnectOptions.setUser((String)dataSourceRuntimeConfig.username.get());
        }
        if (dataSourceRuntimeConfig.password.isPresent()) {
            pgConnectOptions.setPassword((String)dataSourceRuntimeConfig.password.get());
        }
        if (dataSourceRuntimeConfig.credentialsProvider.isPresent()) {
            String beanName = dataSourceRuntimeConfig.credentialsProviderName.orElse(null);
            CredentialsProvider credentialsProvider = CredentialsProviderFinder.find((String)beanName);
            String name = (String)dataSourceRuntimeConfig.credentialsProvider.get();
            Map credentials = credentialsProvider.getCredentials(name);
            String user = (String)credentials.get("user");
            String password = (String)credentials.get("password");
            if (user != null) {
                pgConnectOptions.setUser(user);
            }
            if (password != null) {
                pgConnectOptions.setPassword(password);
            }
        }
        if (dataSourceReactivePostgreSQLConfig.cachePreparedStatements.isPresent()) {
            log.warn((Object)"datasource.reactive.postgresql.cache-prepared-statements is deprecated, use datasource.reactive.cache-prepared-statements instead");
            pgConnectOptions.setCachePreparedStatements(dataSourceReactivePostgreSQLConfig.cachePreparedStatements.get().booleanValue());
        } else {
            pgConnectOptions.setCachePreparedStatements(dataSourceReactiveRuntimeConfig.cachePreparedStatements);
        }
        if (dataSourceReactivePostgreSQLConfig.pipeliningLimit.isPresent()) {
            pgConnectOptions.setPipeliningLimit(dataSourceReactivePostgreSQLConfig.pipeliningLimit.getAsInt());
        }
        if (dataSourceReactivePostgreSQLConfig.sslMode.isPresent()) {
            pgConnectOptions.setSslMode(dataSourceReactivePostgreSQLConfig.sslMode.get());
        }
        pgConnectOptions.setTrustAll(dataSourceReactiveRuntimeConfig.trustAll);
        SSLConfigHelper.configurePemTrustOptions((TCPSSLOptions)pgConnectOptions, (PemTrustCertConfiguration)dataSourceReactiveRuntimeConfig.trustCertificatePem);
        SSLConfigHelper.configureJksTrustOptions((TCPSSLOptions)pgConnectOptions, (JksConfiguration)dataSourceReactiveRuntimeConfig.trustCertificateJks);
        SSLConfigHelper.configurePfxTrustOptions((TCPSSLOptions)pgConnectOptions, (PfxConfiguration)dataSourceReactiveRuntimeConfig.trustCertificatePfx);
        SSLConfigHelper.configurePemKeyCertOptions((TCPSSLOptions)pgConnectOptions, (PemKeyCertConfiguration)dataSourceReactiveRuntimeConfig.keyCertificatePem);
        SSLConfigHelper.configureJksKeyCertOptions((TCPSSLOptions)pgConnectOptions, (JksConfiguration)dataSourceReactiveRuntimeConfig.keyCertificateJks);
        SSLConfigHelper.configurePfxKeyCertOptions((TCPSSLOptions)pgConnectOptions, (PfxConfiguration)dataSourceReactiveRuntimeConfig.keyCertificatePfx);
        pgConnectOptions.setReconnectAttempts(dataSourceReactiveRuntimeConfig.reconnectAttempts);
        pgConnectOptions.setReconnectInterval(dataSourceReactiveRuntimeConfig.reconnectInterval.toMillis());
        if (dataSourceReactiveRuntimeConfig.idleTimeout.isPresent()) {
            int idleTimeout = Math.toIntExact(((Duration)dataSourceReactiveRuntimeConfig.idleTimeout.get()).toMillis());
            pgConnectOptions.setIdleTimeout(idleTimeout).setIdleTimeoutUnit(TimeUnit.MILLISECONDS);
        }
        return pgConnectOptions;
    }
}

