/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.reactive.mssql.client.runtime;

import io.quarkus.credentials.CredentialsProvider;
import io.quarkus.credentials.runtime.CredentialsProviderFinder;
import io.quarkus.datasource.runtime.DataSourceRuntimeConfig;
import io.quarkus.datasource.runtime.DataSourcesRuntimeConfig;
import io.quarkus.reactive.datasource.runtime.DataSourceReactiveRuntimeConfig;
import io.quarkus.reactive.datasource.runtime.DataSourcesReactiveRuntimeConfig;
import io.quarkus.reactive.mssql.client.runtime.DataSourceReactiveMSSQLConfig;
import io.quarkus.reactive.mssql.client.runtime.DataSourcesReactiveMSSQLConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.vertx.core.runtime.SSLConfigHelper;
import io.quarkus.vertx.core.runtime.config.JksConfiguration;
import io.quarkus.vertx.core.runtime.config.PemKeyCertConfiguration;
import io.quarkus.vertx.core.runtime.config.PemTrustCertConfiguration;
import io.quarkus.vertx.core.runtime.config.PfxConfiguration;
import io.vertx.core.Vertx;
import io.vertx.core.net.TCPSSLOptions;
import io.vertx.mssqlclient.MSSQLConnectOptions;
import io.vertx.mutiny.mssqlclient.MSSQLPool;
import io.vertx.sqlclient.PoolOptions;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

@Recorder
public class MSSQLPoolRecorder {
    private static final Logger log = Logger.getLogger(MSSQLPoolRecorder.class);

    public RuntimeValue<io.vertx.mssqlclient.MSSQLPool> configureMSSQLPool(RuntimeValue<Vertx> vertx, Supplier<Integer> eventLoopCount, String dataSourceName, DataSourcesRuntimeConfig dataSourcesRuntimeConfig, DataSourcesReactiveRuntimeConfig dataSourcesReactiveRuntimeConfig, DataSourcesReactiveMSSQLConfig dataSourcesReactiveMSSQLConfig, ShutdownContext shutdown) {
        io.vertx.mssqlclient.MSSQLPool mssqlPool = this.initialize((Vertx)vertx.getValue(), eventLoopCount.get(), dataSourcesRuntimeConfig.getDataSourceRuntimeConfig(dataSourceName), dataSourcesReactiveRuntimeConfig.getDataSourceReactiveRuntimeConfig(dataSourceName), dataSourcesReactiveMSSQLConfig.getDataSourceReactiveRuntimeConfig(dataSourceName));
        shutdown.addShutdownTask(() -> ((io.vertx.mssqlclient.MSSQLPool)mssqlPool).close());
        return new RuntimeValue((Object)mssqlPool);
    }

    public RuntimeValue<MSSQLPool> mutinyMSSQLPool(RuntimeValue<io.vertx.mssqlclient.MSSQLPool> mssqlPool) {
        return new RuntimeValue((Object)MSSQLPool.newInstance((io.vertx.mssqlclient.MSSQLPool)((io.vertx.mssqlclient.MSSQLPool)mssqlPool.getValue())));
    }

    private io.vertx.mssqlclient.MSSQLPool initialize(Vertx vertx, Integer eventLoopCount, DataSourceRuntimeConfig dataSourceRuntimeConfig, DataSourceReactiveRuntimeConfig dataSourceReactiveRuntimeConfig, DataSourceReactiveMSSQLConfig dataSourceReactiveMSSQLConfig) {
        PoolOptions poolOptions = this.toPoolOptions(eventLoopCount, dataSourceRuntimeConfig, dataSourceReactiveRuntimeConfig, dataSourceReactiveMSSQLConfig);
        MSSQLConnectOptions mssqlConnectOptions = this.toMSSQLConnectOptions(dataSourceRuntimeConfig, dataSourceReactiveRuntimeConfig, dataSourceReactiveMSSQLConfig);
        if (dataSourceReactiveRuntimeConfig.threadLocal.isPresent()) {
            log.warn((Object)"Configuration element 'thread-local' on Reactive datasource connections is deprecated and will be ignored. The started pool will always be based on a per-thread separate pool now.");
        }
        return io.vertx.mssqlclient.MSSQLPool.pool((Vertx)vertx, (MSSQLConnectOptions)mssqlConnectOptions, (PoolOptions)poolOptions);
    }

    private PoolOptions toPoolOptions(Integer eventLoopCount, DataSourceRuntimeConfig dataSourceRuntimeConfig, DataSourceReactiveRuntimeConfig dataSourceReactiveRuntimeConfig, DataSourceReactiveMSSQLConfig dataSourceReactiveMSSQLConfig) {
        PoolOptions poolOptions = new PoolOptions();
        if (dataSourceReactiveRuntimeConfig.maxSize.isPresent()) {
            poolOptions.setMaxSize(dataSourceReactiveRuntimeConfig.maxSize.getAsInt());
        }
        if (dataSourceReactiveRuntimeConfig.idleTimeout.isPresent()) {
            int idleTimeout = Math.toIntExact(((Duration)dataSourceReactiveRuntimeConfig.idleTimeout.get()).toMillis());
            poolOptions.setIdleTimeout(idleTimeout).setIdleTimeoutUnit(TimeUnit.MILLISECONDS);
        }
        if (dataSourceReactiveRuntimeConfig.shared) {
            poolOptions.setShared(true);
            if (dataSourceReactiveRuntimeConfig.name.isPresent()) {
                poolOptions.setName((String)dataSourceReactiveRuntimeConfig.name.get());
            }
        }
        if (dataSourceReactiveRuntimeConfig.eventLoopSize.isPresent()) {
            poolOptions.setEventLoopSize(Math.max(0, dataSourceReactiveRuntimeConfig.eventLoopSize.getAsInt()));
        } else if (eventLoopCount != null) {
            poolOptions.setEventLoopSize(Math.max(0, eventLoopCount));
        }
        return poolOptions;
    }

    private MSSQLConnectOptions toMSSQLConnectOptions(DataSourceRuntimeConfig dataSourceRuntimeConfig, DataSourceReactiveRuntimeConfig dataSourceReactiveRuntimeConfig, DataSourceReactiveMSSQLConfig dataSourceReactiveMSSQLConfig) {
        MSSQLConnectOptions mssqlConnectOptions;
        if (dataSourceReactiveRuntimeConfig.url.isPresent()) {
            String url = (String)dataSourceReactiveRuntimeConfig.url.get();
            if (url.startsWith("vertx-reactive:sqlserver://")) {
                url = url.substring("vertx-reactive:".length());
            }
            mssqlConnectOptions = MSSQLConnectOptions.fromUri((String)url);
        } else {
            mssqlConnectOptions = new MSSQLConnectOptions();
        }
        if (dataSourceReactiveMSSQLConfig.packetSize.isPresent()) {
            mssqlConnectOptions.setPacketSize(dataSourceReactiveMSSQLConfig.packetSize.getAsInt());
        }
        if (dataSourceRuntimeConfig.username.isPresent()) {
            mssqlConnectOptions.setUser((String)dataSourceRuntimeConfig.username.get());
        }
        if (dataSourceRuntimeConfig.password.isPresent()) {
            mssqlConnectOptions.setPassword((String)dataSourceRuntimeConfig.password.get());
        }
        if (dataSourceRuntimeConfig.credentialsProvider.isPresent()) {
            String beanName = dataSourceRuntimeConfig.credentialsProviderName.orElse(null);
            CredentialsProvider credentialsProvider = CredentialsProviderFinder.find((String)beanName);
            String name = (String)dataSourceRuntimeConfig.credentialsProvider.get();
            Map credentials = credentialsProvider.getCredentials(name);
            String user = (String)credentials.get("user");
            String password = (String)credentials.get("password");
            if (user != null) {
                mssqlConnectOptions.setUser(user);
            }
            if (password != null) {
                mssqlConnectOptions.setPassword(password);
            }
        }
        mssqlConnectOptions.setReconnectAttempts(dataSourceReactiveRuntimeConfig.reconnectAttempts);
        mssqlConnectOptions.setReconnectInterval(dataSourceReactiveRuntimeConfig.reconnectInterval.toMillis());
        mssqlConnectOptions.setSsl(dataSourceReactiveMSSQLConfig.ssl);
        mssqlConnectOptions.setTrustAll(dataSourceReactiveRuntimeConfig.trustAll);
        SSLConfigHelper.configurePemTrustOptions((TCPSSLOptions)mssqlConnectOptions, (PemTrustCertConfiguration)dataSourceReactiveRuntimeConfig.trustCertificatePem);
        SSLConfigHelper.configureJksTrustOptions((TCPSSLOptions)mssqlConnectOptions, (JksConfiguration)dataSourceReactiveRuntimeConfig.trustCertificateJks);
        SSLConfigHelper.configurePfxTrustOptions((TCPSSLOptions)mssqlConnectOptions, (PfxConfiguration)dataSourceReactiveRuntimeConfig.trustCertificatePfx);
        SSLConfigHelper.configurePemKeyCertOptions((TCPSSLOptions)mssqlConnectOptions, (PemKeyCertConfiguration)dataSourceReactiveRuntimeConfig.keyCertificatePem);
        SSLConfigHelper.configureJksKeyCertOptions((TCPSSLOptions)mssqlConnectOptions, (JksConfiguration)dataSourceReactiveRuntimeConfig.keyCertificateJks);
        SSLConfigHelper.configurePfxKeyCertOptions((TCPSSLOptions)mssqlConnectOptions, (PfxConfiguration)dataSourceReactiveRuntimeConfig.keyCertificatePfx);
        if (dataSourceReactiveRuntimeConfig.hostnameVerificationAlgorithm.isPresent()) {
            mssqlConnectOptions.setHostnameVerificationAlgorithm((String)dataSourceReactiveRuntimeConfig.hostnameVerificationAlgorithm.get());
        }
        dataSourceReactiveRuntimeConfig.additionalProperties.forEach((arg_0, arg_1) -> ((MSSQLConnectOptions)mssqlConnectOptions).addProperty(arg_0, arg_1));
        return mssqlConnectOptions;
    }
}

