/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.reactive.mssql.client.deployment;

import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.arc.deployment.devui.Name;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.datasource.common.runtime.DatabaseKind;
import io.quarkus.datasource.deployment.spi.DefaultDataSourceDbKindBuildItem;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceConfigurationHandlerBuildItem;
import io.quarkus.datasource.runtime.DataSourceBuildTimeConfig;
import io.quarkus.datasource.runtime.DataSourcesBuildTimeConfig;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.reactive.datasource.deployment.ReactiveDataSourceBuildUtil;
import io.quarkus.reactive.datasource.deployment.ReactiveDataSourceDotNames;
import io.quarkus.reactive.datasource.deployment.VertxPoolBuildItem;
import io.quarkus.reactive.datasource.runtime.DataSourceReactiveBuildTimeConfig;
import io.quarkus.reactive.datasource.runtime.DataSourcesReactiveBuildTimeConfig;
import io.quarkus.reactive.mssql.client.MSSQLPoolCreator;
import io.quarkus.reactive.mssql.client.deployment.MSSQLPoolBuildItem;
import io.quarkus.reactive.mssql.client.runtime.MSSQLPoolRecorder;
import io.quarkus.reactive.mssql.client.runtime.MSSQLPoolSupport;
import io.quarkus.reactive.mssql.client.runtime.MsSQLServiceBindingConverter;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.smallrye.health.deployment.spi.HealthBuildItem;
import io.quarkus.vertx.core.deployment.EventLoopCountBuildItem;
import io.quarkus.vertx.deployment.VertxBuildItem;
import io.vertx.mssqlclient.MSSQLPool;
import io.vertx.mssqlclient.spi.MSSQLDriver;
import io.vertx.sqlclient.Pool;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Singleton;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;

class ReactiveMSSQLClientProcessor {
    private static final Type MSSQL_POOL_CREATOR = ClassType.create((DotName)DotName.createSimple((String)MSSQLPoolCreator.class.getName()));
    private static final ParameterizedType POOL_CREATOR_INJECTION_TYPE = ParameterizedType.create((DotName)ReactiveDataSourceDotNames.INJECT_INSTANCE, (Type[])new Type[]{MSSQL_POOL_CREATOR}, null);
    private static final DotName VERTX_MSSQL_POOL = DotName.createSimple(MSSQLPool.class);
    private static final Type VERTX_MSSQL_POOL_TYPE = ClassType.create((DotName)VERTX_MSSQL_POOL);

    ReactiveMSSQLClientProcessor() {
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    ServiceStartBuildItem build(BuildProducer<FeatureBuildItem> feature, BuildProducer<MSSQLPoolBuildItem> msSQLPool, BuildProducer<VertxPoolBuildItem> vertxPool, MSSQLPoolRecorder recorder, VertxBuildItem vertx, EventLoopCountBuildItem eventLoopCount, ShutdownContextBuildItem shutdown, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, BuildProducer<ExtensionSslNativeSupportBuildItem> sslNativeSupport, DataSourcesBuildTimeConfig dataSourcesBuildTimeConfig, DataSourcesReactiveBuildTimeConfig dataSourcesReactiveBuildTimeConfig, List<DefaultDataSourceDbKindBuildItem> defaultDataSourceDbKindBuildItems, CurateOutcomeBuildItem curateOutcomeBuildItem) {
        feature.produce((BuildItem)new FeatureBuildItem(Feature.REACTIVE_MSSQL_CLIENT));
        Stream.Builder<String> msSQLPoolNamesBuilder = Stream.builder();
        for (String dataSourceName : dataSourcesBuildTimeConfig.dataSources().keySet()) {
            if (!ReactiveMSSQLClientProcessor.isReactiveMSSQLPoolDefined(dataSourcesBuildTimeConfig, dataSourcesReactiveBuildTimeConfig, dataSourceName, defaultDataSourceDbKindBuildItems, curateOutcomeBuildItem)) continue;
            this.createPool(recorder, vertx, eventLoopCount, shutdown, msSQLPool, syntheticBeans, dataSourceName);
            msSQLPoolNamesBuilder.add(dataSourceName);
        }
        Set msSQLPoolNames = msSQLPoolNamesBuilder.build().collect(Collectors.toSet());
        if (!msSQLPoolNames.isEmpty()) {
            syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(MSSQLPoolSupport.class).scope(Singleton.class)).unremovable()).runtimeValue(recorder.createMSSQLPoolSupport(msSQLPoolNames)).setRuntimeInit().done());
        }
        sslNativeSupport.produce((BuildItem)new ExtensionSslNativeSupportBuildItem(Feature.REACTIVE_MSSQL_CLIENT));
        vertxPool.produce((BuildItem)new VertxPoolBuildItem());
        return new ServiceStartBuildItem("reactive-mssql-client");
    }

    @BuildStep
    DevServicesDatasourceConfigurationHandlerBuildItem devDbHandler() {
        return DevServicesDatasourceConfigurationHandlerBuildItem.reactive((String)"mssql");
    }

    @BuildStep
    void unremoveableBeans(BuildProducer<UnremovableBeanBuildItem> producer) {
        producer.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((Class[])new Class[]{MSSQLPoolCreator.class}));
    }

    @BuildStep
    void validateBeans(ValidationPhaseBuildItem validationPhase, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> errors) {
        HashMap<String, Boolean> seen = new HashMap<String, Boolean>();
        for (BeanInfo beanInfo : validationPhase.getContext().beans().matchBeanTypes((Predicate)new MSSQLPoolCreatorBeanClassPredicate())) {
            TreeSet<Name> qualifiers = new TreeSet<Name>();
            for (AnnotationInstance qualifier : beanInfo.getQualifiers()) {
                qualifiers.add(Name.from((AnnotationInstance)qualifier));
            }
            String qualifiersStr = qualifiers.stream().map(Name::toString).collect(Collectors.joining("_"));
            if (seen.getOrDefault(qualifiersStr, false).booleanValue()) {
                errors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new IllegalStateException("There can be at most one bean of type '" + MSSQLPoolCreator.class.getName() + "' for each datasource.")}));
                continue;
            }
            seen.put(qualifiersStr, true);
        }
    }

    @BuildStep
    void registerDriver(BuildProducer<ServiceProviderBuildItem> serviceProvider) {
        serviceProvider.produce((BuildItem)new ServiceProviderBuildItem("io.vertx.sqlclient.spi.Driver", new String[]{MSSQLDriver.class.getName()}));
    }

    @BuildStep
    void registerServiceBinding(Capabilities capabilities, BuildProducer<ServiceProviderBuildItem> serviceProvider, BuildProducer<DefaultDataSourceDbKindBuildItem> dbKind) {
        if (capabilities.isPresent("io.quarkus.kubernetes.service.binding")) {
            serviceProvider.produce((BuildItem)new ServiceProviderBuildItem("io.quarkus.kubernetes.service.binding.runtime.ServiceBindingConverter", new String[]{MsSQLServiceBindingConverter.class.getName()}));
        }
        dbKind.produce((BuildItem)new DefaultDataSourceDbKindBuildItem("mssql"));
    }

    @BuildStep
    void addHealthCheck(Capabilities capabilities, BuildProducer<HealthBuildItem> healthChecks, DataSourcesBuildTimeConfig dataSourcesBuildTimeConfig, DataSourcesReactiveBuildTimeConfig dataSourcesReactiveBuildTimeConfig, List<DefaultDataSourceDbKindBuildItem> defaultDataSourceDbKindBuildItems, CurateOutcomeBuildItem curateOutcomeBuildItem) {
        if (!capabilities.isPresent("io.quarkus.smallrye.health")) {
            return;
        }
        if (!this.hasPools(dataSourcesBuildTimeConfig, dataSourcesReactiveBuildTimeConfig, defaultDataSourceDbKindBuildItems, curateOutcomeBuildItem)) {
            return;
        }
        healthChecks.produce((BuildItem)new HealthBuildItem("io.quarkus.reactive.mssql.client.runtime.health.ReactiveMSSQLDataSourcesHealthCheck", dataSourcesBuildTimeConfig.healthEnabled()));
    }

    private void createPool(MSSQLPoolRecorder recorder, VertxBuildItem vertx, EventLoopCountBuildItem eventLoopCount, ShutdownContextBuildItem shutdown, BuildProducer<MSSQLPoolBuildItem> msSQLPool, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, String dataSourceName) {
        Function poolFunction = recorder.configureMSSQLPool(vertx.getVertx(), eventLoopCount.getEventLoopCount(), dataSourceName, (ShutdownContext)shutdown);
        msSQLPool.produce((BuildItem)new MSSQLPoolBuildItem(dataSourceName, poolFunction));
        SyntheticBeanBuildItem.ExtendedBeanConfigurator msSQLPoolBeanConfigurator = (SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(MSSQLPool.class).defaultBean()).addType(Pool.class)).scope(ApplicationScoped.class)).qualifiers(ReactiveDataSourceBuildUtil.qualifiers((String)dataSourceName))).addInjectionPoint((Type)POOL_CREATOR_INJECTION_TYPE, new AnnotationInstance[]{ReactiveDataSourceBuildUtil.qualifier((String)dataSourceName)})).checkActive(recorder.poolCheckActiveSupplier(dataSourceName)).createWith(poolFunction).unremovable()).setRuntimeInit().startup();
        syntheticBeans.produce((BuildItem)msSQLPoolBeanConfigurator.done());
        SyntheticBeanBuildItem.ExtendedBeanConfigurator mutinyMSSQLPoolConfigurator = (SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(io.vertx.mutiny.mssqlclient.MSSQLPool.class).defaultBean()).addType(io.vertx.mutiny.sqlclient.Pool.class)).scope(ApplicationScoped.class)).qualifiers(ReactiveDataSourceBuildUtil.qualifiers((String)dataSourceName))).addInjectionPoint(VERTX_MSSQL_POOL_TYPE, new AnnotationInstance[]{ReactiveDataSourceBuildUtil.qualifier((String)dataSourceName)})).checkActive(recorder.poolCheckActiveSupplier(dataSourceName)).createWith(recorder.mutinyMSSQLPool(dataSourceName)).unremovable()).setRuntimeInit().startup();
        syntheticBeans.produce((BuildItem)mutinyMSSQLPoolConfigurator.done());
    }

    private static boolean isReactiveMSSQLPoolDefined(DataSourcesBuildTimeConfig dataSourcesBuildTimeConfig, DataSourcesReactiveBuildTimeConfig dataSourcesReactiveBuildTimeConfig, String dataSourceName, List<DefaultDataSourceDbKindBuildItem> defaultDataSourceDbKindBuildItems, CurateOutcomeBuildItem curateOutcomeBuildItem) {
        DataSourceBuildTimeConfig dataSourceBuildTimeConfig = (DataSourceBuildTimeConfig)dataSourcesBuildTimeConfig.dataSources().get(dataSourceName);
        DataSourceReactiveBuildTimeConfig dataSourceReactiveBuildTimeConfig = ((DataSourcesReactiveBuildTimeConfig.DataSourceReactiveOuterNamedBuildTimeConfig)dataSourcesReactiveBuildTimeConfig.dataSources().get(dataSourceName)).reactive();
        Optional dbKind = DefaultDataSourceDbKindBuildItem.resolve((Optional)dataSourceBuildTimeConfig.dbKind(), defaultDataSourceDbKindBuildItems, (!DataSourceUtil.isDefault((String)dataSourceName) || dataSourceBuildTimeConfig.devservices().enabled().orElse(!dataSourcesBuildTimeConfig.hasNamedDataSources()) != false ? 1 : 0) != 0, (CurateOutcomeBuildItem)curateOutcomeBuildItem);
        if (!dbKind.isPresent()) {
            return false;
        }
        return DatabaseKind.isMsSQL((String)((String)dbKind.get())) && dataSourceReactiveBuildTimeConfig.enabled();
    }

    private boolean hasPools(DataSourcesBuildTimeConfig dataSourcesBuildTimeConfig, DataSourcesReactiveBuildTimeConfig dataSourcesReactiveBuildTimeConfig, List<DefaultDataSourceDbKindBuildItem> defaultDataSourceDbKindBuildItems, CurateOutcomeBuildItem curateOutcomeBuildItem) {
        if (ReactiveMSSQLClientProcessor.isReactiveMSSQLPoolDefined(dataSourcesBuildTimeConfig, dataSourcesReactiveBuildTimeConfig, "<default>", defaultDataSourceDbKindBuildItems, curateOutcomeBuildItem)) {
            return true;
        }
        for (String dataSourceName : dataSourcesBuildTimeConfig.dataSources().keySet()) {
            if (!ReactiveMSSQLClientProcessor.isReactiveMSSQLPoolDefined(dataSourcesBuildTimeConfig, dataSourcesReactiveBuildTimeConfig, dataSourceName, defaultDataSourceDbKindBuildItems, curateOutcomeBuildItem)) continue;
            return true;
        }
        return false;
    }

    private static class MSSQLPoolCreatorBeanClassPredicate
    implements Predicate<Set<Type>> {
        private MSSQLPoolCreatorBeanClassPredicate() {
        }

        @Override
        public boolean test(Set<Type> types) {
            return types.contains(MSSQL_POOL_CREATOR);
        }
    }
}

