/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.reactive.datasource.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InjectableInstance;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.reactive.datasource.ReactiveDataSource;
import io.vertx.sqlclient.Pool;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.Bean;
import java.lang.annotation.Annotation;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;

public final class ReactiveDataSourceUtil {
    private ReactiveDataSourceUtil() {
    }

    public static InjectableInstance<Pool> dataSourceInstance(String dataSourceName) {
        return ReactiveDataSourceUtil.dataSourceInstance(Pool.class, dataSourceName);
    }

    public static <T extends Pool> InjectableInstance<T> dataSourceInstance(Class<T> type, String dataSourceName) {
        return Arc.container().select(type, new Annotation[]{ReactiveDataSourceUtil.qualifier(dataSourceName)});
    }

    public static Optional<Pool> dataSourceIfActive(String dataSourceName) {
        return ReactiveDataSourceUtil.dataSourceIfActive(Pool.class, dataSourceName);
    }

    public static <T extends Pool> Optional<T> dataSourceIfActive(Class<T> type, String dataSourceName) {
        InjectableInstance<T> instance = ReactiveDataSourceUtil.dataSourceInstance(type, dataSourceName);
        if (!instance.isResolvable() || instance.getHandle().getBean().isActive()) {
            return Optional.ofNullable((Pool)instance.get());
        }
        return Optional.empty();
    }

    public static Set<String> activeDataSourceNames() {
        LinkedHashSet<String> activeNames = new LinkedHashSet<String>();
        for (InstanceHandle handle : Arc.container().select(Pool.class, new Annotation[0]).handles()) {
            String name;
            InjectableBean bean = handle.getBean();
            if (bean == null || !bean.isActive() || (name = ReactiveDataSourceUtil.dataSourceName((Bean<? extends Pool>)bean)) == null) continue;
            activeNames.add(name);
        }
        return activeNames;
    }

    public static String dataSourceName(Bean<? extends Pool> bean) {
        for (Object qualifier : bean.getQualifiers()) {
            if (!(qualifier instanceof ReactiveDataSource)) continue;
            return ((ReactiveDataSource)qualifier).value();
        }
        return "<default>";
    }

    public static Annotation qualifier(String dataSourceName) {
        if (DataSourceUtil.isDefault((String)dataSourceName)) {
            return Default.Literal.INSTANCE;
        }
        return new ReactiveDataSource.ReactiveDataSourceLiteral(dataSourceName);
    }
}

