/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.tracing.restclient;

import io.opentelemetry.api.trace.Tracer;
import io.quarkus.opentelemetry.runtime.tracing.restclient.ClientTracingFilter;
import java.lang.annotation.Annotation;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.CDI;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.spi.RestClientListener;
import org.jboss.logging.Logger;

public class QuarkusRestClientListener
implements RestClientListener {
    private static final Logger log = Logger.getLogger(QuarkusRestClientListener.class);
    Tracer tracer;
    boolean initialized = false;
    boolean tracingEnabled = false;

    public void onNewClient(Class<?> clientInterface, RestClientBuilder restClientBuilder) {
        if (this.setupTracer()) {
            restClientBuilder.register((Object)new ClientTracingFilter(this.tracer));
        }
    }

    private boolean setupTracer() {
        if (!this.initialized) {
            Instance tracerInstance = CDI.current().select(Tracer.class, new Annotation[0]);
            if (tracerInstance.isResolvable()) {
                this.tracer = (Tracer)tracerInstance.get();
                this.tracingEnabled = true;
            } else {
                log.warn((Object)"Unable to resolve Tracer instance, no ClientTracingFilter registered on REST Client.");
            }
            this.initialized = true;
        }
        return this.tracingEnabled;
    }
}

