/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.tracing.intrumentation.reactivemessaging;

import io.opentelemetry.context.Context;
import io.quarkus.opentelemetry.runtime.QuarkusContextStorage;
import io.smallrye.mutiny.Multi;
import io.smallrye.reactive.messaging.PublisherDecorator;
import io.smallrye.reactive.messaging.SubscriberDecorator;
import io.smallrye.reactive.messaging.TracingMetadata;
import io.smallrye.reactive.messaging.providers.locals.LocalContextMetadata;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import org.eclipse.microprofile.reactive.messaging.Message;

@ApplicationScoped
public class ReactiveMessagingTracingDecorator
implements PublisherDecorator,
SubscriberDecorator {
    public int getPriority() {
        return 1000;
    }

    public Multi<? extends Message<?>> decorate(Multi<? extends Message<?>> publisher, String channelName, boolean isConnector) {
        Multi multi = publisher;
        if (isConnector) {
            multi = multi.invoke(m -> {
                io.vertx.core.Context messageContext = m.getMetadata(LocalContextMetadata.class).map(LocalContextMetadata::context).orElse(null);
                Context otelContext = TracingMetadata.fromMessage((Message)m).map(TracingMetadata::getCurrentContext).orElse(Context.current());
                if (messageContext != null && otelContext != null) {
                    QuarkusContextStorage.INSTANCE.attach(messageContext, otelContext);
                }
            });
        }
        return multi;
    }

    public Multi<? extends Message<?>> decorate(Multi<? extends Message<?>> toBeSubscribed, List<String> channelName, boolean isConnector) {
        Multi multi = toBeSubscribed;
        if (isConnector) {
            multi = multi.map(m -> {
                Message message = m;
                if (m.getMetadata(TracingMetadata.class).isEmpty()) {
                    Context otelContext = QuarkusContextStorage.INSTANCE.current();
                    message = m.addMetadata((Object)TracingMetadata.withCurrent((Context)otelContext));
                }
                return message;
            });
        }
        return multi;
    }
}

