/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime.dev.ui;

import io.quarkus.arc.Arc;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.runtime.DefaultTokenStateManager;
import io.quarkus.oidc.runtime.TenantConfigBean;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Handler;
import io.vertx.core.http.Cookie;
import io.vertx.ext.web.RoutingContext;
import java.lang.annotation.Annotation;

final class OidcDevSessionCookieReaderHandler
implements Handler<RoutingContext> {
    OidcDevSessionCookieReaderHandler() {
    }

    public void handle(RoutingContext rc) {
        Cookie cookie = rc.request().getCookie("q_session");
        if (cookie != null) {
            DefaultTokenStateManager tokenStateManager = (DefaultTokenStateManager)Arc.container().instance(DefaultTokenStateManager.class, new Annotation[0]).get();
            OidcTenantConfig defaultTenantConfig = OidcDevSessionCookieReaderHandler.getDefaultTenantConfig();
            Uni tokensUni = tokenStateManager.getTokens(rc, defaultTenantConfig, cookie.getValue(), null);
            tokensUni.subscribe().with(tokens -> {
                rc.response().setStatusCode(200);
                rc.response().putHeader("Content-Type", "application/json");
                rc.end("{\"id_token\": \"" + tokens.getIdToken() + "\", \"access_token\": \"" + tokens.getAccessToken() + "\", \"refresh_token\": \"" + tokens.getRefreshToken() + "\"}");
            }, arg_0 -> ((RoutingContext)rc).fail(arg_0));
        } else {
            rc.response().setStatusCode(200);
            rc.response().putHeader("Content-Type", "application/json");
            rc.end("{}");
        }
    }

    private static OidcTenantConfig getDefaultTenantConfig() {
        TenantConfigBean tenantConfigBean = (TenantConfigBean)Arc.container().instance(TenantConfigBean.class, new Annotation[0]).get();
        if (tenantConfigBean.getDefaultTenant() != null && tenantConfigBean.getDefaultTenant().oidcConfig() != null) {
            return tenantConfigBean.getDefaultTenant().oidcConfig();
        }
        return OidcTenantConfig.builder().build();
    }
}

