/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.deployment.devservices;

import io.quarkus.devconsole.runtime.spi.DevConsolePostHandler;
import io.quarkus.oidc.deployment.devservices.OidcDevServicesUtils;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpHeaders;
import io.vertx.ext.web.RoutingContext;
import io.vertx.mutiny.ext.web.client.HttpResponse;
import io.vertx.mutiny.ext.web.client.WebClient;
import java.time.Duration;
import org.jboss.logging.Logger;

public class OidcTestServiceHandler
extends DevConsolePostHandler {
    private static final Logger LOG = Logger.getLogger(OidcTestServiceHandler.class);
    Vertx vertxInstance;
    Duration timeout;

    public OidcTestServiceHandler(Vertx vertxInstance, Duration timeout) {
        this.vertxInstance = vertxInstance;
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handlePostAsync(RoutingContext event, MultiMap form) throws Exception {
        try (WebClient client = OidcDevServicesUtils.createWebClient(this.vertxInstance);){
            this.testServiceInternal(event, client, form.get("serviceUrl"), form.get("token"));
        }
    }

    private void testServiceInternal(RoutingContext event, WebClient client, String serviceUrl, String token) {
        try {
            LOG.infof("Test token: %s", (Object)token);
            LOG.infof("Sending token to '%s'", (Object)serviceUrl);
            int statusCode = ((HttpResponse)client.getAbs(serviceUrl).putHeader(HttpHeaders.AUTHORIZATION.toString(), "Bearer " + token).send().await().atMost(this.timeout)).statusCode();
            LOG.infof("Result: %d", (Object)statusCode);
            event.put("result", (Object)String.valueOf(statusCode));
        }
        catch (Throwable t) {
            LOG.errorf("Token can not be sent to the service: %s", (Object)t.toString());
        }
    }

    protected void actionSuccess(RoutingContext event) {
        event.response().setStatusCode(200);
        String result = (String)event.get("result");
        if (result != null) {
            event.response().end(result);
        }
    }
}

