/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.client.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.SyntheticCreationalContext;
import io.quarkus.oidc.client.OidcClient;
import io.quarkus.oidc.client.OidcClientException;
import io.quarkus.oidc.client.OidcClients;
import io.quarkus.oidc.client.Tokens;
import io.quarkus.oidc.client.runtime.DisabledOidcClientException;
import io.quarkus.oidc.client.runtime.OidcClientConfig;
import io.quarkus.oidc.client.runtime.OidcClientImpl;
import io.quarkus.oidc.client.runtime.OidcClientsConfig;
import io.quarkus.oidc.common.OidcEndpoint;
import io.quarkus.oidc.common.OidcRequestContextProperties;
import io.quarkus.oidc.common.OidcRequestFilter;
import io.quarkus.oidc.common.OidcResponseFilter;
import io.quarkus.oidc.common.runtime.OidcCommonUtils;
import io.quarkus.oidc.common.runtime.OidcTlsSupport;
import io.quarkus.oidc.common.runtime.config.OidcClientCommonConfig;
import io.quarkus.oidc.common.runtime.config.OidcCommonConfig;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.ext.web.client.WebClientOptions;
import io.vertx.mutiny.core.MultiMap;
import io.vertx.mutiny.ext.web.client.WebClient;
import jakarta.enterprise.inject.CreationException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jboss.logging.Logger;

@Recorder
public class OidcClientRecorder {
    private static final Logger LOG = Logger.getLogger(OidcClientRecorder.class);
    private static final String CLIENT_ID_ATTRIBUTE = "client-id";
    static final String DEFAULT_OIDC_CLIENT_ID = "Default";

    static Map<String, OidcClient> createStaticOidcClients(OidcClientsConfig oidcClientsConfig, Vertx vertx, OidcTlsSupport tlsSupport, OidcClientConfig defaultClientConfig) {
        String defaultClientId = defaultClientConfig.id().get();
        HashMap<String, OidcClient> staticOidcClients = new HashMap<String, OidcClient>();
        for (Map.Entry<String, OidcClientConfig> config : oidcClientsConfig.namedClients().entrySet()) {
            String namedKey = config.getKey();
            if ("<default>".equals(namedKey)) continue;
            OidcClientConfig namedOidcClientConfig = config.getValue();
            OidcCommonUtils.verifyConfigurationId((String)defaultClientId, (String)namedKey, namedOidcClientConfig.id());
            staticOidcClients.put(namedKey, OidcClientRecorder.createOidcClient(namedOidcClientConfig, namedKey, vertx, tlsSupport));
        }
        return Map.copyOf(staticOidcClients);
    }

    public Function<SyntheticCreationalContext<OidcClient>, OidcClient> createOidcClientBean(final String clientName) {
        return new Function<SyntheticCreationalContext<OidcClient>, OidcClient>(){

            @Override
            public OidcClient apply(SyntheticCreationalContext<OidcClient> ctx) {
                return ((OidcClients)ctx.getInjectedReference(OidcClients.class, new Annotation[0])).getClient(clientName);
            }
        };
    }

    protected static OidcClient createOidcClient(OidcClientConfig oidcConfig, String oidcClientId, Vertx vertx, OidcTlsSupport tlsSupport) {
        return (OidcClient)OidcClientRecorder.createOidcClientUni(oidcConfig, oidcClientId, vertx, tlsSupport).await().atMost(oidcConfig.connectionTimeout());
    }

    protected static Uni<OidcClient> createOidcClientUni(final OidcClientConfig oidcConfig, String oidcClientId, final Vertx vertx, OidcTlsSupport tlsSupport) {
        if (!oidcConfig.clientEnabled()) {
            String message = String.format("'%s' client configuration is disabled", oidcClientId);
            LOG.debug((Object)message);
            return Uni.createFrom().item((Object)new DisabledOidcClient(message));
        }
        if (oidcConfig.id().isEmpty()) {
            return Uni.createFrom().failure((Throwable)new IllegalStateException("OIDC Client ID must be set"));
        }
        try {
            if (oidcConfig.authServerUrl().isEmpty() && !OidcCommonUtils.isAbsoluteUrl((Optional)oidcConfig.tokenPath())) {
                throw new ConfigurationException("Either 'quarkus.oidc-client.auth-server-url' or absolute 'quarkus.oidc-client.token-path' URL must be set");
            }
            OidcCommonUtils.verifyEndpointUrl((String)OidcClientRecorder.getEndpointUrl(oidcConfig));
            OidcCommonUtils.verifyCommonConfiguration((OidcClientCommonConfig)oidcConfig, (boolean)false, (boolean)false);
        }
        catch (Throwable t) {
            LOG.debug((Object)t.getMessage());
            String message = String.format("'%s' client configuration is not initialized", oidcClientId);
            return Uni.createFrom().item((Object)new DisabledOidcClient(message));
        }
        WebClientOptions options = new WebClientOptions();
        options.setFollowRedirects(oidcConfig.followRedirects());
        OidcCommonUtils.setHttpClientOptions((OidcCommonConfig)oidcConfig, (HttpClientOptions)options, (OidcTlsSupport.TlsConfigSupport)tlsSupport.forConfig(oidcConfig.tls()));
        io.vertx.mutiny.core.Vertx mutinyVertx = new io.vertx.mutiny.core.Vertx(vertx);
        final WebClient client = WebClient.create((io.vertx.mutiny.core.Vertx)mutinyVertx, (WebClientOptions)options);
        final Map oidcRequestFilters = OidcCommonUtils.getOidcRequestFilters();
        final Map oidcResponseFilters = OidcCommonUtils.getOidcResponseFilters();
        Uni tokenUrisUni = null;
        if (OidcCommonUtils.isAbsoluteUrl((Optional)oidcConfig.tokenPath())) {
            tokenUrisUni = Uni.createFrom().item((Object)new OidcConfigurationMetadata((String)oidcConfig.tokenPath().get(), OidcCommonUtils.isAbsoluteUrl((Optional)oidcConfig.revokePath()) ? (String)oidcConfig.revokePath().get() : null));
        } else {
            String authServerUriString = OidcCommonUtils.getAuthServerUrl((OidcCommonConfig)oidcConfig);
            tokenUrisUni = oidcConfig.discoveryEnabled().orElse(true) == false ? Uni.createFrom().item((Object)new OidcConfigurationMetadata(OidcCommonUtils.getOidcEndpointUrl((String)authServerUriString, (Optional)oidcConfig.tokenPath()), OidcCommonUtils.getOidcEndpointUrl((String)authServerUriString, (Optional)oidcConfig.revokePath()))) : OidcClientRecorder.discoverTokenUris(client, oidcRequestFilters, oidcResponseFilters, authServerUriString.toString(), oidcConfig, mutinyVertx);
        }
        return tokenUrisUni.onItemOrFailure().transform((BiFunction)new BiFunction<OidcConfigurationMetadata, Throwable, OidcClient>(){

            @Override
            public OidcClient apply(OidcConfigurationMetadata metadata, Throwable t) {
                if (t != null) {
                    throw OidcClientRecorder.toOidcClientException(OidcClientRecorder.getEndpointUrl(oidcConfig), t);
                }
                if (metadata.tokenRequestUri == null) {
                    throw new ConfigurationException("OpenId Connect Provider token endpoint URL is not configured and can not be discovered");
                }
                String grantType = oidcConfig.grant().type().getGrantType();
                MultiMap tokenGrantParams = null;
                if (oidcConfig.grant().type() != OidcClientConfig.Grant.Type.REFRESH) {
                    tokenGrantParams = new MultiMap(io.vertx.core.MultiMap.caseInsensitiveMultiMap());
                    OidcClientRecorder.setGrantClientParams(oidcConfig, tokenGrantParams, grantType);
                    if (oidcConfig.grantOptions() != null) {
                        Map<String, String> grantOptions = oidcConfig.grantOptions().get(oidcConfig.grant().type().name().toLowerCase());
                        if (grantOptions != null) {
                            if (oidcConfig.grant().type() == OidcClientConfig.Grant.Type.PASSWORD) {
                                String userName = grantOptions.get("username");
                                String userPassword = grantOptions.get("password");
                                if (userName == null || userPassword == null) {
                                    throw new ConfigurationException("Username and password must be set when a password grant is used", Set.of("quarkus.oidc-client.grant.type", "quarkus.oidc-client.grant-options"));
                                }
                                tokenGrantParams.add("username", userName);
                                tokenGrantParams.add("password", userPassword);
                                for (Map.Entry<String, String> entry : grantOptions.entrySet()) {
                                    if ("username".equals(entry.getKey()) || "password".equals(entry.getKey())) continue;
                                    tokenGrantParams.add(entry.getKey(), entry.getValue());
                                }
                            } else {
                                tokenGrantParams.addAll(grantOptions);
                            }
                        }
                        if (oidcConfig.grant().type() == OidcClientConfig.Grant.Type.EXCHANGE && !tokenGrantParams.contains("subject_token_type")) {
                            tokenGrantParams.add("subject_token_type", "urn:ietf:params:oauth:token-type:access_token");
                        }
                    }
                }
                MultiMap commonRefreshGrantParams = new MultiMap(io.vertx.core.MultiMap.caseInsensitiveMultiMap());
                OidcClientRecorder.setGrantClientParams(oidcConfig, commonRefreshGrantParams, "refresh_token");
                return new OidcClientImpl(client, metadata.tokenRequestUri, metadata.tokenRevokeUri, grantType, tokenGrantParams, commonRefreshGrantParams, oidcConfig, oidcRequestFilters, oidcResponseFilters, vertx);
            }
        });
    }

    private static String getEndpointUrl(OidcClientConfig oidcConfig) {
        return oidcConfig.authServerUrl().isPresent() ? (String)oidcConfig.authServerUrl().get() : (String)oidcConfig.tokenPath().get();
    }

    private static void setGrantClientParams(OidcClientConfig oidcConfig, MultiMap grantParams, String grantType) {
        grantParams.add("grant_type", grantType);
        if (oidcConfig.scopes().isPresent()) {
            grantParams.add("scope", String.join((CharSequence)" ", (Iterable<? extends CharSequence>)oidcConfig.scopes().get()));
        }
        if (oidcConfig.audience().isPresent()) {
            grantParams.add("audience", String.join((CharSequence)" ", (Iterable<? extends CharSequence>)oidcConfig.audience().get()));
        }
    }

    private static Uni<OidcConfigurationMetadata> discoverTokenUris(WebClient client, Map<OidcEndpoint.Type, List<OidcRequestFilter>> oidcRequestFilters, Map<OidcEndpoint.Type, List<OidcResponseFilter>> oidcResponseFilters, String authServerUrl, OidcClientConfig oidcConfig, io.vertx.mutiny.core.Vertx vertx) {
        long connectionDelayInMillisecs = OidcCommonUtils.getConnectionDelayInMillis((OidcCommonConfig)oidcConfig);
        OidcRequestContextProperties contextProps = new OidcRequestContextProperties(Map.of(CLIENT_ID_ATTRIBUTE, oidcConfig.id().orElse(DEFAULT_OIDC_CLIENT_ID)));
        return OidcCommonUtils.discoverMetadata((WebClient)client, oidcRequestFilters, (OidcRequestContextProperties)contextProps, oidcResponseFilters, (String)authServerUrl, (long)connectionDelayInMillisecs, (io.vertx.mutiny.core.Vertx)vertx, (boolean)oidcConfig.useBlockingDnsLookup()).onItem().transform(json -> new OidcConfigurationMetadata(json.getString("token_endpoint"), json.getString("revocation_endpoint")));
    }

    protected static OidcClientException toOidcClientException(String authServerUrlString, Throwable cause) {
        return new OidcClientException(OidcCommonUtils.formatConnectionErrorMessage((String)authServerUrlString), cause);
    }

    public void initOidcClients() {
        try {
            Arc.container().instance(OidcClients.class, new Annotation[0]).get();
        }
        catch (CreationException wrapper) {
            Throwable throwable = wrapper.getCause();
            if (throwable instanceof RuntimeException) {
                RuntimeException runtimeException = (RuntimeException)throwable;
                throw runtimeException;
            }
            throw wrapper;
        }
    }

    private static class DisabledOidcClient
    implements OidcClient {
        String message;

        DisabledOidcClient(String message) {
            this.message = message;
        }

        @Override
        public Uni<Tokens> getTokens(Map<String, String> additionalGrantParameters) {
            return Uni.createFrom().failure((Throwable)new DisabledOidcClientException(this.message));
        }

        @Override
        public Uni<Tokens> refreshTokens(String refreshToken, Map<String, String> additionalGrantParameters) {
            return Uni.createFrom().failure((Throwable)new DisabledOidcClientException(this.message));
        }

        @Override
        public Uni<Boolean> revokeAccessToken(String accessToken, Map<String, String> additionalParameters) {
            return Uni.createFrom().failure((Throwable)new DisabledOidcClientException(this.message));
        }

        @Override
        public void close() throws IOException {
        }
    }

    private static class OidcConfigurationMetadata {
        private final String tokenRequestUri;
        private final String tokenRevokeUri;

        OidcConfigurationMetadata(String tokenRequestUri, String tokenRevokeUri) {
            this.tokenRequestUri = tokenRequestUri;
            this.tokenRevokeUri = tokenRevokeUri;
        }
    }
}

