/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.client.runtime;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;

public record MethodDescription(String className, String methodName, String[] parameterTypes) {
    public static MethodDescription ofMethod(Method method) {
        return new MethodDescription(method.getDeclaringClass().getName(), method.getName(), MethodDescription.typesAsStrings(method.getParameterTypes()));
    }

    private static String[] typesAsStrings(Class<?>[] parameterTypes) {
        String[] result = new String[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            result[i] = parameterTypes[i].getName();
        }
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodDescription that = (MethodDescription)o;
        return Objects.equals(this.className, that.className) && Objects.equals(this.methodName, that.methodName) && Objects.deepEquals(this.parameterTypes, that.parameterTypes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.className, this.methodName, Arrays.hashCode(this.parameterTypes));
    }
}

