/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.client.runtime;

import io.quarkus.oidc.client.OidcClient;
import io.quarkus.oidc.client.OidcClientException;
import io.quarkus.oidc.client.Tokens;
import io.quarkus.oidc.client.runtime.OidcClientConfig;
import io.quarkus.oidc.common.OidcEndpoint;
import io.quarkus.oidc.common.OidcRequestContextProperties;
import io.quarkus.oidc.common.OidcRequestFilter;
import io.quarkus.oidc.common.OidcResponseFilter;
import io.quarkus.oidc.common.runtime.ClientAssertionProvider;
import io.quarkus.oidc.common.runtime.OidcCommonUtils;
import io.quarkus.oidc.common.runtime.config.OidcClientCommonConfig;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.groups.UniOnItem;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.JsonObject;
import io.vertx.mutiny.core.MultiMap;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.ext.web.client.HttpRequest;
import io.vertx.mutiny.ext.web.client.HttpResponse;
import io.vertx.mutiny.ext.web.client.WebClient;
import java.io.IOException;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.Key;
import java.time.Instant;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.eclipse.microprofile.jwt.Claims;
import org.jboss.logging.Logger;

public class OidcClientImpl
implements OidcClient {
    private static final Logger LOG = Logger.getLogger(OidcClientImpl.class);
    private static final String CLIENT_ID_ATTRIBUTE = "client-id";
    private static final String DEFAULT_OIDC_CLIENT_ID = "Default";
    private static final String AUTHORIZATION_HEADER = String.valueOf(HttpHeaders.AUTHORIZATION);
    private final WebClient client;
    private final String tokenRequestUri;
    private final String tokenRevokeUri;
    private final MultiMap tokenGrantParams;
    private final MultiMap commonRefreshGrantParams;
    private final String grantType;
    private final String clientSecretBasicAuthScheme;
    private final Key clientJwtKey;
    private final boolean jwtBearerAuthentication;
    private final OidcClientConfig oidcConfig;
    private final Map<OidcEndpoint.Type, List<OidcRequestFilter>> requestFilters;
    private final Map<OidcEndpoint.Type, List<OidcResponseFilter>> responseFilters;
    private final ClientAssertionProvider clientAssertionProvider;
    private volatile boolean closed;

    OidcClientImpl(WebClient client, String tokenRequestUri, String tokenRevokeUri, String grantType, MultiMap tokenGrantParams, MultiMap commonRefreshGrantParams, OidcClientConfig oidcClientConfig, Map<OidcEndpoint.Type, List<OidcRequestFilter>> requestFilters, Map<OidcEndpoint.Type, List<OidcResponseFilter>> responseFilters, Vertx vertx) {
        this.client = client;
        this.tokenRequestUri = tokenRequestUri;
        this.tokenRevokeUri = tokenRevokeUri;
        this.tokenGrantParams = tokenGrantParams;
        this.commonRefreshGrantParams = commonRefreshGrantParams;
        this.grantType = grantType;
        this.oidcConfig = oidcClientConfig;
        this.requestFilters = requestFilters;
        this.responseFilters = responseFilters;
        this.clientSecretBasicAuthScheme = OidcCommonUtils.initClientSecretBasicAuth((OidcClientCommonConfig)oidcClientConfig);
        this.jwtBearerAuthentication = oidcClientConfig.credentials().jwt().source() == OidcClientCommonConfig.Credentials.Jwt.Source.BEARER;
        Key key = this.clientJwtKey = this.jwtBearerAuthentication ? null : OidcCommonUtils.initClientJwtKey((OidcClientCommonConfig)oidcClientConfig, (boolean)false);
        if (this.jwtBearerAuthentication && oidcClientConfig.credentials().jwt().tokenPath().isPresent()) {
            this.clientAssertionProvider = new ClientAssertionProvider(vertx, (Path)oidcClientConfig.credentials().jwt().tokenPath().get());
            if (this.clientAssertionProvider.getClientAssertion() == null) {
                throw new OidcClientException("Cannot find a valid JWT bearer token at path: " + String.valueOf(oidcClientConfig.credentials().jwt().tokenPath().get()));
            }
        } else {
            this.clientAssertionProvider = null;
        }
    }

    @Override
    public Uni<Tokens> getTokens(Map<String, String> additionalGrantParameters) {
        this.checkClosed();
        if (this.tokenGrantParams == null) {
            throw new OidcClientException("Only 'refresh_token' grant is supported, please call OidcClient#refreshTokens method instead");
        }
        return this.getJsonResponse(OidcEndpoint.Type.TOKEN, this.tokenGrantParams, additionalGrantParameters, false);
    }

    @Override
    public Uni<Tokens> refreshTokens(String refreshToken, Map<String, String> additionalGrantParameters) {
        this.checkClosed();
        if (refreshToken == null) {
            throw new OidcClientException("Refresh token is null");
        }
        MultiMap refreshGrantParams = OidcClientImpl.copyMultiMap(this.commonRefreshGrantParams);
        refreshGrantParams.add("refresh_token", refreshToken);
        return this.getJsonResponse(OidcEndpoint.Type.TOKEN, refreshGrantParams, additionalGrantParameters, true);
    }

    @Override
    public Uni<Boolean> revokeAccessToken(String accessToken, Map<String, String> additionalParameters) {
        this.checkClosed();
        if (accessToken == null) {
            throw new OidcClientException("Access token is null");
        }
        OidcRequestContextProperties requestProps = this.getRequestProps(null);
        if (this.tokenRevokeUri != null) {
            MultiMap tokenRevokeParams = new MultiMap(io.vertx.core.MultiMap.caseInsensitiveMultiMap());
            tokenRevokeParams.set("token", accessToken);
            return this.postRequest(requestProps, OidcEndpoint.Type.TOKEN_REVOCATION, (HttpRequest<Buffer>)this.client.postAbs(this.tokenRevokeUri), tokenRevokeParams, additionalParameters, false).transform(resp -> this.toRevokeResponse(requestProps, (HttpResponse<Buffer>)resp));
        }
        LOG.debugf("%s OidcClient can not revoke the access token because the revocation endpoint URL is not set", new Object[0]);
        return Uni.createFrom().item((Object)false);
    }

    private OidcRequestContextProperties getRequestProps(String grantType) {
        if (this.requestFilters.isEmpty() && this.responseFilters.isEmpty()) {
            return null;
        }
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(CLIENT_ID_ATTRIBUTE, this.oidcConfig.id().orElse(DEFAULT_OIDC_CLIENT_ID));
        if (grantType != null) {
            props.put("grant_type", grantType);
        }
        return new OidcRequestContextProperties(props);
    }

    private Boolean toRevokeResponse(OidcRequestContextProperties requestProps, HttpResponse<Buffer> resp) {
        OidcCommonUtils.filterHttpResponse((OidcRequestContextProperties)requestProps, resp, this.responseFilters, (OidcEndpoint.Type)OidcEndpoint.Type.TOKEN_REVOCATION);
        return resp.statusCode() != 503;
    }

    private Uni<Tokens> getJsonResponse(final OidcEndpoint.Type endpointType, final MultiMap formBody, final Map<String, String> additionalGrantParameters, final boolean refresh) {
        String currentGrantType = refresh ? "refresh_token" : this.grantType;
        final OidcRequestContextProperties requestProps = this.getRequestProps(currentGrantType);
        return Uni.createFrom().deferred((Supplier)new Supplier<Uni<? extends Tokens>>(){

            @Override
            public Uni<Tokens> get() {
                return OidcClientImpl.this.postRequest(requestProps, endpointType, (HttpRequest<Buffer>)OidcClientImpl.this.client.postAbs(OidcClientImpl.this.tokenRequestUri), formBody, additionalGrantParameters, refresh).transform(resp -> OidcClientImpl.this.emitGrantTokens(requestProps, (HttpResponse<Buffer>)resp, refresh));
            }
        });
    }

    private UniOnItem<HttpResponse<Buffer>> postRequest(OidcRequestContextProperties requestProps, OidcEndpoint.Type endpointType, HttpRequest<Buffer> request, MultiMap formBody, Map<String, String> additionalGrantParameters, boolean refresh) {
        MultiMap body = formBody;
        request.putHeader(HttpHeaders.CONTENT_TYPE.toString(), HttpHeaders.APPLICATION_X_WWW_FORM_URLENCODED.toString());
        if (this.oidcConfig.headers() != null) {
            for (Map.Entry<String, String> entry : this.oidcConfig.headers().entrySet()) {
                request.putHeader(entry.getKey(), entry.getValue());
            }
        }
        if (this.clientSecretBasicAuthScheme != null) {
            request.putHeader(AUTHORIZATION_HEADER, this.clientSecretBasicAuthScheme);
        } else if (this.jwtBearerAuthentication) {
            String clientAssertion = additionalGrantParameters.get("client_assertion");
            if (clientAssertion == null && this.clientAssertionProvider != null && (clientAssertion = this.clientAssertionProvider.getClientAssertion()) != null) {
                body.set("client_assertion", clientAssertion);
            }
            if (clientAssertion == null) {
                String string = String.format("%s OidcClient can not complete the %s grant request because a JWT bearer client_assertion is missing", this.oidcConfig.id().get(), refresh ? "refresh_token" : this.grantType);
                LOG.error((Object)string);
                throw new OidcClientException(string);
            }
            body.set("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer");
        } else if (this.clientJwtKey != null) {
            body = !refresh ? OidcClientImpl.copyMultiMap(body) : body;
            String jwt = OidcCommonUtils.signJwtWithKey((OidcClientCommonConfig)this.oidcConfig, (String)this.tokenRequestUri, (Key)this.clientJwtKey);
            if (OidcCommonUtils.isClientSecretPostJwtAuthRequired((OidcClientCommonConfig.Credentials)this.oidcConfig.credentials())) {
                body.add("client_id", (String)this.oidcConfig.clientId().get());
                body.add("client_secret", jwt);
            } else if (OidcCommonUtils.isJwtAssertion((OidcClientCommonConfig.Credentials)this.oidcConfig.credentials())) {
                if (!"urn:ietf:params:oauth:grant-type:jwt-bearer".equals(body.get("grant_type"))) {
                    String string = String.format("%s OidcClient wants to use JWT bearer grant assertion but has a wrong grant type %s configured. You must set 'quarkus.oidc-client.grant.type' property to 'jwt'.", this.oidcConfig.id().get(), body.get("grant_type"));
                    LOG.error((Object)string);
                    throw new OidcClientException(string);
                }
                body.add("assertion", jwt);
            } else {
                body.add("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer");
                body.add("client_assertion", jwt);
            }
        } else if (OidcCommonUtils.isClientSecretPostAuthRequired((OidcClientCommonConfig.Credentials)this.oidcConfig.credentials())) {
            body = !refresh ? OidcClientImpl.copyMultiMap(body) : body;
            body.set("client_id", (String)this.oidcConfig.clientId().get());
            body.set("client_secret", OidcCommonUtils.clientSecret((OidcClientCommonConfig.Credentials)this.oidcConfig.credentials()));
        } else {
            body = !refresh ? OidcClientImpl.copyMultiMap(body) : body;
            body = OidcClientImpl.copyMultiMap(body).set("client_id", (String)this.oidcConfig.clientId().get());
        }
        if (!additionalGrantParameters.isEmpty()) {
            body = OidcClientImpl.copyMultiMap(body);
            for (Map.Entry entry : additionalGrantParameters.entrySet()) {
                body.add((String)entry.getKey(), (String)entry.getValue());
            }
        }
        Buffer buffer = OidcCommonUtils.encodeForm((MultiMap)body);
        Uni uni = this.filterHttpRequest(requestProps, endpointType, request, buffer).sendBuffer(OidcCommonUtils.getRequestBuffer((OidcRequestContextProperties)requestProps, (Buffer)buffer)).onFailure(SocketException.class).retry().atMost((long)this.oidcConfig.connectionRetryCount()).onFailure().transform(t -> {
            LOG.warn((Object)"OIDC Server is not available:", t.getCause() != null ? t.getCause() : t);
            return new OidcClientException("OIDC Server is not available");
        });
        return uni.onItem();
    }

    private Tokens emitGrantTokens(OidcRequestContextProperties requestProps, HttpResponse<Buffer> resp, boolean refresh) {
        Buffer buffer = OidcCommonUtils.filterHttpResponse((OidcRequestContextProperties)requestProps, resp, this.responseFilters, (OidcEndpoint.Type)OidcEndpoint.Type.TOKEN);
        if (resp.statusCode() == 200) {
            LOG.debugf("%s OidcClient has %s the tokens", (Object)this.oidcConfig.id().get(), (Object)(refresh ? "refreshed" : "acquired"));
            JsonObject json = buffer.toJsonObject();
            String accessToken = json.getString(this.oidcConfig.grant().accessTokenProperty());
            Long accessTokenExpiresAt = this.getAccessTokenExpiresAtValue(accessToken, json.getValue(this.oidcConfig.grant().expiresInProperty()));
            String refreshToken = json.getString(this.oidcConfig.grant().refreshTokenProperty());
            Long refreshTokenExpiresAt = this.getExpiresAtValue(refreshToken, json.getValue(this.oidcConfig.grant().refreshExpiresInProperty()));
            return new Tokens(accessToken, accessTokenExpiresAt, this.oidcConfig.refreshTokenTimeSkew().orElse(null), refreshToken, refreshTokenExpiresAt, json, this.oidcConfig.clientId().orElse(DEFAULT_OIDC_CLIENT_ID));
        }
        String errorMessage = buffer.toString();
        LOG.debugf("%s OidcClient has failed to complete the %s grant request:  status: %d, error message: %s", new Object[]{this.oidcConfig.id().get(), refresh ? "refresh_token" : this.grantType, resp.statusCode(), errorMessage});
        throw new OidcClientException(errorMessage);
    }

    private Long getAccessTokenExpiresAtValue(String token, Object expiresInValue) {
        Long expiresAt = this.getExpiresAtValue(token, expiresInValue);
        if (expiresAt == null && this.oidcConfig.accessTokenExpiresIn().isPresent()) {
            long now = System.currentTimeMillis() / 1000L;
            expiresAt = now + this.oidcConfig.accessTokenExpiresIn().get().toSeconds();
        }
        if (expiresAt != null && this.oidcConfig.accessTokenExpirySkew().isPresent()) {
            expiresAt = expiresAt + this.oidcConfig.accessTokenExpirySkew().get().getSeconds();
        }
        return expiresAt;
    }

    private Long getExpiresAtValue(String token, Object expiresInValue) {
        if (expiresInValue != null) {
            long tokenExpiresIn = expiresInValue instanceof Number ? ((Number)expiresInValue).longValue() : Long.parseLong(expiresInValue.toString());
            return this.oidcConfig.absoluteExpiresIn() ? tokenExpiresIn : Instant.now().getEpochSecond() + tokenExpiresIn;
        }
        return token != null ? OidcClientImpl.getExpiresJwtClaim(token) : null;
    }

    private static Long getExpiresJwtClaim(String token) {
        JsonObject claims = OidcClientImpl.decodeJwtToken(token);
        if (claims != null) {
            try {
                return claims.getLong(Claims.exp.name());
            }
            catch (IllegalArgumentException ex) {
                LOG.debug((Object)"JWT expiry claim can not be converted to Long");
            }
        }
        return null;
    }

    private static JsonObject decodeJwtToken(String accessToken) {
        block4: {
            String[] parts = accessToken.split("\\.");
            if (parts.length == 3) {
                try {
                    return new JsonObject(new String(Base64.getUrlDecoder().decode(parts[1]), StandardCharsets.UTF_8));
                }
                catch (IllegalArgumentException ex) {
                    LOG.debug((Object)"JWT token can not be decoded using the Base64Url encoding scheme");
                    break block4;
                }
                catch (DecodeException ex) {
                    LOG.debug((Object)"JWT token can not be decoded");
                    break block4;
                }
            }
            LOG.debug((Object)"Access token is not formatted as the encoded JWT token");
        }
        return null;
    }

    private static MultiMap copyMultiMap(MultiMap oldMap) {
        MultiMap newMap = new MultiMap(io.vertx.core.MultiMap.caseInsensitiveMultiMap());
        newMap.addAll(oldMap);
        return newMap;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.client.close();
            if (this.clientAssertionProvider != null) {
                this.clientAssertionProvider.close();
            }
            this.closed = true;
        }
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("OidcClient " + this.oidcConfig.id().get() + " is closed");
        }
    }

    private HttpRequest<Buffer> filterHttpRequest(OidcRequestContextProperties requestProps, OidcEndpoint.Type endpointType, HttpRequest<Buffer> request, Buffer body) {
        if (!this.requestFilters.isEmpty()) {
            OidcRequestFilter.OidcRequestContext context = new OidcRequestFilter.OidcRequestContext(request, body, requestProps);
            for (OidcRequestFilter filter : OidcCommonUtils.getMatchingOidcRequestFilters(this.requestFilters, (OidcEndpoint.Type)endpointType)) {
                filter.filter(context);
            }
        }
        return request;
    }

    OidcClientConfig getConfig() {
        return this.oidcConfig;
    }
}

