/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.client.runtime;

import io.quarkus.runtime.configuration.ConfigBuilder;
import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigSourceInterceptorFactory;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.SmallRyeConfigBuilder;
import java.util.Iterator;
import java.util.OptionalInt;

public class OidcClientDefaultIdConfigBuilder
implements ConfigBuilder {
    private static final String OIDC_CLIENT_PREFIX = "quarkus.oidc-client.";
    private static final String ID_POSTFIX = ".id";
    private static final String DEFAULT_CLIENT_ID_PROPERTY_KEY = "quarkus.oidc-client.id";
    private static final String DOUBLE_QUOTE = "\"";
    private static final String WITH_DEFAULTS_ID_KEY = "quarkus.oidc-client.*.id";

    public SmallRyeConfigBuilder configBuilder(SmallRyeConfigBuilder builder) {
        final ConfigSourceInterceptor configSourceInterceptor = OidcClientDefaultIdConfigBuilder.createConfigSourceInterceptor();
        builder.withInterceptorFactories(new ConfigSourceInterceptorFactory[]{new ConfigSourceInterceptorFactory(){

            public ConfigSourceInterceptor getInterceptor(ConfigSourceInterceptorContext configSourceInterceptorContext) {
                return configSourceInterceptor;
            }

            public OptionalInt getPriority() {
                return OptionalInt.of(3200);
            }
        }});
        return builder;
    }

    public int priority() {
        return Integer.MIN_VALUE;
    }

    private static boolean isNotSet(ConfigValue configValue) {
        return configValue == null || configValue.getValue() == null || configValue.getValue().isEmpty();
    }

    private static ConfigValue createConfigValue(String name, String value) {
        return ConfigValue.builder().withName(name).withValue(value).build();
    }

    private static ConfigSourceInterceptor createConfigSourceInterceptor() {
        return new ConfigSourceInterceptor(){

            public ConfigValue getValue(ConfigSourceInterceptorContext context, String name) {
                ConfigValue configValue = context.proceed(name);
                if (OidcClientDefaultIdConfigBuilder.isNotSet(configValue) && name.startsWith(OidcClientDefaultIdConfigBuilder.OIDC_CLIENT_PREFIX) && name.endsWith(OidcClientDefaultIdConfigBuilder.ID_POSTFIX) && !OidcClientDefaultIdConfigBuilder.WITH_DEFAULTS_ID_KEY.equals(name)) {
                    if (name.equals(OidcClientDefaultIdConfigBuilder.DEFAULT_CLIENT_ID_PROPERTY_KEY)) {
                        return OidcClientDefaultIdConfigBuilder.createConfigValue(name, "Default");
                    }
                    String maybeClientName = name.substring(OidcClientDefaultIdConfigBuilder.OIDC_CLIENT_PREFIX.length(), name.length() - OidcClientDefaultIdConfigBuilder.ID_POSTFIX.length());
                    if (!maybeClientName.contains(".")) {
                        if (maybeClientName.startsWith(OidcClientDefaultIdConfigBuilder.DOUBLE_QUOTE) && maybeClientName.endsWith(OidcClientDefaultIdConfigBuilder.DOUBLE_QUOTE)) {
                            String clientNameWithoutQuotes = maybeClientName.substring(1, maybeClientName.length() - 1);
                            return OidcClientDefaultIdConfigBuilder.createConfigValue(name, clientNameWithoutQuotes);
                        }
                        return OidcClientDefaultIdConfigBuilder.createConfigValue(name, maybeClientName);
                    }
                }
                return configValue;
            }

            public Iterator<String> iterateNames(ConfigSourceInterceptorContext context) {
                return context.iterateNames();
            }
        };
    }
}

