/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.client.deployment;

import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmoAdaptor;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.oidc.client.filter.OidcClientFilter;
import io.quarkus.oidc.client.runtime.AbstractTokensProducer;
import io.quarkus.oidc.client.runtime.MethodDescription;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class OidcClientFilterDeploymentHelper<T extends AbstractTokensProducer> {
    public static final String DEFAULT_OIDC_REQUEST_FILTER_NAME = "default-oidc-request-filter";
    private final Map<TokensProducerKey, String> clientNameToGeneratedClass = new HashMap<TokensProducerKey, String>();
    private final Map<String, Boolean> restClientToIsMethodAnnotated = new HashMap<String, Boolean>();
    private final Class<T> baseClass;
    private final ClassOutput classOutput;
    private final String targetPackage;
    private final boolean refreshOnUnauthorized;

    public OidcClientFilterDeploymentHelper(Class<T> baseClass, BuildProducer<GeneratedBeanBuildItem> generatedBean, boolean refreshOnUnauthorized) {
        this.baseClass = baseClass;
        this.classOutput = new GeneratedBeanGizmoAdaptor(generatedBean);
        this.targetPackage = DotNames.internalPackageNameWithTrailingSlash((DotName)DotName.createSimple((String)baseClass.getName()));
        this.refreshOnUnauthorized = refreshOnUnauthorized;
    }

    public String getOrCreateNamedTokensProducerFor(final String oidcClientName, AnnotationInstance annotationInstance) {
        Objects.requireNonNull(oidcClientName);
        Objects.requireNonNull(annotationInstance);
        final MethodInfo targetMethod = annotationInstance.target().kind() == AnnotationTarget.Kind.METHOD ? annotationInstance.target().asMethod() : null;
        String generatedProducerName = this.clientNameToGeneratedClass.computeIfAbsent(new TokensProducerKey(oidcClientName, targetMethod), new Function<TokensProducerKey, String>(){

            @Override
            public String apply(TokensProducerKey key) {
                String generatedName;
                block28: {
                    generatedName = OidcClientFilterDeploymentHelper.this.targetPackage + OidcClientFilterDeploymentHelper.this.baseClass.getSimpleName() + "_" + OidcClientFilterDeploymentHelper.sanitize(oidcClientName) + OidcClientFilterDeploymentHelper.possiblyTargetMethodSuffix(targetMethod);
                    try (ClassCreator creator = ClassCreator.builder().classOutput(OidcClientFilterDeploymentHelper.this.classOutput).className(generatedName).superClass(OidcClientFilterDeploymentHelper.this.baseClass).build();){
                        MethodCreator methodCreator;
                        creator.addAnnotation(DotNames.SINGLETON.toString());
                        creator.addAnnotation(DotNames.UNREMOVABLE.toString());
                        if (!OidcClientFilterDeploymentHelper.DEFAULT_OIDC_REQUEST_FILTER_NAME.equals(oidcClientName)) {
                            try (MethodCreator clientIdMethod = creator.getMethodCreator("clientId", Optional.class, new Class[0]);){
                                clientIdMethod.setModifiers(4);
                                clientIdMethod.returnValue(clientIdMethod.invokeStaticMethod(MethodDescriptor.ofMethod(Optional.class, (String)"of", Optional.class, (Class[])new Class[]{Object.class}), new ResultHandle[]{clientIdMethod.load(oidcClientName)}));
                            }
                        }
                        if (OidcClientFilterDeploymentHelper.this.refreshOnUnauthorized) {
                            methodCreator = creator.getMethodCreator("refreshOnUnauthorized", Boolean.TYPE, new Class[0]);
                            try {
                                methodCreator.setModifiers(4);
                                methodCreator.returnBoolean(true);
                            }
                            finally {
                                if (methodCreator != null) {
                                    methodCreator.close();
                                }
                            }
                        }
                        if (targetMethod == null) break block28;
                        methodCreator = creator.getMethodCreator("getMethodDescription", MethodDescription.class, new Class[0]);
                        try {
                            methodCreator.addAnnotation(Override.class.getName(), RetentionPolicy.CLASS);
                            methodCreator.setModifiers(4);
                            ResultHandle methodName = methodCreator.load(targetMethod.name());
                            ResultHandle declaringClassName = methodCreator.load(targetMethod.declaringClass().name().toString());
                            ResultHandle paramTypes = methodCreator.marshalAsArray(String[].class, (ResultHandle[])targetMethod.parameterTypes().stream().map(pt -> pt.name().toString()).map(arg_0 -> ((MethodCreator)methodCreator).load(arg_0)).toArray(ResultHandle[]::new));
                            MethodDescriptor methodDescriptionCtor = MethodDescriptor.ofConstructor(MethodDescription.class, (Class[])new Class[]{String.class, String.class, String[].class});
                            ResultHandle newMethodDescription = methodCreator.newInstance(methodDescriptionCtor, new ResultHandle[]{declaringClassName, methodName, paramTypes});
                            methodCreator.returnValue(newMethodDescription);
                        }
                        finally {
                            if (methodCreator != null) {
                                methodCreator.close();
                            }
                        }
                    }
                }
                return generatedName.replace('/', '.');
            }
        });
        String targetRestClientName = OidcClientFilterDeploymentHelper.getTargetRestClientName(annotationInstance);
        if (this.restClientToIsMethodAnnotated.containsKey(targetRestClientName)) {
            Boolean wasMethodAnnotated = this.restClientToIsMethodAnnotated.get(targetRestClientName);
            if (targetMethod != null) {
                boolean wasClassAnnotated;
                boolean bl = wasClassAnnotated = wasMethodAnnotated == false;
                if (wasClassAnnotated) {
                    OidcClientFilterDeploymentHelper.throwBothMethodAndClassAnnotated(annotationInstance);
                }
            } else if (wasMethodAnnotated.booleanValue()) {
                OidcClientFilterDeploymentHelper.throwBothMethodAndClassAnnotated(annotationInstance);
            }
        } else if (targetMethod != null) {
            this.restClientToIsMethodAnnotated.put(targetRestClientName, true);
        } else {
            this.restClientToIsMethodAnnotated.put(targetRestClientName, false);
        }
        return generatedProducerName;
    }

    private static String possiblyTargetMethodSuffix(MethodInfo method) {
        if (method != null) {
            return "_" + OidcClientFilterDeploymentHelper.sanitize(method.name());
        }
        return "";
    }

    public DotName getOrCreateFilter(String oidcClientName, AnnotationInstance instance) {
        return DotName.createSimple((String)this.getOrCreateNamedTokensProducerFor(oidcClientName, instance));
    }

    public static String getClientName(AnnotationInstance annotationInstance) {
        AnnotationValue annotationValue = annotationInstance.value();
        if (annotationValue != null && !annotationValue.asString().isEmpty()) {
            return annotationValue.asString();
        }
        return null;
    }

    public static ClassInfo getTargetRestClient(AnnotationInstance instance) {
        if (instance.target().kind() == AnnotationTarget.Kind.METHOD) {
            return instance.target().asMethod().declaringClass();
        }
        return instance.target().asClass();
    }

    public static String getTargetRestClientName(AnnotationInstance instance) {
        return OidcClientFilterDeploymentHelper.getTargetRestClient(instance).name().toString();
    }

    public static String sanitize(String oidcClientName) {
        return oidcClientName.replaceAll("\\W+", "");
    }

    public static List<ClassInfo> detectCustomFiltersThatRequireResponseFilter(Class<?> abstractFilterClass, Class<?> registerProviderClass, IndexView index) {
        ArrayList<ClassInfo> result = new ArrayList<ClassInfo>();
        for (ClassInfo subClass : index.getKnownDirectSubclasses(abstractFilterClass)) {
            DotName declaringClassName;
            boolean declaredOnThisClass;
            MethodInfo refreshOnUnauthorizedMethod;
            if (subClass.isInterface() || subClass.isAbstract() || (refreshOnUnauthorizedMethod = subClass.method("refreshOnUnauthorized", new Type[0])) == null || !(declaredOnThisClass = (declaringClassName = refreshOnUnauthorizedMethod.declaringClass().name()).equals((Object)subClass.name()))) continue;
            result.addAll(index.getAnnotations(registerProviderClass).stream().filter(ai -> ai.value() != null).filter(ai -> ai.value().asClass().name().equals((Object)declaringClassName)).filter(ai -> ai.target().kind() == AnnotationTarget.Kind.CLASS).map(ai -> ai.target().asClass()).toList());
        }
        return result;
    }

    private static void throwBothMethodAndClassAnnotated(AnnotationInstance instance) {
        throw new RuntimeException(OidcClientFilter.class.getName() + " annotation can be applied either on class " + String.valueOf(OidcClientFilterDeploymentHelper.getTargetRestClient(instance)) + " or its methods");
    }

    private record TokensProducerKey(String clientName, MethodInfo methodInfo) {
    }
}

