/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.observability.testcontainers;

import io.quarkus.bootstrap.classloading.ClassPathElement;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.yaml.snakeyaml.Yaml;

public class GrafanaUtils {
    static final String META_INF_GRAFANA = "META-INF/grafana";

    static String consumeGrafanaResources(String config, Consumer<String> consumer) {
        return GrafanaUtils.consumeGrafanaResources(config, consumer, GrafanaUtils.findGrafanaDashboards());
    }

    static String consumeGrafanaResources(String config, Consumer<String> consumer, Set<String> dashboards) {
        Yaml yaml = new Yaml();
        Map data = (Map)yaml.load(config);
        List providers = (List)data.get("providers");
        dashboards.forEach(s -> {
            String sub = s.substring("grafana-dashboard-".length(), s.length() - ".json".length());
            LinkedHashMap<String, Object> provider = new LinkedHashMap<String, Object>();
            String name = GrafanaUtils.toName(sub);
            provider.put("name", name);
            provider.put("type", "file");
            LinkedHashMap<String, Object> options = new LinkedHashMap<String, Object>();
            options.put("path", "/otel-lgtm/" + s);
            options.put("foldersFromFilesStructure", false);
            provider.put("options", options);
            providers.add(provider);
            consumer.accept((String)s);
        });
        StringWriter writer = new StringWriter();
        yaml.dump((Object)data, (Writer)writer);
        return writer.toString();
    }

    private static String toName(String path) {
        if (path.isEmpty()) {
            throw new IllegalArgumentException("Illegal path: " + path);
        }
        StringBuilder name = new StringBuilder();
        boolean dash = true;
        for (int i = 0; i < path.length(); ++i) {
            int ch = path.charAt(i);
            if (dash) {
                ch = Character.toUpperCase((char)ch);
                dash = false;
            } else if (ch == 45) {
                dash = true;
                ch = 32;
            }
            name.append((char)ch);
        }
        return name.toString();
    }

    private static Set<String> findGrafanaDashboards() {
        HashSet<String> dashboards = new HashSet<String>();
        List elements = QuarkusClassLoader.getElements((String)META_INF_GRAFANA, (boolean)false);
        if (!elements.isEmpty()) {
            for (ClassPathElement element : elements) {
                if (!element.isRuntime()) continue;
                element.apply(tree -> {
                    tree.walkIfContains(META_INF_GRAFANA, visit -> {
                        String rel;
                        Path visitPath = visit.getPath();
                        if (!Files.isDirectory(visitPath, new LinkOption[0]) && (rel = visit.getRelativePath()).startsWith("META-INF/grafana/grafana-dashboard-") && rel.endsWith(".json")) {
                            String subPath = rel.substring(META_INF_GRAFANA.length() + 1);
                            dashboards.add(subPath);
                        }
                    });
                    return null;
                });
            }
        }
        return dashboards;
    }
}

