/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.observability.testcontainers;

import io.quarkus.observability.common.config.AbstractGrafanaConfig;
import io.quarkus.observability.common.config.LgtmComponent;
import io.quarkus.observability.common.config.LgtmConfig;
import io.quarkus.observability.testcontainers.GrafanaContainer;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.utilities.OS;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.testcontainers.containers.output.OutputFrame;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitAllStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.MountableFile;

public class LgtmContainer
extends GrafanaContainer<LgtmContainer, LgtmConfig> {
    protected static final String LGTM_NETWORK_ALIAS = "ltgm.testcontainer.docker";
    protected static final String PROMETHEUS_CONFIG_DEFAULT = "---\notlp:\n  # Recommended attributes to be promoted to labels.\n  promote_resource_attributes:\n    - service.instance.id\n    - service.name\n    - service.namespace\n    - service.version\n    - cloud.availability_zone\n    - cloud.region\n    - container.name\n    - deployment.environment.name\n    - k8s.cluster.name\n    - k8s.container.name\n    - k8s.cronjob.name\n    - k8s.daemonset.name\n    - k8s.deployment.name\n    - k8s.job.name\n    - k8s.namespace.name\n    - k8s.pod.name\n    - k8s.replicaset.name\n    - k8s.statefulset.name\nstorage:\n  tsdb:\n    # A 10min time window is enough because it can easily absorb retries and network delays.\n    out_of_order_time_window: 10m\nglobal:\n  scrape_interval: %s\n  evaluation_interval: 5s\n";
    protected static final String PROMETHEUS_CONFIG_SCRAPE = "scrape_configs:\n  - job_name: '%s'\n    metrics_path: '%s%s'\n    scrape_interval: %s\n    static_configs:\n      - targets: ['%s:%d']\n";
    protected static final String DASHBOARDS_CONFIG = "apiVersion: 1\n\nproviders:\n  - name: \"Quarkus Micrometer Prometheus registry\"\n    type: file\n    options:\n      path: /otel-lgtm/grafana-dashboard-quarkus-micrometer-prometheus.json\n      foldersFromFilesStructure: false\n  - name: \"Quarkus Micrometer OTLP registry\"\n    type: file\n    options:\n      path: /otel-lgtm/grafana-dashboard-quarkus-micrometer-otlp.json\n      foldersFromFilesStructure: false\n  - name: \"Quarkus Micrometer OpenTelemetry\"\n    type: file\n    options:\n      path: /otel-lgtm/grafana-dashboard-quarkus-micrometer-opentelemetry.json\n      foldersFromFilesStructure: false\n  - name: \"Quarkus OpenTelemetry logging\"\n    type: file\n    options:\n      path: /otel-lgtm/grafana-dashboard-opentelemetry-logging.json\n      foldersFromFilesStructure: false\n";
    private final boolean scrapingRequired;

    public LgtmContainer(boolean scrapingRequired) {
        this(new LgtmConfigImpl(), scrapingRequired);
    }

    public LgtmContainer(LgtmConfig config, boolean scrapingRequired) {
        super(config);
        this.scrapingRequired = scrapingRequired;
        this.addExposedPorts(new int[]{4317, 4318});
        Optional logging = config.logging();
        logging.ifPresent(set -> set.forEach(l -> this.withEnv("ENABLE_LOGS_" + l.name(), "true")));
        this.addFileToContainer(DASHBOARDS_CONFIG.getBytes(), "/otel-lgtm/grafana/conf/provisioning/dashboards/grafana-dashboards.yaml");
        this.withCopyFileToContainer(MountableFile.forClasspathResource((String)"/grafana-dashboard-quarkus-micrometer-prometheus.json"), "/otel-lgtm/grafana-dashboard-quarkus-micrometer-prometheus.json");
        this.withCopyFileToContainer(MountableFile.forClasspathResource((String)"/grafana-dashboard-quarkus-micrometer-otlp.json"), "/otel-lgtm/grafana-dashboard-quarkus-micrometer-otlp.json");
        this.withCopyFileToContainer(MountableFile.forClasspathResource((String)"/grafana-dashboard-quarkus-micrometer-opentelemetry.json"), "/otel-lgtm/grafana-dashboard-quarkus-micrometer-opentelemetry.json");
        this.withCopyFileToContainer(MountableFile.forClasspathResource((String)"/grafana-dashboard-opentelemetry-logging.json"), "/otel-lgtm/grafana-dashboard-opentelemetry-logging.json");
        this.addFileToContainer(this.getPrometheusConfig().getBytes(), "/otel-lgtm/prometheus.yaml");
    }

    @Override
    protected WaitStrategy waitStrategy() {
        return new WaitAllStrategy().withStartupTimeout(((LgtmConfig)this.config).timeout()).withStrategy(super.waitStrategy()).withStrategy(Wait.forLogMessage((String)".*(The OpenTelemetry collector and the Grafana LGTM stack are up and running|All components are up and running).*", (int)1).withStartupTimeout(((LgtmConfig)this.config).timeout()));
    }

    @Override
    protected String prefix() {
        return "LGTM";
    }

    @Override
    protected Predicate<OutputFrame> getLoggingFilter() {
        return new LgtmLoggingFilter();
    }

    public String getOtlpProtocol() {
        return ((LgtmConfig)this.config).otlpProtocol();
    }

    private int getPrivateOtlpPort() {
        return LgtmContainer.getPrivateOtlpPort(this.getOtlpProtocol());
    }

    public static int getPrivateOtlpPort(String otlpProtocol) {
        if ("grpc".equalsIgnoreCase(otlpProtocol)) {
            return 4317;
        }
        if ("http/protobuf".equals(otlpProtocol)) {
            return 4318;
        }
        throw new IllegalArgumentException("Unsupported OTEL protocol: " + otlpProtocol);
    }

    private String getPrometheusConfig() {
        String scraping = ((LgtmConfig)this.config).scrapingInterval() + "s";
        Object prometheusConfig = String.format(PROMETHEUS_CONFIG_DEFAULT, scraping);
        if (((LgtmConfig)this.config).forceScraping().orElse(this.scrapingRequired).booleanValue()) {
            boolean isTest = LaunchMode.current() == LaunchMode.TEST;
            Config runtimeConfig = ConfigProvider.getConfig();
            String rootPath = runtimeConfig.getOptionalValue("quarkus.management.root-path", String.class).orElse("/q");
            String metricsPath = runtimeConfig.getOptionalValue("quarkus.management.metrics.path", String.class).orElse("/metrics");
            String httpPortKey = isTest ? "quarkus.http.test-port" : "quarkus.http.port";
            Optional optionalValue = runtimeConfig.getOptionalValue(httpPortKey, Integer.class);
            int httpPort = optionalValue.orElse(isTest ? 8081 : 8080);
            if (OS.determineOS() == OS.LINUX) {
                this.withCreateContainerCmdModifier(cmd -> cmd.getHostConfig().withExtraHosts(new String[]{"host.docker.internal:host-gateway"}));
            }
            prometheusConfig = (String)prometheusConfig + String.format(PROMETHEUS_CONFIG_SCRAPE, ((LgtmConfig)this.config).serviceName(), rootPath, metricsPath, scraping, "host.docker.internal", httpPort);
        }
        return prometheusConfig;
    }

    protected static class LgtmConfigImpl
    extends AbstractGrafanaConfig
    implements LgtmConfig {
        public LgtmConfigImpl() {
            this("docker.io/grafana/otel-lgtm:0.9.0");
        }

        public LgtmConfigImpl(String imageName) {
            super(imageName);
        }

        public Optional<Set<String>> networkAliases() {
            return Optional.of(Set.of("lgtm", LgtmContainer.LGTM_NETWORK_ALIAS));
        }

        public Optional<Set<LgtmComponent>> logging() {
            return Optional.empty();
        }

        public String otlpProtocol() {
            return "http/protobuf";
        }

        public int scrapingInterval() {
            return 10;
        }

        public Optional<Boolean> forceScraping() {
            return Optional.empty();
        }

        public String otelMetricExportInterval() {
            return "10s";
        }

        public String otelBspScheduleDelay() {
            return "3s";
        }

        public String otelBlrpScheduleDelay() {
            return "1s";
        }
    }

    protected static class LgtmLoggingFilter
    implements Predicate<OutputFrame> {
        protected LgtmLoggingFilter() {
        }

        @Override
        public boolean test(OutputFrame outputFrame) {
            String line = outputFrame.getUtf8StringWithoutLineEnding();
            return !line.startsWith("Waiting for") || !line.endsWith("to start up...");
        }
    }
}

