/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.observability.devresource.lgtm;

import io.quarkus.observability.common.config.LgtmConfig;
import io.quarkus.observability.common.config.ModulesConfiguration;
import io.quarkus.observability.devresource.Container;
import io.quarkus.observability.devresource.ExtensionsCatalog;
import io.quarkus.observability.devresource.testcontainers.ContainerResource;
import io.quarkus.observability.testcontainers.LgtmContainer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.jboss.logging.Logger;
import org.testcontainers.containers.GenericContainer;

public class LgtmResource
extends ContainerResource<LgtmContainer, LgtmConfig> {
    private static final Logger log = Logger.getLogger((String)LgtmResource.class.getName());
    protected static final Set<String> SCRAPING_REGISTRIES = Set.of("io.micrometer.prometheus.PrometheusMeterRegistry");
    protected static final Function<String, Boolean> TCCL_FN = s -> {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            cl.loadClass((String)s);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    };
    private ExtensionsCatalog catalog;
    private LgtmConfig config;

    public LgtmConfig config(ModulesConfiguration configuration) {
        LgtmConfig config;
        this.config = config = configuration.lgtm();
        return config;
    }

    public LgtmConfig config(ModulesConfiguration configuration, ExtensionsCatalog catalog) {
        this.catalog = catalog;
        return this.config(configuration);
    }

    public Container<LgtmConfig> container(LgtmConfig config, ModulesConfiguration root) {
        return this.set((GenericContainer)new LgtmContainer(config, this.isScrapingRequired(this.catalog.classChecker())));
    }

    private boolean isScrapingRequired(Function<String, Boolean> checker) {
        boolean result = false;
        String foundRegistry = null;
        for (String clazz : SCRAPING_REGISTRIES) {
            if (!checker.apply(clazz).booleanValue()) continue;
            foundRegistry = clazz;
            result = true;
            break;
        }
        if (result && this.catalog != null && this.catalog.hasMicrometerOtlp()) {
            log.warnf("Multiple Micrometer registries found - OTLP and %s, no Prometheus scrapping required.", (Object)foundRegistry);
            return false;
        }
        return result;
    }

    private int getPrivateOtlpPort() {
        if (this.config != null) {
            return LgtmContainer.getPrivateOtlpPort((String)this.config.otlpProtocol());
        }
        return -1;
    }

    private Map<String, String> config(int privatePort, String host) {
        return this.config(privatePort, host, ((LgtmContainer)this.container).getMappedPort(privatePort));
    }

    public Map<String, String> config(int privatePort, String host, int publicPort) {
        int privateOtlpPort;
        HashMap<String, String> containerConfigs = new HashMap<String, String>();
        switch (privatePort) {
            case 3000: {
                containerConfigs.put("grafana.endpoint", String.format("http://%s:%s", host, publicPort));
                break;
            }
            case 4318: {
                if (this.catalog != null && this.catalog.hasMicrometerOtlp()) {
                    containerConfigs.put("quarkus.micrometer.export.otlp.url", String.format("http://%s:%s/v1/metrics", host, publicPort));
                }
            }
            case 4317: {
                containerConfigs.put("otel-collector.url", String.format("%s:%s", host, publicPort));
            }
        }
        if (this.catalog != null && this.catalog.hasOpenTelemetry() && (privateOtlpPort = this.getPrivateOtlpPort()) == privatePort) {
            containerConfigs.put("quarkus.otel.exporter.otlp.endpoint", String.format("http://%s:%s", host, publicPort));
            String otlpProtocol = this.config.otlpProtocol();
            containerConfigs.put("quarkus.otel.exporter.otlp.protocol", otlpProtocol);
        }
        return containerConfigs;
    }

    protected LgtmContainer defaultContainer() {
        return new LgtmContainer(this.isScrapingRequired(TCCL_FN));
    }

    public Map<String, String> doStart() {
        String host = ((LgtmContainer)this.container).getHost();
        HashMap<String, String> containerConfigs = new HashMap<String, String>();
        containerConfigs.putAll(this.config(3000, host));
        containerConfigs.putAll(this.config(4318, host));
        if ("grpc".equals(((LgtmContainer)this.container).getOtlpProtocol())) {
            containerConfigs.putAll(this.config(4317, host));
        }
        return containerConfigs;
    }

    public int order() {
        return 10000;
    }
}

