/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.rest.data.panache.deployment;

import io.quarkus.deployment.bean.JavaBeanUtil;
import io.quarkus.gizmo.MethodDescriptor;
import org.bson.codecs.pojo.annotations.BsonId;
import org.bson.types.ObjectId;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class EntityClassHelper {
    private static final DotName OBJECT_ID = DotName.createSimple((String)ObjectId.class.getName());
    private static final DotName BSON_ID_ANNOTATION = DotName.createSimple((String)BsonId.class.getName());
    private final IndexView index;

    public EntityClassHelper(IndexView index) {
        this.index = index;
    }

    public FieldInfo getIdField(String className) {
        return this.getIdField(this.index.getClassByName(DotName.createSimple((String)className)));
    }

    private FieldInfo getIdField(ClassInfo classInfo) {
        ClassInfo tmpClassInfo = classInfo;
        while (tmpClassInfo != null) {
            for (FieldInfo field : tmpClassInfo.fields()) {
                if (!field.type().name().equals((Object)OBJECT_ID) && !field.hasAnnotation(BSON_ID_ANNOTATION)) continue;
                return field;
            }
            if (tmpClassInfo.superName() != null) {
                tmpClassInfo = this.index.getClassByName(tmpClassInfo.superName());
                continue;
            }
            tmpClassInfo = null;
        }
        throw new IllegalArgumentException("Couldn't find id field of " + String.valueOf(classInfo));
    }

    public MethodDescriptor getSetter(String className, FieldInfo field) {
        return this.getSetter(this.index.getClassByName(DotName.createSimple((String)className)), field);
    }

    private MethodDescriptor getSetter(ClassInfo entityClass, FieldInfo field) {
        if (entityClass == null) {
            return null;
        }
        MethodInfo methodInfo = entityClass.method(JavaBeanUtil.getSetterName((String)field.name()), new Type[]{field.type()});
        if (methodInfo != null) {
            return MethodDescriptor.of((MethodInfo)methodInfo);
        }
        if (entityClass.superName() != null) {
            return this.getSetter(this.index.getClassByName(entityClass.superName()), field);
        }
        return null;
    }
}

