/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb;

import com.mongodb.client.model.Collation;
import com.mongodb.reactivestreams.client.AggregatePublisher;
import java.util.concurrent.TimeUnit;
import org.bson.conversions.Bson;

public class AggregateOptions {
    private Bson hint;
    private boolean allowDiskUse;
    private long maxTime;
    private TimeUnit maxTimeUnit;
    private long maxAwaitTime;
    private TimeUnit maxAwaitTimeUnit;
    private boolean bypassDocumentValidation;
    private Collation collation;
    private String comment;
    private int batchSize;

    public AggregateOptions allowDiskUse(boolean allowDiskUse) {
        this.allowDiskUse = allowDiskUse;
        return this;
    }

    public AggregateOptions maxTime(long maxTime, TimeUnit timeUnit) {
        this.maxTime = maxTime;
        this.maxTimeUnit = timeUnit;
        return this;
    }

    public AggregateOptions maxAwaitTime(long maxAwaitTime, TimeUnit timeUnit) {
        this.maxAwaitTime = maxAwaitTime;
        this.maxAwaitTimeUnit = timeUnit;
        return this;
    }

    public AggregateOptions bypassDocumentValidation(boolean bypassDocumentValidation) {
        this.bypassDocumentValidation = true;
        return this;
    }

    public AggregateOptions collation(Collation collation) {
        this.collation = collation;
        return this;
    }

    public AggregateOptions comment(String comment) {
        this.comment = comment;
        return this;
    }

    public AggregateOptions hint(Bson hint) {
        this.hint = hint;
        return this;
    }

    public AggregateOptions batchSize(int size) {
        this.batchSize = size;
        return this;
    }

    public <T> AggregatePublisher<T> apply(AggregatePublisher<T> stream) {
        AggregatePublisher publisher = stream;
        if (this.hint != null) {
            publisher = publisher.hint(this.hint);
        }
        if (this.comment != null) {
            publisher = publisher.comment(this.comment);
        }
        if (this.collation != null) {
            publisher = publisher.collation(this.collation);
        }
        publisher.bypassDocumentValidation(Boolean.valueOf(this.bypassDocumentValidation));
        publisher.allowDiskUse(Boolean.valueOf(this.allowDiskUse));
        if (this.maxAwaitTime > 0L) {
            publisher.maxAwaitTime(this.maxAwaitTime, this.maxAwaitTimeUnit);
        }
        if (this.maxTime > 0L) {
            publisher.maxAwaitTime(this.maxTime, this.maxTimeUnit);
        }
        if (this.batchSize > 0) {
            publisher.batchSize(this.batchSize);
        }
        return publisher;
    }
}

