/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.reactivemessaging.runtime;

import io.smallrye.reactive.messaging.EmitterConfiguration;
import io.smallrye.reactive.messaging.annotations.Broadcast;
import io.smallrye.reactive.messaging.annotations.EmitterFactoryFor;
import java.util.Objects;
import org.eclipse.microprofile.reactive.messaging.OnOverflow;

public class QuarkusEmitterConfiguration
implements EmitterConfiguration {
    private String name;
    private EmitterFactoryFor emitterType;
    private OnOverflow.Strategy overflowBufferStrategy;
    private long overflowBufferSize;
    private boolean broadcast;
    private int numberOfSubscriberBeforeConnecting;

    public QuarkusEmitterConfiguration() {
    }

    public QuarkusEmitterConfiguration(String name, EmitterFactoryFor emitterType, OnOverflow onOverflow, Broadcast broadcast) {
        this.name = name;
        this.emitterType = emitterType;
        if (onOverflow != null) {
            this.overflowBufferStrategy = onOverflow.value();
            this.overflowBufferSize = onOverflow.bufferSize();
        } else {
            this.overflowBufferStrategy = null;
            this.overflowBufferSize = -1L;
        }
        if (broadcast != null) {
            this.broadcast = Boolean.TRUE;
            this.numberOfSubscriberBeforeConnecting = broadcast.value();
        } else {
            this.numberOfSubscriberBeforeConnecting = -1;
        }
    }

    public String name() {
        return this.name;
    }

    public EmitterFactoryFor emitterType() {
        return this.emitterType;
    }

    public OnOverflow.Strategy overflowBufferStrategy() {
        return this.overflowBufferStrategy;
    }

    public long overflowBufferSize() {
        return this.overflowBufferSize;
    }

    public boolean broadcast() {
        return this.broadcast;
    }

    public int numberOfSubscriberBeforeConnecting() {
        return this.numberOfSubscriberBeforeConnecting;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public EmitterFactoryFor getEmitterType() {
        return this.emitterType;
    }

    public void setEmitterType(EmitterFactoryFor emitterType) {
        this.emitterType = emitterType;
    }

    public OnOverflow.Strategy getOverflowBufferStrategy() {
        return this.overflowBufferStrategy;
    }

    public void setOverflowBufferStrategy(OnOverflow.Strategy overflowBufferStrategy) {
        this.overflowBufferStrategy = overflowBufferStrategy;
    }

    public long getOverflowBufferSize() {
        return this.overflowBufferSize;
    }

    public void setOverflowBufferSize(long overflowBufferSize) {
        this.overflowBufferSize = overflowBufferSize;
    }

    public boolean isBroadcast() {
        return this.broadcast;
    }

    public void setBroadcast(boolean broadcast) {
        this.broadcast = broadcast;
    }

    public int getNumberOfSubscriberBeforeConnecting() {
        return this.numberOfSubscriberBeforeConnecting;
    }

    public void setNumberOfSubscriberBeforeConnecting(int numberOfSubscriberBeforeConnecting) {
        this.numberOfSubscriberBeforeConnecting = numberOfSubscriberBeforeConnecting;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QuarkusEmitterConfiguration that = (QuarkusEmitterConfiguration)o;
        return this.overflowBufferSize == that.overflowBufferSize && this.broadcast == that.broadcast && this.numberOfSubscriberBeforeConnecting == that.numberOfSubscriberBeforeConnecting && Objects.equals(this.name, that.name) && Objects.equals(this.emitterType.value(), that.emitterType.value()) && this.overflowBufferStrategy == that.overflowBufferStrategy;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.emitterType.value(), this.overflowBufferStrategy, this.overflowBufferSize, this.broadcast, this.numberOfSubscriberBeforeConnecting);
    }

    public String toString() {
        return "QuarkusEmitterConfiguration{name='" + this.name + "', emitterType=" + String.valueOf(this.emitterType) + ", overflowBufferStrategy=" + String.valueOf(this.overflowBufferStrategy) + ", overflowBufferSize=" + this.overflowBufferSize + ", broadcast=" + this.broadcast + ", numberOfSubscriberBeforeConnecting=" + this.numberOfSubscriberBeforeConnecting + "}";
    }
}

