/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.reactivemessaging.deployment.items;

import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.smallrye.reactivemessaging.deployment.items.ChannelDirection;
import java.util.Objects;

public final class ChannelBuildItem
extends MultiBuildItem {
    private final String name;
    private final ChannelDirection direction;
    private final String connector;

    ChannelBuildItem(String name, ChannelDirection direction, String connector) {
        this.name = Objects.requireNonNull(name, "The channel name must be set");
        this.direction = Objects.requireNonNull(direction, "The direction of the channel must be set");
        this.connector = connector;
    }

    public static ChannelBuildItem incoming(String name, String connector) {
        return new ChannelBuildItem(name, ChannelDirection.INCOMING, connector);
    }

    public static ChannelBuildItem outgoing(String name, String connector) {
        return new ChannelBuildItem(name, ChannelDirection.OUTGOING, connector);
    }

    public String getName() {
        return this.name;
    }

    public boolean isManagedByAConnector() {
        return this.connector != null;
    }

    public String getConnector() {
        return this.connector;
    }

    public ChannelDirection getDirection() {
        return this.direction;
    }
}

