/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.quarkus.runtime.annotations.ConfigDocMapKey;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public interface SecurityContextConfig {
    public SeLinuxOptions seLinuxOptions();

    public WindowsOptions windowsOptions();

    public Optional<Long> runAsUser();

    public Optional<Long> runAsGroup();

    public Optional<Boolean> runAsNonRoot();

    public Optional<List<Long>> supplementalGroups();

    public Optional<Long> fsGroup();

    @ConfigDocMapKey(value="sysctl-name")
    public Map<String, String> sysctls();

    public Optional<PodFSGroupChangePolicy> fsGroupChangePolicy();

    default public boolean isAnyPropertySet() {
        return this.seLinuxOptions().isAnyPropertySet() || this.windowsOptions().isAnyPropertySet() || this.runAsUser().isPresent() || this.runAsGroup().isPresent() || this.runAsNonRoot().isPresent() || this.supplementalGroups().isPresent() || this.fsGroup().isPresent() || !this.sysctls().isEmpty() || this.fsGroupChangePolicy().isPresent();
    }

    public static interface SeLinuxOptions {
        public Optional<String> level();

        public Optional<String> role();

        public Optional<String> type();

        public Optional<String> user();

        default public boolean isAnyPropertySet() {
            return this.level().isPresent() || this.role().isPresent() || this.type().isPresent() || this.user().isPresent();
        }
    }

    public static interface WindowsOptions {
        public Optional<String> gmsaCredentialSpecName();

        public Optional<String> gmsaCredentialSpec();

        public Optional<String> runAsUserName();

        public Optional<Boolean> hostProcess();

        default public boolean isAnyPropertySet() {
            return this.gmsaCredentialSpecName().isPresent() || this.gmsaCredentialSpec().isPresent() || this.runAsUserName().isPresent() || this.hostProcess().isPresent();
        }
    }

    public static enum PodFSGroupChangePolicy {
        OnRootMismatch,
        Always;

    }
}

