/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.knative.config.KnativeConfigFluent;
import io.dekorate.kubernetes.config.Configurator;
import io.dekorate.kubernetes.config.Port;
import java.util.Objects;

public class AddPortToKnativeConfig
extends Configurator<KnativeConfigFluent<?>> {
    private final Port port;

    public AddPortToKnativeConfig(Port port) {
        this.port = port;
    }

    public void visit(KnativeConfigFluent<?> config) {
        if (!this.hasPort(config)) {
            config.addToPorts(new Port[]{this.port});
        }
    }

    private boolean hasPort(KnativeConfigFluent<?> config) {
        for (Port p : config.buildPorts()) {
            if (!Objects.equals(p.getContainerPort(), this.port.getContainerPort())) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AddPortToKnativeConfig addPort = (AddPortToKnativeConfig)((Object)o);
        return Objects.equals(this.port, addPort.port);
    }

    public int hashCode() {
        return Objects.hash(this.port);
    }
}

