/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.client.deployment;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.AnyType;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.KubeSchema;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.ValidationSchema;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.VersionInfo;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.extension.ExtensionAdapter;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.impl.KubernetesClientImpl;
import io.fabric8.kubernetes.client.informers.ResourceEventHandler;
import io.fabric8.kubernetes.client.utils.OpenIDConnectionUtils;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.kubernetes.internal.KubernetesDeserializer;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationIndexBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.RemovedResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeReinitializedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.util.JandexUtil;
import io.quarkus.jackson.deployment.IgnoreJsonDeserializeClassBuildItem;
import io.quarkus.kubernetes.client.runtime.KubernetesClientBuildConfig;
import io.quarkus.kubernetes.client.runtime.KubernetesClientObjectMapperProducer;
import io.quarkus.kubernetes.client.runtime.KubernetesClientProducer;
import io.quarkus.kubernetes.client.runtime.KubernetesConfigProducer;
import io.quarkus.kubernetes.client.runtime.KubernetesSerializationProducer;
import io.quarkus.kubernetes.client.spi.KubernetesClientCapabilityBuildItem;
import io.quarkus.maven.dependency.ArtifactKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexView;
import org.jboss.logging.Logger;

public class KubernetesClientProcessor {
    private static final Logger log = Logger.getLogger((String)KubernetesClientProcessor.class.getName());
    private static final DotName WATCHER = DotName.createSimple((String)Watcher.class.getName());
    private static final DotName RESOURCE_EVENT_HANDLER = DotName.createSimple((String)ResourceEventHandler.class.getName());
    private static final DotName KUBERNETES_RESOURCE = DotName.createSimple((String)KubernetesResource.class.getName());
    private static final DotName VALIDATION_SCHEMA = DotName.createSimple((String)ValidationSchema.class.getName());
    private static final DotName KUBERNETES_RESOURCE_LIST = DotName.createSimple((String)KubernetesResourceList.class.getName());
    private static final DotName KUBE_SCHEMA = DotName.createSimple((String)KubeSchema.class.getName());
    private static final DotName VISITABLE_BUILDER = DotName.createSimple((String)VisitableBuilder.class.getName());
    private static final DotName CUSTOM_RESOURCE = DotName.createSimple((String)CustomResource.class.getName());
    private static final String[] EMPTY_STRINGS_ARRAY = new String[0];

    @BuildStep
    public void registerBeanProducers(BuildProducer<AdditionalBeanBuildItem> additionalBeanBuildItemBuildItem, Capabilities capabilities) {
        additionalBeanBuildItemBuildItem.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(KubernetesClientObjectMapperProducer.class));
        additionalBeanBuildItemBuildItem.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(KubernetesSerializationProducer.class));
        additionalBeanBuildItemBuildItem.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(KubernetesConfigProducer.class));
        if (capabilities.isMissing("io.quarkus.openshift.client")) {
            additionalBeanBuildItemBuildItem.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(KubernetesClientProducer.class));
        }
    }

    @BuildStep
    public void nativeImageSupport(BuildProducer<RuntimeReinitializedClassBuildItem> runtimeInitializedClassProducer) {
        runtimeInitializedClassProducer.produce((BuildItem)new RuntimeReinitializedClassBuildItem(Utils.class.getName()));
    }

    @BuildStep
    RemovedResourceBuildItem unregisterVertHttpClient() {
        return new RemovedResourceBuildItem(ArtifactKey.fromString((String)"io.fabric8:kubernetes-httpclient-vertx"), Collections.singleton("META-INF/services/io.fabric8.kubernetes.client.http.HttpClient$Factory"));
    }

    @BuildStep
    public void process(ApplicationIndexBuildItem applicationIndex, CombinedIndexBuildItem combinedIndexBuildItem, KubernetesClientBuildConfig kubernetesClientConfig, BuildProducer<ExtensionSslNativeSupportBuildItem> sslNativeSupport, BuildProducer<FeatureBuildItem> featureProducer, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchies, BuildProducer<IgnoreJsonDeserializeClassBuildItem> ignoredJsonDeserializationClasses, BuildProducer<ServiceProviderBuildItem> serviceProviderProducer, BuildProducer<KubernetesClientCapabilityBuildItem> kubernetesClientCapabilityProducer) {
        featureProducer.produce((BuildItem)new FeatureBuildItem(Feature.KUBERNETES_CLIENT));
        kubernetesClientCapabilityProducer.produce((BuildItem)new KubernetesClientCapabilityBuildItem(kubernetesClientConfig.generateRbac()));
        HashSet<DotName> watchedClasses = new HashSet<DotName>();
        Index appIndex = applicationIndex.getIndex();
        IndexView fullIndex = combinedIndexBuildItem.getIndex();
        this.findWatchedClasses(WATCHER, watchedClasses, 1, true, (IndexView)appIndex, fullIndex);
        this.findWatchedClasses(RESOURCE_EVENT_HANDLER, watchedClasses, 1, true, (IndexView)appIndex, fullIndex);
        this.findWatchedClasses(CUSTOM_RESOURCE, watchedClasses, 2, false, fullIndex, fullIndex);
        ReflectiveHierarchyBuildItem.DefaultIgnoreTypePredicate reflectionIgnorePredicate = ReflectiveHierarchyBuildItem.DefaultIgnoreTypePredicate.INSTANCE;
        for (DotName className : watchedClasses) {
            if (reflectionIgnorePredicate.test(className)) continue;
            ClassInfo watchedClass = fullIndex.getClassByName(className);
            if (watchedClass == null) {
                log.warnv("Unable to lookup class: {0}", (Object)className);
                continue;
            }
            reflectiveHierarchies.produce((BuildItem)ReflectiveHierarchyBuildItem.builder((DotName)className).ignoreTypePredicate((Predicate)reflectionIgnorePredicate).source(this.getClass().getSimpleName() + " > " + String.valueOf(className)).build());
        }
        Collection kubernetesResourceImpls = fullIndex.getAllKnownImplementors(KUBERNETES_RESOURCE);
        Collection kubernetesResourceListImpls = fullIndex.getAllKnownImplementors(KUBERNETES_RESOURCE_LIST);
        Collection visitableBuilderImpls = fullIndex.getAllKnownImplementors(VISITABLE_BUILDER);
        int defSize = kubernetesResourceImpls.size() + kubernetesResourceListImpls.size() + visitableBuilderImpls.size();
        ArrayList<String> withFieldsRegistration = new ArrayList<String>(defSize);
        ArrayList<DotName> ignoreJsonDeserialization = new ArrayList<DotName>(defSize);
        KubernetesClientProcessor.populateReflectionRegistrationLists(kubernetesResourceImpls, watchedClasses, ignoreJsonDeserialization, withFieldsRegistration);
        KubernetesClientProcessor.populateReflectionRegistrationLists(kubernetesResourceListImpls, watchedClasses, ignoreJsonDeserialization, withFieldsRegistration);
        KubernetesClientProcessor.populateReflectionRegistrationLists(visitableBuilderImpls, watchedClasses, ignoreJsonDeserialization, withFieldsRegistration);
        if (!withFieldsRegistration.isEmpty()) {
            reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])withFieldsRegistration.toArray(EMPTY_STRINGS_ARRAY)).reason(this.getClass().getName()).weak().methods().fields().build());
        }
        ignoredJsonDeserializationClasses.produce((BuildItem)new IgnoreJsonDeserializeClassBuildItem(ignoreJsonDeserialization));
        ignoredJsonDeserializationClasses.produce((BuildItem)new IgnoreJsonDeserializeClassBuildItem(KUBE_SCHEMA));
        ignoredJsonDeserializationClasses.produce((BuildItem)new IgnoreJsonDeserializeClassBuildItem(KUBERNETES_RESOURCE_LIST));
        ignoredJsonDeserializationClasses.produce((BuildItem)new IgnoreJsonDeserializeClassBuildItem(KUBERNETES_RESOURCE));
        ignoredJsonDeserializationClasses.produce((BuildItem)new IgnoreJsonDeserializeClassBuildItem(VALIDATION_SCHEMA));
        String[] deserializerClasses = (String[])fullIndex.getAllKnownSubclasses(DotName.createSimple((String)"com.fasterxml.jackson.databind.JsonDeserializer")).stream().map(c -> c.name().toString()).filter(s -> s.startsWith("io.fabric8.kubernetes")).toArray(String[]::new);
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])deserializerClasses).reason(this.getClass().getName()).methods().build());
        String[] serializerClasses = (String[])fullIndex.getAllKnownSubclasses(DotName.createSimple((String)"com.fasterxml.jackson.databind.JsonSerializer")).stream().map(c -> c.name().toString()).filter(s -> s.startsWith("io.fabric8.kubernetes")).toArray(String[]::new);
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])serializerClasses).reason(this.getClass().getName()).methods().build());
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{KubernetesClientImpl.class, DefaultKubernetesClient.class, VersionInfo.class}).reason(this.getClass().getName()).methods().fields().build());
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{AnyType.class, IntOrString.class, KubernetesDeserializer.class}).reason(this.getClass().getName()).methods().build());
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{Config.ExecCredential.class, Config.ExecCredentialSpec.class, Config.ExecCredentialStatus.class}).reason(this.getClass().getName()).methods().fields().build());
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{OpenIDConnectionUtils.OpenIdConfiguration.class, OpenIDConnectionUtils.OAuthToken.class}).reason(this.getClass().getName()).methods().fields().build());
        if (log.isDebugEnabled()) {
            String watchedClassNames = watchedClasses.stream().map(Object::toString).sorted().collect(Collectors.joining("\n"));
            log.debugv("Watched Classes:\n{0}", (Object)watchedClassNames);
            ArrayList<String> modelClasses = new ArrayList<String>(withFieldsRegistration.size());
            modelClasses.addAll(withFieldsRegistration);
            Collections.sort(modelClasses);
            log.debugv("Model Classes:\n{0}", (Object)String.join((CharSequence)"\n", modelClasses));
        }
        serviceProviderProducer.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)HttpClient.Factory.class.getName()));
        serviceProviderProducer.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)KubernetesResource.class.getName()));
        serviceProviderProducer.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)ExtensionAdapter.class.getName()));
        sslNativeSupport.produce((BuildItem)new ExtensionSslNativeSupportBuildItem(Feature.KUBERNETES_CLIENT));
    }

    private static void populateReflectionRegistrationLists(Collection<ClassInfo> kubernetesResourceImpls, Set<DotName> watchedClasses, List<DotName> ignoredJsonDeserializationClasses, List<String> withFieldsRegistration) {
        for (ClassInfo resource : kubernetesResourceImpls) {
            ignoredJsonDeserializationClasses.add(resource.name());
            if (watchedClasses.contains(resource.name())) continue;
            withFieldsRegistration.add(resource.name().toString());
        }
    }

    private void findWatchedClasses(DotName implementedOrExtendedClass, Set<DotName> watchedClasses, int expectedGenericTypeCardinality, boolean isTargetClassAnInterface, IndexView targetIndex, IndexView fullIndex) {
        Collection implementors = isTargetClassAnInterface ? targetIndex.getAllKnownImplementors(implementedOrExtendedClass) : targetIndex.getAllKnownSubclasses(implementedOrExtendedClass);
        implementors.forEach(c -> {
            block4: {
                try {
                    List watcherGenericTypes = JandexUtil.resolveTypeParameters((DotName)c.name(), (DotName)implementedOrExtendedClass, (IndexView)fullIndex);
                    if (!isTargetClassAnInterface) {
                        watchedClasses.add(c.name());
                    }
                    if (watcherGenericTypes.size() == expectedGenericTypeCardinality) {
                        watcherGenericTypes.forEach(t -> watchedClasses.add(t.name()));
                    }
                }
                catch (IllegalArgumentException ignored) {
                    if (!targetIndex.getAllKnownSubclasses(c.name()).isEmpty()) break block4;
                    log.warnv("{0} '{1}' will most likely not work correctly in native mode. Consider specifying the generic type of '{2}' that this class handles. See https://quarkus.io/guides/kubernetes-client#note-on-generic-types for more details", (Object)implementedOrExtendedClass.local(), (Object)c.name(), (Object)implementedOrExtendedClass);
                }
            }
        });
    }
}

