/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.component;

import io.quarkus.arc.All;
import io.quarkus.arc.ComponentsProvider;
import io.quarkus.arc.processor.Annotations;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.BeanArchives;
import io.quarkus.arc.processor.BeanConfigurator;
import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.BeanDeploymentValidator;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BeanProcessor;
import io.quarkus.arc.processor.BeanRegistrar;
import io.quarkus.arc.processor.BeanResolver;
import io.quarkus.arc.processor.Beans;
import io.quarkus.arc.processor.BuildExtension;
import io.quarkus.arc.processor.BuiltinBean;
import io.quarkus.arc.processor.BytecodeTransformer;
import io.quarkus.arc.processor.ContextRegistrar;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.InterceptorConfigurator;
import io.quarkus.arc.processor.ResourceOutput;
import io.quarkus.arc.processor.Types;
import io.quarkus.commons.classloading.ClassLoaderHelper;
import io.quarkus.dev.testing.TracingHandler;
import io.quarkus.test.InjectMock;
import io.quarkus.test.component.BuildResult;
import io.quarkus.test.component.Conditions;
import io.quarkus.test.component.ConfigBeanCreator;
import io.quarkus.test.component.ConfigMappingBeanCreator;
import io.quarkus.test.component.ConfigPropertyBeanCreator;
import io.quarkus.test.component.InterceptorMethodCreator;
import io.quarkus.test.component.JaxrsSingletonTransformer;
import io.quarkus.test.component.MockBeanConfiguratorImpl;
import io.quarkus.test.component.MockBeanCreator;
import io.quarkus.test.component.QuarkusComponentTestCallbacks;
import io.quarkus.test.component.QuarkusComponentTestConfiguration;
import io.quarkus.test.component.QuarkusComponentTestExtension;
import io.quarkus.test.component.SkipInject;
import io.smallrye.config.ConfigMapping;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.annotation.Priority;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.InterceptionType;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.interceptor.AroundConstruct;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.InvocationContext;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationTransformation;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.RepetitionInfo;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.TestReporter;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;

class ComponentContainer {
    private static final Logger LOG = Logger.getLogger(ComponentContainer.class);
    static final Predicate<Parameter> BUILTIN_PARAMETER = new Predicate<Parameter>(){

        @Override
        public boolean test(Parameter parameter) {
            if (parameter.isAnnotationPresent(TempDir.class)) {
                return true;
            }
            Type type = parameter.getParameterizedType();
            return type.equals(TestInfo.class) || type.equals(RepetitionInfo.class) || type.equals(TestReporter.class);
        }
    };
    static final DotName ALL_NAME = DotName.createSimple(All.class);
    private static final String QUARKUS_TEST_COMPONENT_OUTPUT_DIRECTORY = "quarkus.test.component.output-directory";

    ComponentContainer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static BuildResult build(final Class<?> testClass, final QuarkusComponentTestConfiguration configuration, boolean buildShouldFail, Set<String> tracedClasses) {
        IndexView index;
        if (configuration.componentClasses.isEmpty()) {
            throw new IllegalStateException("No component classes to test");
        }
        long start = System.nanoTime();
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Tested components: \n - %s", (Object)configuration.componentClasses.stream().map(Object::toString).collect(Collectors.joining("\n - ")));
        }
        try {
            Indexer indexer = new Indexer();
            for (Class<?> clazz : configuration.componentClasses) {
                ComponentContainer.indexComponentClass(indexer, clazz);
            }
            if (configuration.hasCallbacks()) {
                BeforeIndexContextImpl context = new BeforeIndexContextImpl(testClass, configuration.componentClasses);
                for (QuarkusComponentTestCallbacks callback : configuration.callbacks) {
                    callback.beforeIndex(context);
                }
                for (Class<?> clazz : context.additionalComponentsClasses) {
                    ComponentContainer.indexComponentClass(indexer, clazz);
                }
            }
            indexer.indexClass(ConfigProperty.class);
            index = BeanArchives.buildImmutableBeanArchiveIndex((IndexView[])new IndexView[]{indexer.complete()});
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create index", e);
        }
        ClassLoader testClassLoader = testClass.getClassLoader();
        boolean isContinuousTesting = Conditions.isContinuousTestingDiscovery();
        final IndexView indexView = BeanArchives.buildComputingBeanArchiveIndex((ClassLoader)testClassLoader, new ConcurrentHashMap(), (IndexView)index);
        final HashMap<String, byte[]> generatedClasses = new HashMap<String, byte[]>();
        final AtomicReference componentsProvider = new AtomicReference();
        final HashMap<String, Set<String>> configMappings = new HashMap<String, Set<String>>();
        final HashMap<String, String[]> interceptorMethods = new HashMap<String, String[]>();
        Throwable buildFailure = null;
        ArrayList<BytecodeTransformer> bytecodeTransformers = new ArrayList<BytecodeTransformer>();
        ArrayList<AnnotationTransformation> annotationTransformations = new ArrayList<AnnotationTransformation>();
        for (AnnotationsTransformer transformer : configuration.annotationsTransformers) {
            annotationTransformations.add((AnnotationTransformation)transformer);
        }
        ArrayList<BeanRegistrar> beanRegistrars = new ArrayList<BeanRegistrar>();
        if (configuration.hasCallbacks()) {
            BeforeBulidContextImpl beforeBuildContext = new BeforeBulidContextImpl(testClass, index, indexView, bytecodeTransformers, annotationTransformations, beanRegistrars);
            for (QuarkusComponentTestCallbacks callback : configuration.callbacks) {
                callback.beforeBuild(beforeBuildContext);
            }
        }
        try {
            Path generatedClassesDirectory;
            final ArrayList qualifiers = new ArrayList();
            final HashSet<String> interceptorBindings = new HashSet<String>();
            AtomicReference<BeanResolver> beanResolver = new AtomicReference<BeanResolver>();
            List<Field> injectFields = ComponentContainer.findInjectFields(testClass, true);
            List<Parameter> injectParams = ComponentContainer.findInjectParams(testClass);
            String beanProcessorName = testClass.getName().replace('.', '_');
            AtomicReference<BeanDeployment> beanDeployment = new AtomicReference<BeanDeployment>();
            BeanProcessor.Builder builder = BeanProcessor.builder().setName(beanProcessorName).addRemovalExclusion(b -> {
                if (b.getTarget().isPresent() && ((BeanDeployment)beanDeployment.get()).hasAnnotation((AnnotationTarget)b.getTarget().get(), DotNames.UNREMOVABLE)) {
                    return true;
                }
                for (Field injectionPoint : injectFields) {
                    if (!ComponentContainer.injectionPointMatchesBean(injectionPoint.getGenericType(), injectionPoint, qualifiers, (BeanResolver)beanResolver.get(), b)) continue;
                    return true;
                }
                for (Parameter param : injectParams) {
                    if (!ComponentContainer.injectionPointMatchesBean(param.getParameterizedType(), param, qualifiers, (BeanResolver)beanResolver.get(), b)) continue;
                    return true;
                }
                return false;
            }).setImmutableBeanArchiveIndex(index).setComputingBeanArchiveIndex(indexView).setRemoveUnusedBeans(true).setTransformUnproxyableClasses(true);
            if (isContinuousTesting) {
                generatedClassesDirectory = null;
            } else {
                Iterator<MockBeanConfiguratorImpl<Object>> testOutputDirectory = ComponentContainer.getTestOutputDirectory(testClass);
                generatedClassesDirectory = ((File)((Object)testOutputDirectory)).getParentFile().toPath().resolve("generated-classes").resolve(beanProcessorName);
                Files.createDirectories(generatedClassesDirectory, new FileAttribute[0]);
            }
            builder.setOutput(new ResourceOutput(){

                public void writeResource(ResourceOutput.Resource resource) throws IOException {
                    switch (resource.getType()) {
                        case JAVA_CLASS: {
                            generatedClasses.put(resource.getFullyQualifiedName(), resource.getData());
                            if (generatedClassesDirectory == null) break;
                            resource.writeTo(generatedClassesDirectory.toFile());
                            break;
                        }
                        case SERVICE_PROVIDER: {
                            if (!resource.getName().equals(ComponentsProvider.class.getName())) break;
                            componentsProvider.set(resource.getData());
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unsupported resource type: " + String.valueOf(resource.getType()));
                        }
                    }
                }
            });
            builder.addAnnotationTransformation((AnnotationTransformation)((AnnotationsTransformer.FieldTransformerBuilder)((AnnotationsTransformer.FieldTransformerBuilder)AnnotationsTransformer.appliedToField().whenContainsAny(qualifiers)).whenContainsNone(new DotName[]{DotName.createSimple(Inject.class)})).thenTransform(t -> t.add(Inject.class, new AnnotationValue[0])));
            builder.addAnnotationTransformation((AnnotationTransformation)new JaxrsSingletonTransformer());
            for (AnnotationTransformation transformation : annotationTransformations) {
                builder.addAnnotationTransformation(transformation);
            }
            builder.addBeanRegistrar(new BeanRegistrar(){

                public void register(BeanRegistrar.RegistrationContext registrationContext) {
                    Set<AnnotationInstance> requiredQualifiers;
                    long start = System.nanoTime();
                    List beans = registrationContext.beans().collect();
                    BeanDeployment beanDeployment = (BeanDeployment)registrationContext.get(BuildExtension.Key.DEPLOYMENT);
                    HashSet<InjectionPointInfo.TypeAndQualifiers> unsatisfiedInjectionPoints = new HashSet<InjectionPointInfo.TypeAndQualifiers>();
                    boolean configInjectionPoint = false;
                    HashSet<InjectionPointInfo.TypeAndQualifiers> configPropertyInjectionPoints = new HashSet<InjectionPointInfo.TypeAndQualifiers>();
                    DotName configDotName = DotName.createSimple(Config.class);
                    DotName configPropertyDotName = DotName.createSimple(ConfigProperty.class);
                    DotName configMappingDotName = DotName.createSimple(ConfigMapping.class);
                    for (InjectionPointInfo injectionPointInfo : registrationContext.getInjectionPoints()) {
                        AnnotationInstance configMapping;
                        ClassInfo clazz;
                        if (injectionPointInfo.getRequiredType().name().equals((Object)configDotName) && injectionPointInfo.hasDefaultedQualifier()) {
                            configInjectionPoint = true;
                            continue;
                        }
                        if (injectionPointInfo.getRequiredQualifier(configPropertyDotName) != null) {
                            configPropertyInjectionPoints.add(new InjectionPointInfo.TypeAndQualifiers(injectionPointInfo.getRequiredType(), injectionPointInfo.getRequiredQualifiers()));
                            continue;
                        }
                        BuiltinBean builtin = BuiltinBean.resolve((InjectionPointInfo)injectionPointInfo);
                        if (builtin != null && builtin != BuiltinBean.INSTANCE && builtin != BuiltinBean.LIST) continue;
                        org.jboss.jandex.Type requiredType = injectionPointInfo.getRequiredType();
                        HashSet<AnnotationInstance> requiredQualifiers2 = injectionPointInfo.getRequiredQualifiers();
                        if (builtin == BuiltinBean.LIST) {
                            requiredType = (org.jboss.jandex.Type)requiredType.asParameterizedType().arguments().get(0);
                            requiredQualifiers2 = new HashSet<AnnotationInstance>(requiredQualifiers2);
                            requiredQualifiers2.removeIf(q -> q.name().equals((Object)DotNames.ALL));
                            if (requiredQualifiers2.isEmpty()) {
                                requiredQualifiers2.add(AnnotationInstance.builder((DotName)DotNames.DEFAULT).build());
                            }
                        }
                        if (requiredType.kind() == Type.Kind.CLASS && (clazz = indexView.getClassByName(requiredType.name())) != null && clazz.isInterface() && (configMapping = clazz.declaredAnnotation(configMappingDotName)) != null) {
                            AnnotationValue prefixValue = configMapping.value("prefix");
                            String prefix = prefixValue == null ? "" : prefixValue.asString();
                            Set mappingClasses = configMappings.computeIfAbsent(prefix, k -> new HashSet());
                            mappingClasses.add(clazz.name().toString());
                        }
                        if (ComponentContainer.isSatisfied(requiredType, requiredQualifiers2, injectionPointInfo, beans, beanDeployment, configuration)) continue;
                        if (requiredType.kind() == Type.Kind.PRIMITIVE || requiredType.kind() == Type.Kind.ARRAY) {
                            throw new IllegalStateException("Found an unmockable unsatisfied injection point: " + injectionPointInfo.getTargetInfo());
                        }
                        unsatisfiedInjectionPoints.add(new InjectionPointInfo.TypeAndQualifiers(requiredType, requiredQualifiers2));
                        LOG.debugf("Unsatisfied injection point found: %s", (Object)injectionPointInfo.getTargetInfo());
                    }
                    for (Field field : ComponentContainer.findFields(testClass, List.of(InjectMock.class))) {
                        requiredQualifiers = ComponentContainer.getQualifiers(field, qualifiers);
                        if (requiredQualifiers.isEmpty()) {
                            requiredQualifiers = Set.of(AnnotationInstance.builder((DotName)DotNames.DEFAULT).build());
                        }
                        unsatisfiedInjectionPoints.add(new InjectionPointInfo.TypeAndQualifiers(Types.jandexType((Type)field.getGenericType()), requiredQualifiers));
                    }
                    for (Parameter parameter : ComponentContainer.findInjectMockParams(testClass)) {
                        requiredQualifiers = ComponentContainer.getQualifiers(parameter, qualifiers);
                        if (requiredQualifiers.isEmpty()) {
                            requiredQualifiers = Set.of(AnnotationInstance.builder((DotName)DotNames.DEFAULT).build());
                        }
                        unsatisfiedInjectionPoints.add(new InjectionPointInfo.TypeAndQualifiers(Types.jandexType((Type)parameter.getParameterizedType()), requiredQualifiers));
                    }
                    for (InjectionPointInfo.TypeAndQualifiers typeAndQualifiers : unsatisfiedInjectionPoints) {
                        ClassInfo implementationClass = indexView.getClassByName(typeAndQualifiers.type.name());
                        BeanConfigurator configurator = (BeanConfigurator)((BeanConfigurator)registrationContext.configure(implementationClass.name()).scope(Singleton.class)).addType(typeAndQualifiers.type);
                        typeAndQualifiers.qualifiers.forEach(arg_0 -> ((BeanConfigurator)configurator).addQualifier(arg_0));
                        ((BeanConfigurator)((BeanConfigurator)((BeanConfigurator)((BeanConfigurator)configurator.param("implementationClass", implementationClass)).creator(MockBeanCreator.class)).defaultBean()).identifier("dummy")).done();
                    }
                    if (configInjectionPoint) {
                        ((BeanConfigurator)((BeanConfigurator)registrationContext.configure(Config.class).addType(Config.class)).creator(ConfigBeanCreator.class)).done();
                    }
                    if (!configPropertyInjectionPoints.isEmpty()) {
                        BeanConfigurator configPropertyConfigurator = (BeanConfigurator)((BeanConfigurator)((BeanConfigurator)((BeanConfigurator)((BeanConfigurator)registrationContext.configure(Object.class).identifier("configProperty")).addQualifier(ConfigProperty.class)).param("useDefaultConfigProperties", configuration.useDefaultConfigProperties)).addInjectionPoint((org.jboss.jandex.Type)ClassType.create(InjectionPoint.class), new AnnotationInstance[0])).creator(ConfigPropertyBeanCreator.class);
                        for (InjectionPointInfo.TypeAndQualifiers configPropertyInjectionPoint : configPropertyInjectionPoints) {
                            configPropertyConfigurator.addType(configPropertyInjectionPoint.type);
                        }
                        configPropertyConfigurator.done();
                    }
                    if (!configMappings.isEmpty()) {
                        for (Map.Entry entry : configMappings.entrySet()) {
                            for (String mapping : (Set)entry.getValue()) {
                                DotName mappingName = DotName.createSimple((String)mapping);
                                ((BeanConfigurator)((BeanConfigurator)((BeanConfigurator)((BeanConfigurator)registrationContext.configure(mappingName).addType(mappingName)).creator(ConfigMappingBeanCreator.class)).param("mappingClass", mapping)).param("prefix", (String)entry.getKey())).done();
                            }
                        }
                    }
                    LOG.debugf("Test injection points analyzed in %s ms [found: %s, mocked: %s]", TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start), (long)registrationContext.getInjectionPoints().size(), (long)unsatisfiedInjectionPoints.size());
                    ComponentContainer.processTestInterceptorMethods(testClass, registrationContext, interceptorBindings, interceptorMethods);
                }
            });
            for (MockBeanConfiguratorImpl<?> mockConfigurator : configuration.mockConfigurators) {
                builder.addBeanRegistrar(ComponentContainer.registrarForMock(testClass, mockConfigurator));
            }
            for (BeanRegistrar beanRegistrar : beanRegistrars) {
                builder.addBeanRegistrar(beanRegistrar);
            }
            BeanProcessor beanProcessor = builder.build();
            beanDeployment.set(beanProcessor.getBeanDeployment());
            try {
                Consumer<BytecodeTransformer> bytecodeTransformerConsumer = bytecodeTransformers::add;
                ContextRegistrar.RegistrationContext registrationContext = beanProcessor.registerCustomContexts();
                qualifiers.addAll(((Map)registrationContext.get(BuildExtension.Key.QUALIFIERS)).keySet());
                for (DotName binding : ((Map)registrationContext.get(BuildExtension.Key.INTERCEPTOR_BINDINGS)).keySet()) {
                    interceptorBindings.add(binding.toString());
                }
                beanResolver.set(((BeanDeployment)registrationContext.get(BuildExtension.Key.DEPLOYMENT)).getBeanResolver());
                beanProcessor.registerScopes();
                beanProcessor.registerBeans();
                beanProcessor.getBeanDeployment().initBeanByTypeMap();
                beanProcessor.registerSyntheticObservers();
                beanProcessor.initialize(bytecodeTransformerConsumer, Collections.emptyList());
                BeanDeploymentValidator.ValidationContext validationContext = beanProcessor.validate(bytecodeTransformerConsumer);
                beanProcessor.processValidationErrors(validationContext);
                ExecutorService executor = Executors.newCachedThreadPool();
                beanProcessor.generateResources(null, new HashSet(), bytecodeTransformerConsumer, true, executor);
                executor.shutdown();
                HashMap<String, byte[]> transformedClasses = new HashMap<String, byte[]>();
                Path transformedClassesDirectory = null;
                if (!isContinuousTesting) {
                    File testOutputDirectory = ComponentContainer.getTestOutputDirectory(testClass);
                    transformedClassesDirectory = testOutputDirectory.getParentFile().toPath().resolve("transformed-classes").resolve(beanProcessorName);
                    Files.createDirectories(transformedClassesDirectory, new FileAttribute[0]);
                }
                for (String tracedClass : tracedClasses) {
                    if (tracedClass.startsWith("io.quarkus.test.component")) continue;
                    bytecodeTransformers.add(new BytecodeTransformer(tracedClass, (cn, cv) -> new TracingClassVisitor((ClassVisitor)cv, (String)cn)));
                }
                if (!bytecodeTransformers.isEmpty()) {
                    Map map = bytecodeTransformers.stream().collect(Collectors.groupingBy(BytecodeTransformer::getClassToTransform, Collectors.mapping(BytecodeTransformer::getVisitorFunction, Collectors.toList())));
                    for (Map.Entry entry : map.entrySet()) {
                        ClassWriter writer;
                        byte[] bytecode;
                        String className = entry.getKey();
                        List transformations = entry.getValue();
                        String classFileName = className.replace('.', '/') + ".class";
                        try (InputStream in = testClassLoader.getResourceAsStream(classFileName);){
                            if (in == null) {
                                throw new IOException("Resource not found: " + classFileName);
                            }
                            bytecode = in.readAllBytes();
                        }
                        ClassReader reader = new ClassReader(bytecode);
                        ClassWriter visitor = writer = new ClassWriter(reader, 3);
                        for (BiFunction transformation : transformations) {
                            visitor = (ClassVisitor)transformation.apply(className, visitor);
                        }
                        reader.accept((ClassVisitor)visitor, 0);
                        bytecode = writer.toByteArray();
                        transformedClasses.put(className, bytecode);
                        if (transformedClassesDirectory == null) continue;
                        Path classFile = transformedClassesDirectory.resolve(classFileName.replace('/', '_').replace('$', '_'));
                        Files.write(classFile, bytecode, new OpenOption[0]);
                    }
                }
                generatedClasses.putAll(transformedClasses);
            }
            catch (IOException e) {
                throw new IllegalStateException("Error generating resources", e);
            }
        }
        catch (Throwable e) {
            if (buildShouldFail) {
                buildFailure = e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        finally {
            if (buildShouldFail && buildFailure == null) {
                throw new AssertionError((Object)"The container build was expected to fail!");
            }
        }
        LOG.debugf("Component container for %s built in %s ms, using CL: %s", (Object)testClass.getSimpleName(), (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start), (Object)ComponentContainer.class.getClassLoader().getClass().getSimpleName());
        return new BuildResult(generatedClasses, (byte[])componentsProvider.get(), configMappings, interceptorMethods, buildFailure);
    }

    private static BeanRegistrar registrarForMock(final Class<?> testClass, final MockBeanConfiguratorImpl<?> mock) {
        return new BeanRegistrar(){

            public void register(BeanRegistrar.RegistrationContext context) {
                BeanConfigurator configurator = context.configure(mock.beanClass);
                configurator.scope(mock.scope);
                mock.jandexTypes().forEach(arg_0 -> ((BeanConfigurator)configurator).addType(arg_0));
                mock.jandexQualifiers().forEach(arg_0 -> ((BeanConfigurator)configurator).addQualifier(arg_0));
                if (mock.name != null) {
                    configurator.name(mock.name);
                }
                configurator.alternative(mock.alternative);
                if (mock.priority != null) {
                    configurator.priority(mock.priority.intValue());
                }
                if (mock.defaultBean) {
                    configurator.defaultBean();
                }
                String key = MockBeanCreator.registerCreate(testClass.getName(), (Function)ComponentContainer.cast(mock.create));
                ((BeanConfigurator)((BeanConfigurator)configurator.creator(MockBeanCreator.class)).param("createKey", key)).done();
            }
        };
    }

    private static void indexComponentClass(Indexer indexer, Class<?> componentClass) {
        try {
            while (componentClass != null) {
                indexer.indexClass(componentClass);
                for (Annotation annotation : componentClass.getAnnotations()) {
                    indexer.indexClass(annotation.annotationType());
                }
                for (Field field : componentClass.getDeclaredFields()) {
                    ComponentContainer.indexAnnotatedElement(indexer, field);
                }
                for (Method method : componentClass.getDeclaredMethods()) {
                    ComponentContainer.indexAnnotatedElement(indexer, method);
                    for (Parameter param : method.getParameters()) {
                        ComponentContainer.indexAnnotatedElement(indexer, param);
                    }
                }
                for (Class<?> iface : componentClass.getInterfaces()) {
                    ComponentContainer.indexComponentClass(indexer, iface);
                }
                componentClass = componentClass.getSuperclass();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to index:" + String.valueOf(componentClass), e);
        }
    }

    private static void indexAnnotatedElement(Indexer indexer, AnnotatedElement element) throws IOException {
        for (Annotation annotation : element.getAnnotations()) {
            indexer.indexClass(annotation.annotationType());
        }
    }

    private static List<Field> findInjectFields(Class<?> testClass, boolean scanEnclosingClasses) {
        List<Field> injectSpies;
        Class<? extends Annotation> injectSpy = ComponentContainer.loadInjectSpy();
        List<Class<? extends Annotation>> injectAnnotations = injectSpy != null ? List.of(Inject.class, InjectMock.class, injectSpy) : List.of(Inject.class, InjectMock.class);
        List<Field> found = ComponentContainer.findFields(testClass, injectAnnotations);
        if (scanEnclosingClasses) {
            for (Class<?> enclosing = testClass.getEnclosingClass(); enclosing != null; enclosing = enclosing.getEnclosingClass()) {
                found.addAll(ComponentContainer.findFields(enclosing, injectAnnotations));
            }
        }
        if (injectSpy != null && !(injectSpies = found.stream().filter(f -> f.isAnnotationPresent(injectSpy)).toList()).isEmpty()) {
            throw new IllegalStateException("@InjectSpy is not supported by QuarkusComponentTest: " + String.valueOf(injectSpies));
        }
        return found;
    }

    private static Class<? extends Annotation> loadInjectSpy() {
        try {
            return Class.forName("io.quarkus.test.junit.mockito.InjectSpy");
        }
        catch (Throwable e) {
            return null;
        }
    }

    private static List<Parameter> findInjectParams(Class<?> testClass) {
        List<Method> testMethods = ComponentContainer.findMethods(testClass, QuarkusComponentTestExtension::isTestMethod);
        ArrayList<Parameter> ret = new ArrayList<Parameter>();
        for (Method method : testMethods) {
            for (Parameter param : method.getParameters()) {
                if (BUILTIN_PARAMETER.test(param) || param.isAnnotationPresent(SkipInject.class)) continue;
                ret.add(param);
            }
        }
        return ret;
    }

    private static List<Parameter> findInjectMockParams(Class<?> testClass) {
        List<Method> testMethods = ComponentContainer.findMethods(testClass, QuarkusComponentTestExtension::isTestMethod);
        ArrayList<Parameter> ret = new ArrayList<Parameter>();
        for (Method method : testMethods) {
            for (Parameter param : method.getParameters()) {
                if (!param.isAnnotationPresent(InjectMock.class) || BUILTIN_PARAMETER.test(param)) continue;
                ret.add(param);
            }
        }
        return ret;
    }

    static boolean isTestMethod(Executable method) {
        return method.isAnnotationPresent(Test.class) || method.isAnnotationPresent(ParameterizedTest.class) || method.isAnnotationPresent(RepeatedTest.class);
    }

    private static List<Field> findFields(Class<?> testClass, List<Class<? extends Annotation>> annotations) {
        ArrayList<Field> fields = new ArrayList<Field>();
        Class<?> current = testClass;
        while (current.getSuperclass() != null) {
            block1: for (Field field : current.getDeclaredFields()) {
                for (Class<? extends Annotation> annotation : annotations) {
                    if (!field.isAnnotationPresent(annotation)) continue;
                    fields.add(field);
                    continue block1;
                }
            }
            current = current.getSuperclass();
        }
        return fields;
    }

    private static List<Method> findMethods(Class<?> testClass, Predicate<Method> methodPredicate) {
        ArrayList<Method> methods = new ArrayList<Method>();
        Class<?> current = testClass;
        while (current.getSuperclass() != null) {
            for (Method method : current.getDeclaredMethods()) {
                if (!methodPredicate.test(method)) continue;
                methods.add(method);
            }
            current = current.getSuperclass();
        }
        return methods;
    }

    private static Set<AnnotationInstance> getQualifiers(AnnotatedElement element, Collection<DotName> qualifiers) {
        Annotation[] annotations;
        HashSet<AnnotationInstance> ret = new HashSet<AnnotationInstance>();
        for (Annotation annotation : annotations = element.getDeclaredAnnotations()) {
            if (!qualifiers.contains(DotName.createSimple(annotation.annotationType()))) continue;
            ret.add(Annotations.jandexAnnotation((Annotation)annotation));
        }
        return ret;
    }

    private static boolean isListRequiredType(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return List.class.equals((Object)parameterizedType.getRawType());
        }
        return false;
    }

    static boolean isListAllInjectionPoint(Type requiredType, Annotation[] qualifiers, AnnotatedElement annotatedElement) {
        if (qualifiers.length > 0) {
            if (Arrays.stream(qualifiers).anyMatch(arg_0 -> ((All.Literal)All.Literal.INSTANCE).equals(arg_0))) {
                if (!ComponentContainer.isListRequiredType(requiredType)) {
                    throw new IllegalStateException("Invalid injection point type: " + String.valueOf(annotatedElement));
                }
                return true;
            }
        }
        return false;
    }

    static void adaptListAllQualifiers(Set<AnnotationInstance> qualifiers) {
        qualifiers.removeIf(a -> a.name().equals((Object)ALL_NAME));
        if (qualifiers.isEmpty()) {
            qualifiers.add(AnnotationInstance.builder(Default.class).build());
        }
    }

    static Type getFirstActualTypeArgument(Type requiredType) {
        if (requiredType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)requiredType;
            return parameterizedType.getActualTypeArguments()[0];
        }
        return null;
    }

    private static boolean injectionPointMatchesBean(Type injectionPointType, AnnotatedElement annotatedElement, List<DotName> allQualifiers, BeanResolver beanResolver, BeanInfo bean) {
        org.jboss.jandex.Type requiredType;
        Set<AnnotationInstance> requiredQualifiers = ComponentContainer.getQualifiers(annotatedElement, allQualifiers);
        if (ComponentContainer.isListAllInjectionPoint(injectionPointType, (Annotation[])Arrays.stream(annotatedElement.getAnnotations()).filter(a -> allQualifiers.contains(DotName.createSimple(a.annotationType()))).toArray(Annotation[]::new), annotatedElement)) {
            requiredType = Types.jandexType((Type)ComponentContainer.getFirstActualTypeArgument(injectionPointType));
            ComponentContainer.adaptListAllQualifiers(requiredQualifiers);
        } else {
            requiredType = Instance.class.isAssignableFrom(QuarkusComponentTestConfiguration.getRawType(injectionPointType)) ? Types.jandexType((Type)ComponentContainer.getFirstActualTypeArgument(injectionPointType)) : Types.jandexType((Type)injectionPointType);
        }
        return beanResolver.matches(bean, requiredType, requiredQualifiers);
    }

    private static File getTestOutputDirectory(Class<?> testClass) {
        File testOutputDirectory;
        String outputDirectory = System.getProperty(QUARKUS_TEST_COMPONENT_OUTPUT_DIRECTORY);
        if (outputDirectory != null) {
            testOutputDirectory = new File(outputDirectory);
        } else {
            String testClassResourceName = ClassLoaderHelper.fromClassNameToResourceName((String)testClass.getName());
            String testPath = testClass.getClassLoader().getResource(testClassResourceName).toString();
            String testClassesRootPath = testPath.substring(0, testPath.length() - testClassResourceName.length() - 1);
            testOutputDirectory = new File(URI.create(testClassesRootPath));
        }
        if (!testOutputDirectory.canWrite()) {
            throw new IllegalStateException("Invalid test output directory: " + String.valueOf(testOutputDirectory));
        }
        return testOutputDirectory;
    }

    private static boolean isSatisfied(org.jboss.jandex.Type requiredType, Set<AnnotationInstance> qualifiers, InjectionPointInfo injectionPoint, Iterable<BeanInfo> beans, BeanDeployment beanDeployment, QuarkusComponentTestConfiguration configuration) {
        for (BeanInfo beanInfo : beans) {
            if (!Beans.matches((BeanInfo)beanInfo, (org.jboss.jandex.Type)requiredType, qualifiers)) continue;
            LOG.debugf("Injection point %s satisfied by %s", (Object)injectionPoint.getTargetInfo(), (Object)beanInfo.toString());
            return true;
        }
        for (MockBeanConfiguratorImpl mockBeanConfiguratorImpl : configuration.mockConfigurators) {
            if (!mockBeanConfiguratorImpl.matches(beanDeployment.getBeanResolver(), requiredType, qualifiers)) continue;
            LOG.debugf("Injection point %s satisfied by %s", (Object)injectionPoint.getTargetInfo(), (Object)mockBeanConfiguratorImpl);
            return true;
        }
        return false;
    }

    private static void processTestInterceptorMethods(Class<?> testClass, BeanRegistrar.RegistrationContext registrationContext, Set<String> interceptorBindings, Map<String, String[]> interceptorMethods) {
        List<Class<AroundConstruct>> annotations = List.of(AroundInvoke.class, PostConstruct.class, PreDestroy.class, AroundConstruct.class);
        Predicate<Method> predicate = m -> {
            for (Class annotation : annotations) {
                if (!m.isAnnotationPresent(annotation)) continue;
                return true;
            }
            return false;
        };
        for (Method method : ComponentContainer.findMethods(testClass, predicate)) {
            InterceptionType interceptionType;
            Set<Annotation> bindings = ComponentContainer.findBindings(method, interceptorBindings);
            if (bindings.isEmpty()) {
                throw new IllegalStateException("No bindings declared on a test interceptor method: " + String.valueOf(method));
            }
            ComponentContainer.validateTestInterceptorMethod(method);
            String key = UUID.randomUUID().toString();
            interceptorMethods.put(key, InterceptorMethodCreator.descriptor(method));
            if (method.isAnnotationPresent(AroundInvoke.class)) {
                interceptionType = InterceptionType.AROUND_INVOKE;
            } else if (method.isAnnotationPresent(PostConstruct.class)) {
                interceptionType = InterceptionType.POST_CONSTRUCT;
            } else if (method.isAnnotationPresent(PreDestroy.class)) {
                interceptionType = InterceptionType.PRE_DESTROY;
            } else if (method.isAnnotationPresent(AroundConstruct.class)) {
                interceptionType = InterceptionType.AROUND_CONSTRUCT;
            } else {
                throw new IllegalStateException("No interceptor annotation declared on: " + String.valueOf(method));
            }
            int priority = 1;
            Priority priorityAnnotation = method.getAnnotation(Priority.class);
            if (priorityAnnotation != null) {
                priority = priorityAnnotation.value();
            }
            ((InterceptorConfigurator)registrationContext.configureInterceptor(interceptionType).identifier(key).priority(priority).bindings((AnnotationInstance[])bindings.stream().map(Annotations::jandexAnnotation).toArray(AnnotationInstance[]::new)).param("createKey", key)).creator(InterceptorMethodCreator.class);
        }
    }

    private static void validateTestInterceptorMethod(Method method) {
        Object[] params = method.getParameters();
        if (params.length != 1 || !InvocationContext.class.isAssignableFrom(params[0].getType())) {
            throw new IllegalStateException("A test interceptor method must declare exactly one InvocationContext parameter:" + Arrays.toString(params));
        }
    }

    private static Set<Annotation> findBindings(Method method, Set<String> bindings) {
        return Arrays.stream(method.getAnnotations()).filter(a -> bindings.contains(a.annotationType().getName())).collect(Collectors.toSet());
    }

    static <T> T cast(Object obj) {
        return (T)obj;
    }

    private static class BeforeIndexContextImpl
    extends QuarkusComponentTestExtension.ComponentTestContextImpl
    implements QuarkusComponentTestCallbacks.BeforeIndexContext {
        private final Set<Class<?>> componentClasses;
        private final List<Class<?>> additionalComponentsClasses;

        BeforeIndexContextImpl(Class<?> testClass, Set<Class<?>> componentClasses) {
            super(testClass);
            this.componentClasses = componentClasses;
            this.additionalComponentsClasses = new ArrayList();
        }

        @Override
        public Set<Class<?>> getComponentClasses() {
            return this.componentClasses;
        }

        @Override
        public void addComponentClass(Class<?> componentClass) {
            this.additionalComponentsClasses.add(componentClass);
        }
    }

    private static class BeforeBulidContextImpl
    extends QuarkusComponentTestExtension.ComponentTestContextImpl
    implements QuarkusComponentTestCallbacks.BeforeBuildContext {
        private final IndexView immutableBeanArchiveIndex;
        private final IndexView computingBeanArchiveIndex;
        private final List<BytecodeTransformer> bytecodeTransformers;
        private final List<AnnotationTransformation> annotationTransformations;
        private final List<BeanRegistrar> beanRegistrars;

        private BeforeBulidContextImpl(Class<?> testClass, IndexView immutableBeanArchiveIndex, IndexView computingBeanArchiveIndex, List<BytecodeTransformer> bytecodeTransformers, List<AnnotationTransformation> annotationTransformations, List<BeanRegistrar> beanRegistrars) {
            super(testClass);
            this.immutableBeanArchiveIndex = immutableBeanArchiveIndex;
            this.computingBeanArchiveIndex = computingBeanArchiveIndex;
            this.bytecodeTransformers = bytecodeTransformers;
            this.annotationTransformations = annotationTransformations;
            this.beanRegistrars = beanRegistrars;
        }

        @Override
        public IndexView getImmutableBeanArchiveIndex() {
            return this.immutableBeanArchiveIndex;
        }

        @Override
        public IndexView getComputingBeanArchiveIndex() {
            return this.computingBeanArchiveIndex;
        }

        @Override
        public void addAnnotationTransformation(AnnotationTransformation transformation) {
            this.annotationTransformations.add(transformation);
        }

        @Override
        public void addBeanRegistrar(BeanRegistrar beanRegistrar) {
            this.beanRegistrars.add(beanRegistrar);
        }

        @Override
        public void addBytecodeTransformer(BytecodeTransformer bytecodeTransformer) {
            this.bytecodeTransformers.add(bytecodeTransformer);
        }
    }

    public static class TracingClassVisitor
    extends ClassVisitor {
        private final String className;

        public TracingClassVisitor(ClassVisitor classVisitor, String theClassName) {
            super(589824, classVisitor);
            this.className = theClassName;
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            MethodVisitor mv = super.visitMethod(access, name, descriptor, signature, exceptions);
            if (name.equals("<init>") || name.equals("<clinit>")) {
                return mv;
            }
            LOG.debugf("Trace method %s#%s:%s", (Object)this.className, (Object)name, (Object)descriptor);
            return new MethodVisitor(589824, mv){

                public void visitCode() {
                    super.visitCode();
                    this.visitLdcInsn(className);
                    this.visitMethodInsn(184, TracingHandler.class.getName().replace(".", "/"), "trace", "(Ljava/lang/String;)V", false);
                }
            };
        }
    }
}

